/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.proxy;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.List;
import scouter.agent.Logger;
import scouter.agent.proxy.IHttpTrace;
import scouter.agent.proxy.LoaderManager;
import scouter.agent.trace.TraceContext;
import scouter.agent.util.ClassUtils;

public class HttpTraceFactory {
    private static final String HTTP_TRACE = "scouter.xtra.http.HttpTrace";
    private static final String HTTP_TRACE3 = "scouter.xtra.http.HttpTrace3";
    private static final String HTTP_TRACE4 = "scouter.xtra.http.jakarta.JakartaHttpTrace";
    private static final String HTTP_TRACE_WEBFLUX = "scouter.xtra.http.WebfluxHttpTrace";
    public static final IHttpTrace dummy = new IHttpTrace(){

        @Override
        public String getParameter(Object req, String key) {
            return null;
        }

        @Override
        public String getHeader(Object req, String key) {
            return null;
        }

        @Override
        public String getCookie(Object req, String key) {
            return null;
        }

        @Override
        public String getRequestURI(Object req) {
            return null;
        }

        @Override
        public String getRequestId(Object req) {
            return null;
        }

        @Override
        public String getRemoteAddr(Object req) {
            return null;
        }

        @Override
        public String getMethod(Object req) {
            return null;
        }

        @Override
        public String getQueryString(Object req) {
            return null;
        }

        @Override
        public Object getAttribute(Object req, String key) {
            return null;
        }

        @Override
        public Enumeration getParameterNames(Object req) {
            return null;
        }

        @Override
        public Enumeration getHeaderNames(Object req) {
            return null;
        }

        public Object subscriptOnContext(Object mono0, TraceContext traceContext) {
            return mono0;
        }

        @Override
        public void start(TraceContext ctx, Object req, Object res) {
        }

        @Override
        public void end(TraceContext ctx, Object req, Object res) {
        }

        @Override
        public void rejectText(Object res, String text) {
        }

        @Override
        public void rejectUrl(Object res, String url) {
        }

        @Override
        public void addAsyncContextListener(Object ac) {
        }

        @Override
        public TraceContext getTraceContextFromAsyncContext(Object oAsyncContext) {
            return null;
        }

        @Override
        public void setDispatchTransferMap(Object oAsyncContext, long gxid, long caller, long callee, byte xType) {
        }

        @Override
        public void setSelfDispatch(Object oAsyncContext, boolean self) {
        }

        @Override
        public boolean isSelfDispatch(Object oAsyncContext) {
            return false;
        }

        public void contextOperatorHook() {
        }
    };

    public static IHttpTrace create(ClassLoader parent, Object oReq) {
        try {
            ClassLoader loader = LoaderManager.getHttpLoader(parent);
            if (loader == null) {
                return dummy;
            }
            Class<?> c = null;
            boolean reactive = true;
            try {
                Method m = oReq.getClass().getMethod("mutate", new Class[0]);
                c = Class.forName(HTTP_TRACE_WEBFLUX, true, loader);
            }
            catch (Exception e) {
                reactive = false;
            }
            if (!reactive) {
                boolean servlet = true;
                boolean jakarta = false;
                try {
                    Method method = oReq.getClass().getMethod("logout", new Class[0]);
                }
                catch (Exception e) {
                    servlet = false;
                }
                if (servlet && HttpTraceFactory.implemented(oReq.getClass(), "jakarta")) {
                    jakarta = true;
                }
                c = servlet ? (jakarta ? Class.forName(HTTP_TRACE4, true, loader) : Class.forName(HTTP_TRACE3, true, loader)) : Class.forName(HTTP_TRACE, true, loader);
            }
            return (IHttpTrace)c.newInstance();
        }
        catch (Throwable e) {
            Logger.println("A133", "fail to create", e);
            return dummy;
        }
    }

    static boolean implemented(Class<?> clazz, String interfaceNamePrefix) {
        List<Class<?>> interfaces = ClassUtils.getAllInterfaces(clazz);
        for (Class<?> interfaceClass : interfaces) {
            if (!interfaceClass.getPackage().getName().startsWith(interfaceNamePrefix)) continue;
            return true;
        }
        return false;
    }
}

