/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.proxy;

import scouter.agent.Logger;
import scouter.agent.proxy.IRedissonTrace;
import scouter.agent.proxy.LoaderManager;
import scouter.agent.trace.TraceContext;

public class RedissonTraceFactory {
    private static IRedissonTrace redissonTrace;
    private static Object lock;
    private static final String CLIENT = "scouter.xtra.redis.RedissonTracer";
    public static final IRedissonTrace dummy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRedissonTrace create(ClassLoader parent) {
        try {
            if (redissonTrace == null) {
                Object object = lock;
                synchronized (object) {
                    if (redissonTrace == null) {
                        ClassLoader loader = LoaderManager.getRedisClient(parent);
                        if (loader == null) {
                            Logger.println("Lettuce Client Load Error.. Dummy Loaded");
                            redissonTrace = dummy;
                        } else {
                            Class<?> c = Class.forName(CLIENT, true, loader);
                            redissonTrace = (IRedissonTrace)c.newInstance();
                        }
                    }
                }
            }
            return redissonTrace;
        }
        catch (Throwable e) {
            e.printStackTrace();
            Logger.println("SC-146.1", "fail to create", e);
            return dummy;
        }
    }

    static {
        lock = new Object();
        dummy = new IRedissonTrace(){

            @Override
            public void startRedis(TraceContext ctx, Object channel) {
            }

            @Override
            public String getCommand(Object command) {
                return null;
            }

            @Override
            public String parseArgs(Object object) {
                return null;
            }
        };
    }
}

