/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.util;

import java.lang.instrument.ClassDefinition;
import java.util.ArrayList;
import scouter.agent.JavaAgent;
import scouter.agent.Logger;
import scouter.agent.netio.data.DataProxy;
import scouter.agent.summary.ErrorData;
import scouter.agent.summary.ServiceSummary;
import scouter.agent.util.DumpUtil;
import scouter.agent.util.LeakInfo;
import scouter.agent.util.LeakInfo2;
import scouter.lang.pack.AlertPack;
import scouter.lang.value.MapValue;
import scouter.util.ClassUtil;
import scouter.util.RequestQueue;
import scouter.util.StringSet;
import scouter.util.SystemUtil;
import scouter.util.ThreadUtil;

public class AsyncRunner
extends Thread {
    private static AsyncRunner instance = null;
    private RequestQueue<Object> queue = new RequestQueue(1024);

    public static final synchronized AsyncRunner getInstance() {
        if (instance == null) {
            instance = new AsyncRunner();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    public void add(ClassLoader loader, String classname, byte[] body) {
        this.queue.put(new Hook(loader, classname, body));
    }

    public void add(LeakInfo data) {
        this.queue.put(data);
    }

    public void add(LeakInfo2 data) {
        this.queue.put(data);
    }

    public void add(Runnable r) {
        this.queue.put(r);
    }

    public void add(StringSet classnames) {
        this.queue.put(new RedefineClasses(classnames));
    }

    @Override
    public void run() {
        while (true) {
            Object m = this.queue.get(1000L);
            try {
                if (m instanceof Hook) {
                    this.hooking((Hook)m);
                    continue;
                }
                if (m instanceof LeakInfo) {
                    this.alert((LeakInfo)m);
                    continue;
                }
                if (m instanceof LeakInfo2) {
                    this.alert((LeakInfo2)m);
                    continue;
                }
                if (m instanceof Runnable) {
                    this.process((Runnable)m);
                    continue;
                }
                if (!(m instanceof RedefineClasses)) continue;
                this.redefine(((RedefineClasses)m).classnames);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void redefine(StringSet clazzes) {
        Class[] loadedClasses = JavaAgent.getInstrumentation().getAllLoadedClasses();
        ArrayList<ClassDefinition> definitionList = new ArrayList<ClassDefinition>();
        boolean allSuccess = true;
        for (int i = 0; i < loadedClasses.length; ++i) {
            if (!clazzes.hasKey(loadedClasses[i].getName())) continue;
            try {
                byte[] buff = ClassUtil.getByteCode(loadedClasses[i]);
                if (buff == null) continue;
                definitionList.add(new ClassDefinition(loadedClasses[i], buff));
                continue;
            }
            catch (Exception e) {
                allSuccess = false;
                break;
            }
        }
        if (definitionList.size() > 0 && allSuccess) {
            try {
                JavaAgent.getInstrumentation().redefineClasses(definitionList.toArray(new ClassDefinition[definitionList.size()]));
            }
            catch (Throwable th) {
                Logger.println("A183", "redefine error : " + loadedClasses);
            }
        }
    }

    private void process(Runnable r) {
        r.run();
    }

    private void alert(LeakInfo leakInfo) {
        ServiceSummary summary = ServiceSummary.getInstance();
        MapValue mv = new MapValue();
        mv.put(AlertPack.HASH_FLAG + "service" + "_service-name", leakInfo.serviceHash);
        if (leakInfo.fullstack) {
            ErrorData d = summary.process(leakInfo.error, 0, leakInfo.serviceHash, leakInfo.txid, 0, 0);
            Logger.println("A156", leakInfo.error + " " + leakInfo.inner);
            if (d != null && d.fullstack == 0) {
                String fullstack = ThreadUtil.getStackTrace(leakInfo.error.getStackTrace(), leakInfo.fullstackSkip);
                d.fullstack = DataProxy.sendError(fullstack);
                Logger.println("A157", fullstack);
            }
            mv.put(AlertPack.HASH_FLAG + "error" + "_full-stack", d.fullstack);
        } else {
            summary.process(leakInfo.error, 0, leakInfo.serviceHash, leakInfo.txid, 0, 0);
            Logger.println("A179", leakInfo.error + " " + leakInfo.inner);
        }
        DataProxy.sendAlert((byte)1, "CONNECTION_NOT_CLOSE", "Connection may not closed", mv);
    }

    private void alert(LeakInfo2 leakInfo2) {
        ServiceSummary summary = ServiceSummary.getInstance();
        MapValue mv = new MapValue();
        mv.put(AlertPack.HASH_FLAG + "service" + "_service-name", leakInfo2.serviceHash);
        if (leakInfo2.fullstack) {
            ErrorData d = summary.process(leakInfo2.error, 0, leakInfo2.serviceHash, leakInfo2.txid, 0, 0);
            Logger.println("A156", leakInfo2.error + " " + leakInfo2.innerObject);
            if (d != null && d.fullstack == 0) {
                String fullstack = ThreadUtil.getStackTrace(leakInfo2.error.getStackTrace(), leakInfo2.fullstackSkip);
                d.fullstack = DataProxy.sendError(fullstack);
                Logger.println("A157", fullstack);
            }
            mv.put(AlertPack.HASH_FLAG + "error" + "_full-stack", d.fullstack);
        } else {
            summary.process(leakInfo2.error, 0, leakInfo2.serviceHash, leakInfo2.txid, 0, 0);
            Logger.println("A179", leakInfo2.error + " " + leakInfo2.innerObject);
        }
        DataProxy.sendAlert((byte)1, "CONNECTION_NOT_CLOSE", "Connection may not closed", mv);
        if (DumpUtil.conf._trace) {
            Logger.trace("[Force-Close-InnerObject]" + System.identityHashCode(leakInfo2.innerObject));
        }
        boolean closeResult = leakInfo2.closeManager.close(leakInfo2.innerObject);
    }

    private void hooking(Hook m) {
        if (SystemUtil.IS_AIX && SystemUtil.IS_JAVA_1_5) {
            return;
        }
        try {
            Class<?> cls = Class.forName(m.classname, false, m.loader);
            ClassDefinition[] cd = new ClassDefinition[]{new ClassDefinition(cls, m.body)};
            JavaAgent.getInstrumentation().redefineClasses(cd);
        }
        catch (Throwable t) {
            Logger.println("A149", "async hook fail:" + m.classname + " " + t);
        }
    }

    private static class Hook {
        ClassLoader loader;
        String classname;
        byte[] body;

        public Hook(ClassLoader loader, String classname, byte[] body) {
            this.loader = loader;
            this.classname = classname.replace('/', '.');
            this.body = body;
        }
    }

    private static class RedefineClasses {
        StringSet classnames;

        public RedefineClasses(StringSet classnames) {
            this.classnames = classnames;
        }
    }
}

