/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.pack;

import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.Pack;
import scouter.lang.value.FloatValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.NumberValue;
import scouter.lang.value.Value;

public class InteractionPerfCounterPack
implements Pack {
    public long time;
    public String objName;
    public String interactionType;
    public int fromHash;
    public int toHash;
    public int period;
    public int count;
    public int errorCount;
    public long totalElapsed;
    public MapValue customData = new MapValue();

    public InteractionPerfCounterPack() {
    }

    public InteractionPerfCounterPack(String objName, String interactionType) {
        this.objName = objName;
        this.interactionType = interactionType;
    }

    @Override
    public byte getPackType() {
        return 65;
    }

    @Override
    public void write(DataOutputX dout) throws IOException {
        dout.writeLong(this.time);
        dout.writeText(this.objName);
        dout.writeText(this.interactionType);
        dout.writeInt(this.fromHash);
        dout.writeInt(this.toHash);
        dout.writeInt(this.period);
        dout.writeInt(this.count);
        dout.writeInt(this.errorCount);
        dout.writeLong(this.totalElapsed);
        dout.writeValue(this.customData);
    }

    @Override
    public Pack read(DataInputX din) throws IOException {
        this.time = din.readLong();
        this.objName = din.readText();
        this.interactionType = din.readText();
        this.fromHash = din.readInt();
        this.toHash = din.readInt();
        this.period = din.readInt();
        this.count = din.readInt();
        this.errorCount = din.readInt();
        this.totalElapsed = din.readLong();
        this.customData = (MapValue)din.readValue();
        return this;
    }

    public void putCustom(String key, Object o) {
        if (o instanceof Number) {
            this.customData.put(key, new FloatValue(((Number)o).floatValue()));
        }
    }

    public void putCustom(String key, Value value) {
        this.customData.put(key, value);
    }

    public void addCustom(String key, NumberValue value) {
        Value old = this.customData.get(key);
        if (old == null) {
            this.customData.put(key, value);
        } else if (old instanceof NumberValue) {
            ((NumberValue)old).add(value);
        }
    }

    public String toString() {
        return "PerfInteractionCounterPack{time=" + this.time + ", objName='" + this.objName + '\'' + ", interactionType='" + this.interactionType + '\'' + ", fromHash='" + this.fromHash + '\'' + ", toHash='" + this.toHash + '\'' + ", period=" + this.period + ", count=" + this.count + ", errorCount=" + this.errorCount + ", totalElapsed=" + this.totalElapsed + ", customData=" + this.customData + '}';
    }
}

