/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.value;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.TextValue;
import scouter.lang.value.Value;

public class MapValue
implements Value {
    protected Hashtable<String, Value> table = new Hashtable();

    public static MapValue ofStringValueMap(Map<String, String> map) {
        LinkedHashMap<String, Value> tempTable = new LinkedHashMap<String, Value>();
        for (Map.Entry<String, String> e : map.entrySet()) {
            tempTable.put(e.getKey(), new TextValue(e.getValue()));
        }
        MapValue newMapValue = new MapValue();
        newMapValue.putAll(tempTable);
        return newMapValue;
    }

    public int size() {
        return this.table.size();
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.table.containsKey(key);
    }

    public Enumeration<String> keys() {
        return this.table.keys();
    }

    public Set<String> keySet() {
        return this.table.keySet();
    }

    public Value get(String key) {
        return this.table.get(key);
    }

    public boolean getBoolean(String key) {
        Value v = this.get(key);
        if (v instanceof BooleanValue) {
            return ((BooleanValue)v).value;
        }
        return false;
    }

    public int getInt(String key) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).intValue();
        }
        return 0;
    }

    public long getLong(String key) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).longValue();
        }
        return 0L;
    }

    public float getFloat(String key) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return (float)((Number)((Object)v)).doubleValue();
        }
        return 0.0f;
    }

    public String getText(String key) {
        Value v = this.get(key);
        if (v instanceof TextValue) {
            return ((TextValue)v).value;
        }
        return null;
    }

    public Value put(String key, Value value) {
        return this.table.put(key, value);
    }

    public Value put(String key, String value) {
        return this.put(key, new TextValue(value));
    }

    public Value put(String key, long value) {
        return this.put(key, new DecimalValue(value));
    }

    public Value remove(String key) {
        return this.table.remove(key);
    }

    public void clear() {
        this.table.clear();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator<Map.Entry<String, Value>> en = this.table.entrySet().iterator();
        buf.append("{");
        while (en.hasNext()) {
            if (buf.length() > 1) {
                buf.append(",");
            }
            Map.Entry<String, Value> e = en.next();
            buf.append(e.getKey() + "=" + e.getValue());
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public byte getValueType() {
        return 80;
    }

    @Override
    public void write(DataOutputX dout) throws IOException {
        dout.writeDecimal(this.table.size());
        for (Map.Entry<String, Value> e : this.table.entrySet()) {
            dout.writeText(e.getKey());
            dout.writeValue(e.getValue());
        }
    }

    @Override
    public Value read(DataInputX din) throws IOException {
        int count = (int)din.readDecimal();
        for (int t = 0; t < count; ++t) {
            String key = din.readText();
            Value value = din.readValue();
            this.put(key, value);
        }
        return this;
    }

    public ListValue newList(String name) {
        ListValue list = new ListValue();
        this.put(name, list);
        return list;
    }

    public ListValue getList(String key) {
        return (ListValue)this.table.get(key);
    }

    public ListValue getListNotNull(String key) {
        ListValue lv = (ListValue)this.table.get(key);
        return lv == null ? new ListValue() : lv;
    }

    @Override
    public Object toJavaObject() {
        return this.table;
    }

    public Map<String, Value> toMap() {
        return this.table;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapValue other = (MapValue)obj;
        return !(this.table == null ? other.table != null : !this.table.equals(other.table));
    }

    public void putAll(Map<String, Value> m) {
        this.table.putAll(m);
    }
}

