/*
 * Decompiled with CFR 0.152.
 */
package scouter.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import scouter.lang.Counter;
import scouter.lang.Family;
import scouter.lang.ObjectType;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.ObjectPack;
import scouter.server.Configure;
import scouter.server.Logger;
import scouter.server.util.XmlUtil;
import scouter.util.FileUtil;

public class CounterManager {
    private static final String CUSTOM_FILENAME = "counters.site.xml";
    private static volatile CounterManager instance;
    CounterEngine engine = new CounterEngine();
    File customFile;
    byte[] xmlContent;
    byte[] xmlCustomContent;
    private Document unsafeDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CounterManager getInstance() {
        if (instance != null) return instance;
        Class<CounterManager> clazz = CounterManager.class;
        synchronized (CounterManager.class) {
            if (instance != null) return instance;
            instance = new CounterManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CounterManager() {
        this.init();
    }

    private void init() {
        this.readAndParseXml("/scouter/lang/counters/counters.xml");
        this.customFile = new File("./conf/counters.site.xml");
        if (this.customFile.canRead()) {
            this.xmlCustomContent = FileUtil.readAll(this.customFile);
            this.engine.parse(this.xmlCustomContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndParseXml(String path) {
        InputStream in = CounterEngine.class.getResourceAsStream(path);
        try {
            this.xmlContent = FileUtil.readAll(in);
            this.engine.parse(this.xmlContent);
        }
        catch (Exception e) {
            Logger.println("Failed read " + path);
        }
        finally {
            FileUtil.close(in);
        }
    }

    public CounterEngine getCounterEngine() {
        return this.engine;
    }

    public byte[] getXmlContent() {
        return this.xmlContent;
    }

    public byte[] getXmlCustomContent() {
        return this.xmlCustomContent;
    }

    public synchronized boolean safelyAddFamily(Family family) {
        this.initUnsafeDoc();
        if (this.unsafeDoc == null) {
            return false;
        }
        Logger.trace("Family added or modified in Custom counter xml. Family - " + family.getName());
        Element newElement = this.unsafeDoc.createElement("Family");
        newElement.setAttribute("name", family.getName());
        newElement.setAttribute("master", family.getMaster());
        Element oldElement = this.findElementByTypeAndName("Family", family.getName());
        Element familiesElement = (Element)this.unsafeDoc.getElementsByTagName("Familys").item(0);
        for (Counter counter : family.listCounters()) {
            Element counterElement = this.unsafeDoc.createElement("Counter");
            counterElement.setAttribute("name", counter.getName());
            counterElement.setAttribute("disp", counter.getDisplayName());
            counterElement.setAttribute("unit", counter.getUnit());
            counterElement.setAttribute("icon", counter.getIcon());
            counterElement.setAttribute("all", counter.isAll() ? "true" : "false");
            counterElement.setAttribute("total", counter.isTotal() ? "true" : "false");
            newElement.appendChild(counterElement);
        }
        if (oldElement == null) {
            familiesElement.appendChild(newElement);
        } else {
            familiesElement.replaceChild(newElement, oldElement);
        }
        this.saveCustomContent();
        return true;
    }

    public synchronized boolean safelyAddObjectType(ObjectType objType2) {
        this.initUnsafeDoc();
        if (this.unsafeDoc == null) {
            return false;
        }
        Element newElement = this.unsafeDoc.createElement("ObjectType");
        CounterManager.setObjectTypeAttribute(this.unsafeDoc, newElement, objType2);
        Element oldElement = this.findElementByTypeAndName("ObjectType", objType2.getName());
        Element typesElements = (Element)this.unsafeDoc.getElementsByTagName("Types").item(0);
        if (oldElement == null) {
            typesElements.appendChild(newElement);
        } else {
            typesElements.replaceChild(newElement, oldElement);
        }
        this.saveCustomContent();
        return true;
    }

    private Element findElementByTypeAndName(String elementTagName, String nameAttrValue) {
        NodeList list = this.unsafeDoc.getElementsByTagName(elementTagName);
        if (list != null && list.getLength() > 0) {
            for (int i = 0; i < list.getLength(); ++i) {
                Element element;
                String name;
                Node node = list.item(i);
                if (node.getNodeType() != 1 || !nameAttrValue.equals(name = (element = (Element)node).getAttribute("name"))) continue;
                return element;
            }
        }
        return null;
    }

    private void saveCustomContent() {
        String resultString = XmlUtil.writeXmlFileWithIndent(this.unsafeDoc, this.customFile, 2);
        String normalizeCountersXml = null;
        try {
            normalizeCountersXml = this.normalizeCountersXml(resultString);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            normalizeCountersXml = resultString;
        }
        try {
            FileUtil.saveText(new File(this.customFile.getCanonicalPath()), normalizeCountersXml);
            this.xmlCustomContent = FileUtil.readAll(this.customFile);
            this.reloadEngine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initUnsafeDoc() {
        if (this.unsafeDoc == null) {
            this.unsafeDoc = this.getCustomDocument();
            if (this.unsafeDoc == null) {
                return;
            }
            Element rootElement = (Element)this.unsafeDoc.getElementsByTagName("Counters").item(0);
            Element familiesElement = (Element)this.unsafeDoc.getElementsByTagName("Familys").item(0);
            Element typesElements = (Element)this.unsafeDoc.getElementsByTagName("Types").item(0);
            if (rootElement == null) {
                rootElement = this.unsafeDoc.createElement("Counters");
                this.unsafeDoc.appendChild(rootElement);
            }
            if (familiesElement == null) {
                familiesElement = this.unsafeDoc.createElement("Familys");
                rootElement.appendChild(familiesElement);
            }
            if (typesElements == null) {
                typesElements = this.unsafeDoc.createElement("Types");
                rootElement.appendChild(typesElements);
            }
        }
    }

    public synchronized boolean addFamily(Family family) {
        Document doc = this.appendFamily(family, this.getCustomDocument());
        if (doc != null) {
            XmlUtil.writeXmlFileWithIndent(doc, this.customFile, 2);
            this.xmlCustomContent = FileUtil.readAll(this.customFile);
            this.reloadEngine();
            return true;
        }
        return false;
    }

    public synchronized boolean addFamilyAndObjectType(Family family, ObjectType objectType) {
        Document doc = this.appendFamily(family, this.getCustomDocument());
        if (doc != null && (doc = this.appendObjectType(objectType, doc)) != null) {
            XmlUtil.writeXmlFileWithIndent(doc, this.customFile, 2);
            this.xmlCustomContent = FileUtil.readAll(this.customFile);
            this.reloadEngine();
            return true;
        }
        return false;
    }

    public boolean addObjectType(MapPack param) {
        String name = param.getText("name");
        if (this.engine.getObjectType(name) != null) {
            return false;
        }
        String displayName = param.getText("disp");
        String family = param.getText("family");
        String icon = param.getText("icon");
        boolean subobject = param.getBoolean("sub-object");
        ObjectType objType2 = new ObjectType();
        objType2.setName(name);
        objType2.setDisplayName(displayName);
        objType2.setIcon(icon);
        objType2.setFamily(this.engine.getFamily(family));
        objType2.setSubObject(subobject);
        return this.addObjectType(objType2);
    }

    public boolean addObjectTypeIfNotExist(ObjectPack objectPack) {
        ObjectType detectedType;
        if (Configure.getInstance().log_udp_some_object.equals(objectPack.objType)) {
            System.out.println("DEBUG objType: " + objectPack.objType);
        }
        if (this.engine.getObjectType(objectPack.objType) != null) {
            return false;
        }
        String detected = objectPack.tags.getText("detected");
        if (Configure.getInstance().log_udp_some_object.equals(objectPack.objType)) {
            System.out.println("DEBUG objType: " + objectPack.objType + ", detected: " + detected);
        }
        if ((detectedType = this.engine.getObjectType(detected)) == null) {
            return false;
        }
        ObjectType objType2 = new ObjectType();
        objType2.setName(objectPack.objType);
        objType2.setDisplayName(objectPack.objType);
        objType2.setIcon(detectedType.getName());
        objType2.setFamily(detectedType.getFamily());
        objType2.setSubObject(detectedType.isSubObject());
        return this.addObjectType(objType2);
    }

    public synchronized boolean addObjectType(ObjectType objType2) {
        Document doc;
        if (Configure.getInstance().log_udp_some_object.equals(objType2.getName())) {
            System.out.println("DEBUG objType: " + objType2.getName() + ", will be added ");
        }
        if ((doc = this.appendObjectType(objType2, this.getCustomDocument())) != null) {
            String result = XmlUtil.writeXmlFileWithIndent(doc, this.customFile, 2);
            if (Configure.getInstance().log_udp_some_object.equals(objType2.getName())) {
                System.out.println("DEBUG objType: " + objType2.getName() + ", new XML = " + result);
            }
            return this.saveAndReloadCountersSiteXml(result);
        }
        return false;
    }

    public boolean editObjectType(MapPack param) {
        String name = param.getText("name");
        String displayName = param.getText("disp");
        String family = param.getText("family");
        String icon = param.getText("icon");
        boolean subobject = param.getBoolean("sub-object");
        ObjectType objType2 = new ObjectType();
        objType2.setName(name);
        objType2.setDisplayName(displayName);
        objType2.setIcon(icon);
        objType2.setFamily(this.engine.getFamily(family));
        objType2.setSubObject(subobject);
        return this.editObjectType(objType2);
    }

    public synchronized boolean editObjectType(ObjectType objType2) {
        Document doc = this.editOrAppendObjectType(objType2, this.getCustomDocument());
        if (doc != null) {
            XmlUtil.writeXmlFileWithIndent(doc, this.customFile, 2);
            this.xmlCustomContent = FileUtil.readAll(this.customFile);
            this.reloadEngine();
            return true;
        }
        return false;
    }

    private Document appendObjectType(ObjectType objType2, Document doc) {
        try {
            Element rootElement = (Element)doc.getElementsByTagName("Counters").item(0);
            Element typesElements = (Element)doc.getElementsByTagName("Types").item(0);
            if (rootElement == null) {
                rootElement = doc.createElement("Counters");
                doc.appendChild(rootElement);
            }
            if (typesElements == null) {
                typesElements = doc.createElement("Types");
                rootElement.appendChild(typesElements);
            }
            Element objElement = doc.createElement("ObjectType");
            CounterManager.setObjectTypeAttribute(doc, objElement, objType2);
            typesElements.appendChild(objElement);
        }
        catch (Exception e) {
            Logger.printStackTrace(e);
            return null;
        }
        return doc;
    }

    private Document editOrAppendObjectType(ObjectType objType2, Document doc) {
        try {
            NodeList list;
            Element rootElement = (Element)doc.getElementsByTagName("Counters").item(0);
            Element typesElements = (Element)doc.getElementsByTagName("Types").item(0);
            boolean found = false;
            if (rootElement == null) {
                rootElement = doc.createElement("Counters");
                doc.appendChild(rootElement);
            }
            if (typesElements == null) {
                typesElements = doc.createElement("Types");
                rootElement.appendChild(typesElements);
            }
            if ((list = doc.getElementsByTagName("ObjectType")) == null || list.getLength() < 1) {
                Element objElement = doc.createElement("ObjectType");
                CounterManager.setObjectTypeAttribute(doc, objElement, objType2);
                typesElements.appendChild(objElement);
                found = true;
            } else {
                for (int i = 0; i < list.getLength(); ++i) {
                    Node node = list.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element objElement = (Element)node;
                    String name = objElement.getAttribute("name");
                    if (!objType2.getName().equals(name)) continue;
                    CounterManager.setObjectTypeAttribute(doc, objElement, objType2);
                    found = true;
                    break;
                }
                if (!found) {
                    Element objElement = doc.createElement("ObjectType");
                    CounterManager.setObjectTypeAttribute(doc, objElement, objType2);
                    typesElements.appendChild(objElement);
                    found = true;
                }
            }
            if (found) {
                return doc;
            }
        }
        catch (Exception e) {
            Logger.printStackTrace(e);
            return null;
        }
        return null;
    }

    private static void setObjectTypeAttribute(Document doc, Element objElement, ObjectType objType2) {
        objElement.setAttribute("name", objType2.getName());
        objElement.setAttribute("disp", objType2.getDisplayName());
        objElement.setAttribute("family", objType2.getFamily().getName());
        objElement.setAttribute("icon", objType2.getIcon());
        objElement.setAttribute("sub-object", objType2.isSubObject() ? "true" : "false");
        for (Counter counter : objType2.listObjectTypeCounters()) {
            Element counterElement = doc.createElement("Counter");
            counterElement.setAttribute("name", counter.getName());
            counterElement.setAttribute("disp", counter.getDisplayName());
            counterElement.setAttribute("unit", counter.getUnit());
            counterElement.setAttribute("icon", counter.getIcon());
            counterElement.setAttribute("all", counter.isAll() ? "true" : "false");
            counterElement.setAttribute("total", counter.isTotal() ? "true" : "false");
            objElement.appendChild(counterElement);
        }
    }

    private Document appendFamily(Family family, Document doc) {
        try {
            Element rootElement = (Element)doc.getElementsByTagName("Counters").item(0);
            Element familysElement = (Element)doc.getElementsByTagName("Familys").item(0);
            if (rootElement == null) {
                rootElement = doc.createElement("Counters");
                doc.appendChild(rootElement);
            }
            if (familysElement == null) {
                familysElement = doc.createElement("Familys");
                rootElement.appendChild(familysElement);
            }
            Element familyElement = doc.createElement("Family");
            familyElement.setAttribute("name", family.getName());
            familyElement.setAttribute("master", family.getMaster());
            familysElement.appendChild(familyElement);
            for (Counter counter : family.listCounters()) {
                Element counterElement = doc.createElement("Counter");
                counterElement.setAttribute("name", counter.getName());
                counterElement.setAttribute("disp", counter.getDisplayName());
                counterElement.setAttribute("unit", counter.getUnit());
                counterElement.setAttribute("icon", counter.getIcon());
                counterElement.setAttribute("all", counter.isAll() ? "true" : "false");
                counterElement.setAttribute("total", counter.isTotal() ? "true" : "false");
                familyElement.appendChild(counterElement);
            }
        }
        catch (Exception e) {
            Logger.printStackTrace(e);
            return null;
        }
        return doc;
    }

    private Document getCustomDocument() {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            if (this.customFile.canRead()) {
                doc = builder.parse(this.customFile);
                doc.getDocumentElement().normalize();
            } else {
                doc = builder.newDocument();
            }
        }
        catch (Exception e) {
            Logger.printStackTrace(e);
        }
        return doc;
    }

    public static void main(String[] args) {
        File f = Configure.getInstance().getPropertyFile();
        System.out.println(f.getParent());
    }

    private boolean reloadEngine() {
        this.engine.clear();
        return this.engine.parse(this.xmlContent) && this.engine.parse(this.xmlCustomContent);
    }

    public String readCountersSiteXml() {
        if (this.customFile.exists() && this.customFile.canRead()) {
            String contents = FileUtil.load(this.customFile, "utf-8");
            return contents;
        }
        return "";
    }

    public boolean saveAndReloadCountersSiteXml(String contents) {
        try {
            String normalizeCountersXml = null;
            try {
                normalizeCountersXml = this.normalizeCountersXml(contents);
            }
            catch (JAXBException e) {
                e.printStackTrace();
                normalizeCountersXml = contents;
            }
            if (FileUtil.saveText(new File(this.customFile.getCanonicalPath()), normalizeCountersXml)) {
                this.xmlCustomContent = FileUtil.readAll(new File(this.customFile.getCanonicalPath()));
                return this.reloadEngine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public String normalizeCountersXml(String xmlString) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Counters0.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        Counters0 counters = (Counters0)unmarshaller.unmarshal((Reader)new StringReader(xmlString));
        if (counters.types == null) {
            counters.types = new Types0(new ArrayList<ObjectType0>());
        }
        List<ObjectType0> objectTypes = counters.types.objectType.stream().collect(Collectors.toMap(v -> v.name, v -> v, (x, y) -> y)).values().stream().collect(Collectors.toList());
        if (counters.familys == null) {
            counters.familys = new Familys0(new ArrayList<Family0>());
        }
        List<Family0> families = counters.familys.family.stream().filter(f -> !f.name.contains("zws-metric.")).filter(f -> !f.name.contains("zps-metric.")).collect(Collectors.toMap(v -> v.name, v -> v, (x, y) -> y)).values().stream().collect(Collectors.toList());
        Counters0 newCounters = new Counters0(new Types0(objectTypes), new Familys0(families));
        Marshaller mar = jaxbContext.createMarshaller();
        mar.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter stringWriter = new StringWriter();
        mar.marshal((Object)newCounters, (Writer)stringWriter);
        return stringWriter.toString();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Counter0 {
        @XmlAttribute
        public String all = "true";
        @XmlAttribute
        public String disp = "";
        @XmlAttribute
        public String icon = "";
        @XmlAttribute
        public String name = "";
        @XmlAttribute
        public String total = "";
        @XmlAttribute
        public String unit = "";
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Family0 {
        @XmlAttribute
        public String master = "";
        @XmlAttribute
        public String name = "";
        @XmlElement(name="Counter")
        public List<Counter0> counter;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Familys0 {
        @XmlElement(name="Family")
        public List<Family0> family;

        public Familys0() {
        }

        public Familys0(List<Family0> family) {
            this.family = family;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ObjectType0 {
        @XmlAttribute
        public String disp = "";
        @XmlAttribute
        public String family = "";
        @XmlAttribute
        public String icon = "";
        @XmlAttribute
        public String name = "";
        @XmlAttribute(name="sub-object")
        public String sub_object = "";
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Types0 {
        @XmlElement(name="ObjectType")
        List<ObjectType0> objectType;

        public Types0() {
        }

        public Types0(List<ObjectType0> objectType) {
            this.objectType = objectType;
        }
    }

    @XmlRootElement(name="Counters")
    public static class Counters0 {
        @XmlElement(name="Types")
        Types0 types;
        @XmlElement(name="Familys")
        Familys0 familys;

        public Counters0() {
        }

        public Counters0(Types0 types, Familys0 familys) {
            this.types = types;
            this.familys = familys;
        }
    }
}

