/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import scouter.server.ConfObserver;
import scouter.server.Configure;
import scouter.server.Logger;
import scouter.server.core.CoreRun;
import scouter.server.db.DBCtr;
import scouter.server.db.XLogWR;
import scouter.server.db.ZipkinSpanWR;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.SystemUtil;
import scouter.util.ThreadUtil;

public class AutoDeleteScheduler
extends Thread {
    private static AutoDeleteScheduler instance = null;
    private static final long CHECK_INTERVAL = 60000L;
    Configure conf = Configure.getInstance();
    boolean canRun;
    int maxPercent;
    int retainDays;
    int retainXlogDays;
    int retainCounterDays;
    int retainRealtimeCounterDays;
    int retainVisitorCounterDays;
    int retainTagCounterDays;
    int retainTextDays;
    int retainSumDays;
    Set<String> deletedProfileDays = new HashSet<String>();
    Set<String> deletedXLogDays = new HashSet<String>();
    Set<String> deletedDays = new HashSet<String>();
    Set<String> deletedRealtimeCounterDays = new HashSet<String>();
    Set<String> deletedTagCounterDays = new HashSet<String>();
    Set<String> deletedVisitorCounterDays = new HashSet<String>();
    Set<String> deletedTextDays = new HashSet<String>();
    Set<String> deletedSumDays = new HashSet<String>();
    File dbDir;

    public static final synchronized AutoDeleteScheduler getInstance() {
        if (instance == null) {
            instance = new AutoDeleteScheduler();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    private AutoDeleteScheduler() {
        this.applyConf();
        this.dbDir = new File(DBCtr.getRootPath());
        ConfObserver.put(AutoDeleteScheduler.class.getName(), new Runnable(){

            @Override
            public void run() {
                if (AutoDeleteScheduler.this.conf.mgr_purge_enabled != AutoDeleteScheduler.this.canRun || AutoDeleteScheduler.this.conf.mgr_purge_disk_usage_pct != AutoDeleteScheduler.this.maxPercent || AutoDeleteScheduler.this.conf.mgr_purge_profile_keep_days != AutoDeleteScheduler.this.retainDays || AutoDeleteScheduler.this.conf.mgr_purge_xlog_keep_days != AutoDeleteScheduler.this.retainXlogDays || AutoDeleteScheduler.this.conf.mgr_purge_counter_keep_days != AutoDeleteScheduler.this.retainCounterDays || AutoDeleteScheduler.this.conf.mgr_purge_realtime_counter_keep_days != AutoDeleteScheduler.this.retainRealtimeCounterDays || AutoDeleteScheduler.this.conf.mgr_purge_visitor_counter_keep_days != AutoDeleteScheduler.this.retainVisitorCounterDays || AutoDeleteScheduler.this.conf.mgr_purge_tag_counter_keep_days != AutoDeleteScheduler.this.retainTagCounterDays || AutoDeleteScheduler.this.conf.mgr_purge_daily_text_days != AutoDeleteScheduler.this.retainTextDays || AutoDeleteScheduler.this.conf.mgr_purge_sum_data_days != AutoDeleteScheduler.this.retainSumDays) {
                    AutoDeleteScheduler.this.applyConf();
                    AutoDeleteScheduler.this.deletedProfileDays.clear();
                    AutoDeleteScheduler.this.deletedXLogDays.clear();
                    AutoDeleteScheduler.this.deletedDays.clear();
                    AutoDeleteScheduler.this.deletedRealtimeCounterDays.clear();
                    AutoDeleteScheduler.this.deletedTagCounterDays.clear();
                    AutoDeleteScheduler.this.deletedVisitorCounterDays.clear();
                    AutoDeleteScheduler.this.deletedTextDays.clear();
                    AutoDeleteScheduler.this.deletedSumDays.clear();
                }
            }
        });
    }

    private void applyConf() {
        this.canRun = this.conf.mgr_purge_enabled;
        this.maxPercent = this.conf.mgr_purge_disk_usage_pct;
        this.retainDays = this.conf.mgr_purge_profile_keep_days;
        this.retainXlogDays = this.conf.mgr_purge_xlog_keep_days;
        this.retainCounterDays = this.conf.mgr_purge_counter_keep_days;
        this.retainRealtimeCounterDays = this.conf.mgr_purge_realtime_counter_keep_days;
        this.retainVisitorCounterDays = this.conf.mgr_purge_visitor_counter_keep_days;
        this.retainTagCounterDays = this.conf.mgr_purge_tag_counter_keep_days;
        this.retainTextDays = this.conf.mgr_purge_daily_text_days;
        this.retainSumDays = this.conf.mgr_purge_sum_data_days;
    }

    @Override
    public void run() {
        while (CoreRun.running()) {
            if (this.conf.mgr_purge_enabled) {
                String today = DateUtil.yyyymmdd();
                this.purgeOnDiskFreeSize(today);
                this.purgeProfile(today);
                this.purgeXlog(today);
                this.purgeTagCounter(today);
                this.purgeText(today);
                this.purgeSum(today);
                this.purgeVisitorCounter(today);
                this.purgeRealtimeCounter(today);
                this.purgeAllCounter(today);
            }
            ThreadUtil.sleep(60000L);
        }
    }

    private void purgeOnDiskFreeSize(String today) {
        if (SystemUtil.IS_JAVA_1_5) {
            return;
        }
        int maxPercent = this.conf.mgr_purge_disk_usage_pct;
        if (maxPercent > 0) {
            String yyyymmdd;
            long totalSpace = this.dbDir.getTotalSpace();
            long freeSpace = this.dbDir.getUsableSpace();
            double freePercent = (double)freeSpace * 100.0 / (double)totalSpace;
            while (100.0 - freePercent > (double)maxPercent - (double)(100 - maxPercent) * 0.4 && (yyyymmdd = this.getLongAgoDate(this.deletedProfileDays)) != null && !today.equals(yyyymmdd)) {
                this.deleteData(yyyymmdd, Mode.PROFILE);
                freeSpace = this.dbDir.getUsableSpace();
                freePercent = (double)freeSpace * 100.0 / (double)totalSpace;
                this.deletedProfileDays.add(yyyymmdd);
                Logger.println("S206-1", "[purge profile by][capacity]" + yyyymmdd);
                Logger.println("S206-1", "* option : conf.mgr_purge_disk_usage_pct : " + this.conf.mgr_purge_disk_usage_pct);
            }
            while (100.0 - freePercent > (double)maxPercent - (double)(100 - maxPercent) * 0.2 && (yyyymmdd = this.getLongAgoDate(this.deletedXLogDays)) != null && !today.equals(yyyymmdd)) {
                this.deleteData(yyyymmdd, Mode.XLOG);
                freeSpace = this.dbDir.getUsableSpace();
                freePercent = (double)freeSpace * 100.0 / (double)totalSpace;
                this.deletedXLogDays.add(yyyymmdd);
                Logger.println("S206-2", "[purge xlog by][capacity]" + yyyymmdd);
                Logger.println("S206-2", "* option : conf.mgr_purge_disk_usage_pct : " + this.conf.mgr_purge_disk_usage_pct);
            }
            while (100.0 - freePercent > (double)maxPercent && (yyyymmdd = this.getLongAgoDate(this.deletedDays)) != null && !today.equals(yyyymmdd)) {
                this.deleteData(yyyymmdd, Mode.ALL);
                freeSpace = this.dbDir.getUsableSpace();
                freePercent = (double)freeSpace * 100.0 / (double)totalSpace;
                this.deletedDays.add(yyyymmdd);
                Logger.println("S206-3", "[purge counters by][capacity]" + yyyymmdd);
                Logger.println("S206-3", "* option : conf.mgr_purge_disk_usage_pct : " + this.conf.mgr_purge_disk_usage_pct);
            }
        }
    }

    private void purgeAllCounter(String today) {
        int retainCounterDays = this.conf.mgr_purge_counter_keep_days;
        if (retainCounterDays > 0) {
            String yyyymmdd;
            int lastDeleteDate = CastUtil.cint(DateUtil.yyyymmdd(System.currentTimeMillis() - 86400000L * (long)retainCounterDays));
            while ((yyyymmdd = this.getLongAgoDate(this.deletedDays)) != null && !today.equals(yyyymmdd) && CastUtil.cint(yyyymmdd) <= lastDeleteDate) {
                this.deleteData(yyyymmdd, Mode.ALL);
                this.deletedDays.add(yyyymmdd);
                Logger.println("S206-9", "[purge counters by][day limit]" + yyyymmdd + ", [lastDeleteDate]" + lastDeleteDate);
                Logger.println("S206-9", "* option : conf.mgr_purge_counter_keep_days : " + this.conf.mgr_purge_counter_keep_days);
            }
        }
    }

    private void purgeRealtimeCounter(String today) {
        int retainRealtimeCounterDays = this.conf.mgr_purge_realtime_counter_keep_days;
        if (retainRealtimeCounterDays > 0) {
            String yyyymmdd;
            int lastDeleteDate = CastUtil.cint(DateUtil.yyyymmdd(System.currentTimeMillis() - 86400000L * (long)retainRealtimeCounterDays));
            while ((yyyymmdd = this.getLongAgoDate(this.deletedRealtimeCounterDays)) != null && !today.equals(yyyymmdd) && CastUtil.cint(yyyymmdd) <= lastDeleteDate) {
                this.deleteData(yyyymmdd, Mode.REAL_COUNTER);
                this.deletedRealtimeCounterDays.add(yyyymmdd);
                Logger.println("S206-5", "[purge xlog by][day limit]" + yyyymmdd);
                Logger.println("S206-5", "* option : conf.mgr_purge_realtime_counter_keep_days : " + this.conf.mgr_purge_realtime_counter_keep_days);
            }
        }
    }

    private void purgeVisitorCounter(String today) {
        int retainVisitorCounterDays = this.conf.mgr_purge_visitor_counter_keep_days;
        if (retainVisitorCounterDays > 0) {
            String yyyymmdd;
            int lastDeleteDate = CastUtil.cint(DateUtil.yyyymmdd(System.currentTimeMillis() - 86400000L * (long)retainVisitorCounterDays));
            while ((yyyymmdd = this.getLongAgoDate(this.deletedVisitorCounterDays)) != null && !today.equals(yyyymmdd) && CastUtil.cint(yyyymmdd) <= lastDeleteDate) {
                this.deleteData(yyyymmdd, Mode.VISITOR);
                this.deletedVisitorCounterDays.add(yyyymmdd);
                Logger.println("S206-5", "[purge visitor by][day limit]" + yyyymmdd);
                Logger.println("S206-5", "* option : conf.mgr_purge_visitor_counter_keep_days : " + this.conf.mgr_purge_visitor_counter_keep_days);
            }
        }
    }

    private void purgeTagCounter(String today) {
        int retainTagCounterDays = this.conf.mgr_purge_tag_counter_keep_days;
        if (retainTagCounterDays > 0) {
            String yyyymmdd;
            int lastDeleteDate = CastUtil.cint(DateUtil.yyyymmdd(System.currentTimeMillis() - 86400000L * (long)retainTagCounterDays));
            while ((yyyymmdd = this.getLongAgoDate(this.deletedTagCounterDays)) != null && !today.equals(yyyymmdd) && CastUtil.cint(yyyymmdd) <= lastDeleteDate) {
                this.deleteData(yyyymmdd, Mode.TAG);
                this.deletedTagCounterDays.add(yyyymmdd);
                Logger.println("S206-5", "[purge tag counter by][day limit]" + yyyymmdd);
                Logger.println("S206-5", "* option : conf.mgr_purge_tag_counter_keep_days : " + this.conf.mgr_purge_tag_counter_keep_days);
            }
        }
    }

    private void purgeXlog(String today) {
        int retainXLogDays = this.conf.mgr_purge_xlog_keep_days;
        if (retainXLogDays > 0) {
            String yyyymmdd;
            int lastDeleteDate = CastUtil.cint(DateUtil.yyyymmdd(System.currentTimeMillis() - 86400000L * (long)retainXLogDays));
            while ((yyyymmdd = this.getLongAgoDate(this.deletedXLogDays)) != null && !today.equals(yyyymmdd) && CastUtil.cint(yyyymmdd) <= lastDeleteDate) {
                this.deleteData(yyyymmdd, Mode.XLOG);
                this.deletedXLogDays.add(yyyymmdd);
                Logger.println("S206-5", "[purge xlog by][day limit]" + yyyymmdd);
                Logger.println("S206-5", "* option : conf.mgr_purge_xlog_keep_days : " + this.conf.mgr_purge_xlog_keep_days);
            }
        }
    }

    private void purgeText(String today) {
        int retainDays = Math.max(this.conf.mgr_purge_daily_text_days, Math.max(this.conf.mgr_purge_tag_counter_keep_days, this.conf.mgr_purge_xlog_keep_days));
        if (retainDays > 0) {
            String yyyymmdd;
            int lastDeleteDate = CastUtil.cint(DateUtil.yyyymmdd(System.currentTimeMillis() - 86400000L * (long)retainDays));
            while ((yyyymmdd = this.getLongAgoDate(this.deletedTextDays)) != null && !today.equals(yyyymmdd) && CastUtil.cint(yyyymmdd) <= lastDeleteDate) {
                this.deleteData(yyyymmdd, Mode.TEXT);
                this.deletedTextDays.add(yyyymmdd);
                Logger.println("S206-5", "[purge text by][day limit]" + yyyymmdd);
                Logger.println("S206-5", "* option : retainDays of text : " + retainDays);
            }
        }
    }

    private void purgeSum(String today) {
        int retainDays = this.conf.mgr_purge_sum_data_days;
        if (retainDays > 0) {
            String yyyymmdd;
            int lastDeleteDate = CastUtil.cint(DateUtil.yyyymmdd(System.currentTimeMillis() - 86400000L * (long)retainDays));
            while ((yyyymmdd = this.getLongAgoDate(this.deletedSumDays)) != null && !today.equals(yyyymmdd) && CastUtil.cint(yyyymmdd) <= lastDeleteDate) {
                this.deleteData(yyyymmdd, Mode.SUM);
                this.deletedSumDays.add(yyyymmdd);
                Logger.println("S206-5", "[purge sum data by][day limit]" + yyyymmdd);
                Logger.println("S206-5", "* option : retainDays of sum data : " + retainDays);
            }
        }
    }

    private void purgeProfile(String today) {
        int retainProfileDays = this.conf.mgr_purge_profile_keep_days;
        if (retainProfileDays > 0) {
            String yyyymmdd;
            int lastDeleteDate = CastUtil.cint(DateUtil.yyyymmdd(System.currentTimeMillis() - 86400000L * (long)retainProfileDays));
            while ((yyyymmdd = this.getLongAgoDate(this.deletedProfileDays)) != null && !today.equals(yyyymmdd) && CastUtil.cint(yyyymmdd) <= lastDeleteDate) {
                this.deleteData(yyyymmdd, Mode.PROFILE);
                this.deletedProfileDays.add(yyyymmdd);
                Logger.println("S206-4", "[purge profile by][day limit]" + yyyymmdd);
                Logger.println("S206-4", "* option : conf.mgr_purge_profile_keep_days : " + this.conf.mgr_purge_profile_keep_days);
            }
        }
    }

    private void deleteData(String yyyymmdd, Mode mode) {
        try {
            File f = null;
            if (mode == Mode.ALL) {
                f = new File(this.dbDir, yyyymmdd);
                this.deleteFiles(f);
            } else if (mode == Mode.XLOG) {
                f = new File(this.dbDir, yyyymmdd + XLogWR.dir());
                this.deleteFiles(f);
                f = new File(this.dbDir, yyyymmdd + ZipkinSpanWR.SPAN_DIR());
                this.deleteFiles(f);
            } else if (mode == Mode.PROFILE) {
                f = new File(this.dbDir, yyyymmdd + XLogWR.dir() + "/xlog.profile");
                this.deleteFiles(f);
                f = new File(this.dbDir, yyyymmdd + XLogWR.dir() + "/xlog_profile.hfile");
                this.deleteFiles(f);
                f = new File(this.dbDir, yyyymmdd + XLogWR.dir() + "/xlog_profile.kfile");
                this.deleteFiles(f);
            } else if (mode == Mode.VISITOR) {
                f = new File(this.dbDir, yyyymmdd + "/visit");
                this.deleteFiles(f);
            } else if (mode == Mode.TAG) {
                f = new File(this.dbDir, yyyymmdd + "/tagcnt");
                this.deleteFiles(f);
            } else if (mode == Mode.TEXT) {
                f = new File(this.dbDir, yyyymmdd + "/text");
                this.deleteFiles(f);
            } else if (mode == Mode.SUM) {
                f = new File(this.dbDir, yyyymmdd + "/sum");
                this.deleteFiles(f);
            } else if (mode == Mode.REAL_COUNTER) {
                f = new File(this.dbDir, yyyymmdd + "/counter/real.data");
                this.deleteFiles(f);
                f = new File(this.dbDir, yyyymmdd + "/counter/real.hfile");
                this.deleteFiles(f);
                f = new File(this.dbDir, yyyymmdd + "/counter/real.kfile");
                this.deleteFiles(f);
            } else {
                throw new IllegalArgumentException("Not expected Mode : " + (Object)((Object)mode));
            }
            Logger.println("S206", "* Auto deletion... " + yyyymmdd + " mode : " + mode.name());
        }
        catch (Throwable th) {
            Logger.println("S207", "Failed auto deletion... " + yyyymmdd + " mode : " + mode.name() + "  " + th.toString());
        }
    }

    void deleteFiles(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File c : file.listFiles()) {
                this.deleteFiles(c);
            }
        }
        file.delete();
    }

    private String getLongAgoDate(Set<String> exceptDays) {
        File[] dirs = this.dbDir.listFiles();
        if (dirs == null || dirs.length < 1) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < dirs.length; ++i) {
            File f = dirs[i];
            String name = f.getName();
            if (!f.isDirectory() || name.indexOf("0000") != -1 || exceptDays.contains(name)) continue;
            try {
                list.add(Integer.valueOf(f.getName()));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (list.size() == 0) {
            return null;
        }
        Collections.sort(list);
        return String.valueOf(list.get(0));
    }

    static enum Mode {
        PROFILE,
        XLOG,
        TAG,
        VISITOR,
        REAL_COUNTER,
        TEXT,
        SUM,
        ALL;

    }
}

