/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core;

import java.util.List;
import java.util.function.Consumer;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Random;
import scouter.lang.pack.XLogDiscardTypes;
import scouter.lang.pack.XLogPack;
import scouter.lang.pack.XLogProfilePack;
import scouter.lang.pack.XLogProfilePack2;
import scouter.lang.pack.XLogTypes;
import scouter.server.Configure;
import scouter.server.Logger$;
import scouter.server.core.CoreRun$;
import scouter.server.core.ProfileCore$;
import scouter.server.core.ServerStat;
import scouter.server.core.cache.ProfileDelayingCache;
import scouter.server.core.cache.XLogDelayingCache;
import scouter.server.db.TextRD$;
import scouter.server.util.ThreadScala$;
import scouter.util.BytesUtil;
import scouter.util.DateUtil;
import scouter.util.RequestQueue;

public final class ProfilePreCore$ {
    public static final ProfilePreCore$ MODULE$;
    private final Configure conf;
    private final RequestQueue<XLogProfilePack> queue;
    private final Random rnd;

    static {
        new ProfilePreCore$();
    }

    public Configure conf() {
        return this.conf;
    }

    public RequestQueue<XLogProfilePack> queue() {
        return this.queue;
    }

    public void add(XLogProfilePack p) {
        p.time = System.currentTimeMillis();
        boolean ok = this.queue().put(p);
        if (!ok) {
            Logger$.MODULE$.println("S110-0", 10, "queue exceeded!!");
        }
    }

    public void addAsDropped(XLogPack p) {
        XLogProfilePack2 profilePack = XLogProfilePack2.forInternalDropProcessing(p);
        boolean ok = this.queue().put(profilePack);
        if (!ok) {
            Logger$.MODULE$.println("S110-0-1", 10, "queue exceeded!!");
        }
    }

    public void addAsProcessDelayingChildren(XLogPack p) {
        XLogProfilePack2 profilePack = XLogProfilePack2.forInternalDelayingChildrenProcessing(p);
        boolean ok = this.queue().put(profilePack);
        if (!ok) {
            Logger$.MODULE$.println("S110-0-2", 10, "queue exceeded!!");
        }
    }

    public Random rnd() {
        return this.rnd;
    }

    public void scouter$server$core$ProfilePreCore$$processDelayingProfiles(XLogProfilePack2 pack2) {
        List<XLogProfilePack2> profileList = ProfileDelayingCache.instance.popDelayingChildren(pack2);
        int delayingCount = profileList.size();
        IntRef cnt = IntRef.create((int)0);
        profileList.forEach(new Consumer<XLogProfilePack2>(pack2, delayingCount, cnt){
            private final XLogProfilePack2 pack2$1;
            private final int delayingCount$1;
            private final IntRef cnt$1;

            public void accept(XLogProfilePack2 delayingPack) {
                if (this.pack2$1.discardType != 2) {
                    if (ProfilePreCore$.MODULE$.conf().log_test_rate > 0 && ProfilePreCore$.MODULE$.rnd().nextInt(100) < ProfilePreCore$.MODULE$.conf().log_test_rate) {
                        String serviceName = TextRD$.MODULE$.getString(DateUtil.yyyymmdd(delayingPack.time), "service", delayingPack.service);
                        int profileSize = delayingPack.profile == null ? 0 : delayingPack.profile.length;
                        Logger$.MODULE$.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t[processDelaying][", "/", "] ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)profileSize), BoxesRunTime.boxToInteger((int)this.cnt$1.elem), BoxesRunTime.boxToInteger((int)this.delayingCount$1), delayingPack.toDebugString(serviceName)})));
                        ++this.cnt$1.elem;
                    }
                    ProfileCore$.MODULE$.add(delayingPack);
                }
            }
            {
                this.pack2$1 = pack2$1;
                this.delayingCount$1 = delayingCount$1;
                this.cnt$1 = cnt$1;
            }
        });
    }

    public boolean scouter$server$core$ProfilePreCore$$canProcess(XLogProfilePack pack) {
        if (pack.getPackType() == 27) {
            XLogProfilePack2 pack2 = (XLogProfilePack2)pack;
            boolean result = pack2.isDriving() || pack2.ignoreGlobalConsequentSampling || XLogTypes.isService(pack2.xType) && XLogDiscardTypes.isAliveProfile(pack2.discardType) || XLogTypes.isZipkin(pack2.xType) || XLogDelayingCache.instance.isProcessedGxidWithProfile(pack2.gxid) || pack2.discardType == 0;
            return result;
        }
        return true;
    }

    public void scouter$server$core$ProfilePreCore$$processOnCondition(XLogProfilePack pack) {
        if (pack.getPackType() == 27) {
            XLogProfilePack2 pack2 = (XLogProfilePack2)pack;
            if (pack2.ignoreGlobalConsequentSampling) {
                if (XLogDiscardTypes.isAliveProfile(pack2.discardType)) {
                    if (this.conf().log_test_rate > 0 && this.rnd().nextInt(100) < this.conf().log_test_rate) {
                        String serviceName = TextRD$.MODULE$.getString(DateUtil.yyyymmdd(pack.time), "service", pack.service);
                        int profileSize = pack.profile == null ? 0 : pack.profile.length;
                        Logger$.MODULE$.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t[ProfileCoreCase1(IgnoreCons)] ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)profileSize), pack2.toDebugString(serviceName)})));
                    }
                    ProfileCore$.MODULE$.add(pack);
                }
            } else {
                if (this.conf().log_test_rate > 0 && this.rnd().nextInt(100) < this.conf().log_test_rate) {
                    String serviceName = TextRD$.MODULE$.getString(DateUtil.yyyymmdd(pack.time), "service", pack.service);
                    int profileSize = pack.profile == null ? 0 : pack.profile.length;
                    Logger$.MODULE$.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t[ProfileCoreCase2] ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)profileSize), pack2.toDebugString(serviceName)})));
                }
                ProfileCore$.MODULE$.add(pack);
            }
        } else {
            if (this.conf().log_test_rate > 0 && this.rnd().nextInt(100) < this.conf().log_test_rate) {
                String serviceName = TextRD$.MODULE$.getString(DateUtil.yyyymmdd(pack.time), "service", pack.service);
                int profileSize = pack.profile == null ? 0 : pack.profile.length;
                Logger$.MODULE$.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t[ProfileCoreCase3(Old)] ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)profileSize), pack.toDebugString(serviceName)})));
            }
            ProfileCore$.MODULE$.add(pack);
        }
    }

    public void scouter$server$core$ProfilePreCore$$waitOnMemory(XLogProfilePack2 pack2) {
        ProfileDelayingCache.instance.addDelaying(pack2);
    }

    private void doNothing() {
    }

    private ProfilePreCore$() {
        MODULE$ = this;
        this.conf = Configure.getInstance();
        this.queue = new RequestQueue(this.conf().profile_queue_size);
        ThreadScala$.MODULE$.startDaemon("scouter.server.core.ProfilePreCore", (Function0<Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return CoreRun$.MODULE$.running();
            }
        }, (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                XLogProfilePack2 xLogProfilePack2;
                XLogProfilePack pack = ProfilePreCore$.MODULE$.queue().get();
                ServerStat.put("profile.core0.queue", ProfilePreCore$.MODULE$.queue().size());
                XLogProfilePack xLogProfilePack = pack;
                XLogProfilePack2 xLogProfilePack22 = xLogProfilePack instanceof XLogProfilePack2 ? (xLogProfilePack2 = (XLogProfilePack2)xLogProfilePack) : null;
                XLogProfilePack2 pack2 = xLogProfilePack22;
                if (pack2 != null && pack2.isForDrop()) {
                    ProfileDelayingCache.instance.removeDelayingChildren(pack2);
                } else if (pack2 != null && pack2.isForProcessDelayingChildren()) {
                    ProfilePreCore$.MODULE$.scouter$server$core$ProfilePreCore$$processDelayingProfiles(pack2);
                } else if (BytesUtil.getLength(pack.profile) > 0) {
                    if (ProfilePreCore$.MODULE$.scouter$server$core$ProfilePreCore$$canProcess(pack)) {
                        ProfilePreCore$.MODULE$.scouter$server$core$ProfilePreCore$$processOnCondition(pack);
                    } else {
                        ProfilePreCore$.MODULE$.scouter$server$core$ProfilePreCore$$waitOnMemory((XLogProfilePack2)pack);
                    }
                }
            }
        });
        this.rnd = new Random();
    }
}

