/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core.app;

import scouter.lang.ref.DOUBLE;
import scouter.lang.ref.INT;
import scouter.util.MeteringUtil;

public class MeterCounter {
    private MeteringUtil<Bucket> meter = new MeteringUtil<Bucket>(2000, 31){

        @Override
        protected Bucket create() {
            return new Bucket();
        }

        @Override
        protected void clear(Bucket o) {
            o.value = 0.0;
            o.count = 0;
        }
    };

    public synchronized void add(double value) {
        Bucket b = this.meter.getCurrentBucket();
        b.value += value;
        ++b.count;
    }

    public double getAvg(int period) {
        final INT count = new INT();
        final DOUBLE sum = new DOUBLE();
        this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket u) {
                sum.value += u.value;
                count.value += u.count;
            }
        });
        return count.value == 0 ? 0.0 : sum.value / (double)count.value;
    }

    public double getSum(int period) {
        final DOUBLE sum = new DOUBLE();
        this.meter.search(period, new MeteringUtil.Handler<Bucket>(){

            @Override
            public void process(Bucket u) {
                sum.value += u.value;
            }
        });
        return sum.value;
    }

    static class Bucket {
        double value;
        int count;

        Bucket() {
        }
    }
}

