/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import scouter.lang.pack.XLogProfilePack2;
import scouter.server.Configure;
import scouter.server.Logger;
import scouter.server.core.ProfileDelayingsRecoverCore;
import scouter.util.LongKeyLinkedMap;

public final class ProfileDelayingCache {
    public static ProfileDelayingCache instance = new ProfileDelayingCache();
    private static final int BUCKET_MILLIS = 500;
    private Configure conf = Configure.getInstance();
    private int lastMaxSize = 0;
    private long lastTime = System.currentTimeMillis() / 500L;
    private final ReferenceQueue<LongKeyLinkedMap<List<XLogProfilePack2>>> referenceQueue;
    private LongKeyLinkedMap<List<XLogProfilePack2>> gxidProfiles = this.newMap();
    private final LinkedList<SoftReference<LongKeyLinkedMap<List<XLogProfilePack2>>>> gxidProfilesOld = new LinkedList();

    private ProfileDelayingCache() {
        this.referenceQueue = new ReferenceQueue();
        try {
            ReferenceQueueHandler referenceQueueHandler = new ReferenceQueueHandler(this.referenceQueue);
            referenceQueueHandler.start();
        }
        catch (Exception e) {
            Logger.printStackTrace(e);
        }
    }

    public void addDelaying(XLogProfilePack2 profilePack) {
        List<XLogProfilePack2> profilePacks;
        if (profilePack.discardType == 0) {
            return;
        }
        if (this.lastTime != System.currentTimeMillis() / 500L) {
            this.lastTime = System.currentTimeMillis() / 500L;
            this.lastMaxSize = Math.max(this.lastMaxSize, this.gxidProfiles.size());
            int maxBucketCount = this.conf.xlog_sampling_matcher_profile_keep_memory_secs * 1000 / 500;
            if (this.gxidProfilesOld.size() >= maxBucketCount) {
                for (int inx = this.gxidProfilesOld.size(); inx >= maxBucketCount; --inx) {
                    LongKeyLinkedMap<List<XLogProfilePack2>> profilesInOld;
                    SoftReference<LongKeyLinkedMap<List<XLogProfilePack2>>> packsRef = this.gxidProfilesOld.removeFirst();
                    if (packsRef == null || (profilesInOld = packsRef.get()) == null) continue;
                    ProfileDelayingsRecoverCore.add(profilesInOld);
                }
            }
            this.gxidProfilesOld.addLast(new SoftReference<LongKeyLinkedMap<List<XLogProfilePack2>>>(this.gxidProfiles, this.referenceQueue));
            this.gxidProfiles = this.newMap();
        }
        if ((profilePacks = this.gxidProfiles.get(profilePack.gxid)) == null) {
            profilePacks = new ArrayList<XLogProfilePack2>();
            this.gxidProfiles.put(profilePack.gxid, profilePacks);
        }
        profilePacks.add(profilePack);
    }

    public void removeDelayingChildren(XLogProfilePack2 drivingPack) {
        if (drivingPack.isDriving()) {
            this.gxidProfiles.remove(drivingPack.txid);
            for (SoftReference softReference : this.gxidProfilesOld) {
                LongKeyLinkedMap profilesInOld = (LongKeyLinkedMap)softReference.get();
                if (profilesInOld == null) continue;
                profilesInOld.remove(drivingPack.txid);
            }
        }
    }

    public List<XLogProfilePack2> popDelayingChildren(XLogProfilePack2 drivingPack) {
        if (!drivingPack.isDriving()) {
            return Collections.emptyList();
        }
        List<XLogProfilePack2> children = this.gxidProfiles.get(drivingPack.txid);
        if (children != null) {
            this.gxidProfiles.remove(drivingPack.txid);
        } else {
            children = new ArrayList<XLogProfilePack2>();
        }
        for (SoftReference softReference : this.gxidProfilesOld) {
            List childrenInOld;
            LongKeyLinkedMap profilesInOld = (LongKeyLinkedMap)softReference.get();
            if (profilesInOld == null || (childrenInOld = (List)profilesInOld.get(drivingPack.txid)) == null) continue;
            profilesInOld.remove(drivingPack.txid);
            children.addAll(childrenInOld);
        }
        return children;
    }

    private LongKeyLinkedMap<List<XLogProfilePack2>> newMap() {
        int initSize = 0;
        initSize = this.lastMaxSize == 0 ? 5000 : (int)((float)this.lastMaxSize * 1.5f);
        LongKeyLinkedMap<List<XLogProfilePack2>> map = new LongKeyLinkedMap<List<XLogProfilePack2>>(initSize, 0.75f);
        map.setMax(this.conf.xlog_sampling_matcher_profile_keep_memory_count);
        return map;
    }

    static class ReferenceQueueHandler
    extends Thread {
        private final ReferenceQueue<LongKeyLinkedMap<List<XLogProfilePack2>>> referenceQueue;

        ReferenceQueueHandler(ReferenceQueue<LongKeyLinkedMap<List<XLogProfilePack2>>> referenceQueue) {
            this.referenceQueue = referenceQueue;
            this.setName("SCOUTER-ProfileDelayingCache-ReferenceQueueHandler");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    try {
                        while (true) {
                            Reference<LongKeyLinkedMap<List<XLogProfilePack2>>> reference = this.referenceQueue.remove();
                            Logger.println("S0101", "Consider heap increase, ProfileDelayingCache purged by GC, reference=" + reference);
                        }
                    }
                    catch (InterruptedException e) {
                        Logger.println("S0102", "ProfileDelayingCache ReferenceQueueHandler interrupted!");
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable ex) {
                Logger.printStackTrace(ex);
                return;
            }
        }
    }
}

