/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.core.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import scouter.lang.pack.XLogDiscardTypes;
import scouter.lang.pack.XLogPack;
import scouter.server.Configure;
import scouter.server.core.XLogDelayingsRecoverCore;
import scouter.util.LongIntLinkedMap;
import scouter.util.LongKeyLinkedMap;

public class XLogDelayingCache {
    public static XLogDelayingCache instance = new XLogDelayingCache();
    private Configure conf = Configure.getInstance();
    private int lastMaxSize = 0;
    private long lastTime;
    private LongIntLinkedMap processedGxidMap;
    private LongKeyLinkedMap<List<XLogPack>> gxidXLogs;
    private LongKeyLinkedMap<List<XLogPack>> gxidXLogsOld;

    public static XLogDelayingCache getInstance() {
        return instance;
    }

    private XLogDelayingCache() {
        this.lastTime = System.currentTimeMillis() / (long)this.conf.xlog_sampling_matcher_xlog_keep_memory_millis;
        this.processedGxidMap = new LongIntLinkedMap();
        this.processedGxidMap.setMax(this.conf.xlog_sampling_matcher_gxid_keep_memory_count);
        this.gxidXLogs = this.newMap();
        this.gxidXLogsOld = this.newMap();
    }

    public void addProcessed(XLogPack xLogPack) {
        if (xLogPack.isDriving()) {
            this.processedGxidMap.add(xLogPack.txid, xLogPack.discardType);
        }
    }

    public boolean isProcessedGxid(long gxid) {
        return this.processedGxidMap.containsKey(gxid);
    }

    public boolean isProcessedGxidWithoutProfile(long gxid) {
        return 3 == this.processedGxidMap.get(gxid);
    }

    public boolean isProcessedGxidWithProfile(long gxid) {
        byte discardType = (byte)this.processedGxidMap.get(gxid);
        return discardType != 0 && XLogDiscardTypes.isAliveProfile(discardType);
    }

    public void addDelaying(XLogPack xLogPack) {
        List<XLogPack> xLogPacks;
        if (this.lastTime != System.currentTimeMillis() / (long)this.conf.xlog_sampling_matcher_xlog_keep_memory_millis) {
            this.lastTime = System.currentTimeMillis() / (long)this.conf.xlog_sampling_matcher_xlog_keep_memory_millis;
            this.lastMaxSize = Math.max(this.lastMaxSize, this.gxidXLogs.size());
            XLogDelayingsRecoverCore.add(this.gxidXLogsOld);
            this.gxidXLogsOld = this.gxidXLogs;
            this.gxidXLogs = this.newMap();
        }
        if ((xLogPacks = this.gxidXLogs.get(xLogPack.gxid)) == null) {
            xLogPacks = new ArrayList<XLogPack>();
            this.gxidXLogs.put(xLogPack.gxid, xLogPacks);
        }
        xLogPacks.add(xLogPack);
    }

    public List<XLogPack> popDelayingChildren(XLogPack drivingXLogPack) {
        List<XLogPack> childrenInOld;
        if (!drivingXLogPack.isDriving()) {
            return Collections.emptyList();
        }
        List<XLogPack> children = this.gxidXLogs.get(drivingXLogPack.txid);
        if (children != null) {
            this.gxidXLogs.remove(drivingXLogPack.txid);
        }
        if ((childrenInOld = this.gxidXLogsOld.get(drivingXLogPack.txid)) != null) {
            this.gxidXLogsOld.remove(drivingXLogPack.txid);
        }
        if (children == null && childrenInOld == null) {
            return Collections.emptyList();
        }
        if (children != null && childrenInOld != null) {
            children.addAll(childrenInOld);
            return children;
        }
        if (children != null) {
            return children;
        }
        return childrenInOld;
    }

    public void removeDelayingChildren(XLogPack drivingXLogPack) {
        if (drivingXLogPack.isDriving()) {
            this.gxidXLogs.remove(drivingXLogPack.txid);
            this.gxidXLogsOld.remove(drivingXLogPack.txid);
        }
    }

    private LongKeyLinkedMap<List<XLogPack>> newMap() {
        int initSize = 0;
        initSize = this.lastMaxSize == 0 ? 5000 : (int)((float)this.lastMaxSize * 1.5f);
        LongKeyLinkedMap<List<XLogPack>> map = new LongKeyLinkedMap<List<XLogPack>>(initSize, 0.75f);
        map.setMax(this.conf.xlog_sampling_matcher_xlog_keep_memory_count);
        return map;
    }
}

