/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db;

import java.io.File;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.server.Configure;
import scouter.server.Logger$;
import scouter.server.core.ServerStat;
import scouter.server.db.DBCtr$;
import scouter.server.db.XLogProfileWR;
import scouter.server.db.XLogWR$;
import scouter.server.db.xlog.XLogProfileDataWriter;
import scouter.server.db.xlog.XLogProfileDataWriter$;
import scouter.server.db.xlog.XLogProfileIndex;
import scouter.server.db.xlog.XLogProfileIndex$;
import scouter.server.util.OftenAction$;
import scouter.server.util.ThreadScala$;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.IClose;
import scouter.util.RequestQueue;

public final class XLogProfileWR$
implements IClose {
    public static final XLogProfileWR$ MODULE$;
    private final RequestQueue<XLogProfileWR.Data> queue;
    private final String prefix;
    private long currentDateUnit;
    private XLogProfileIndex index;
    private XLogProfileDataWriter writer;

    static {
        new XLogProfileWR$();
    }

    public RequestQueue<XLogProfileWR.Data> queue() {
        return this.queue;
    }

    public String prefix() {
        return this.prefix;
    }

    public long currentDateUnit() {
        return this.currentDateUnit;
    }

    public void currentDateUnit_$eq(long x$1) {
        this.currentDateUnit = x$1;
    }

    public XLogProfileIndex index() {
        return this.index;
    }

    public void index_$eq(XLogProfileIndex x$1) {
        this.index = x$1;
    }

    public XLogProfileDataWriter writer() {
        return this.writer;
    }

    public void writer_$eq(XLogProfileDataWriter x$1) {
        this.writer = x$1;
    }

    public void add(long time, long txid, byte[] data) {
        boolean ok = this.queue().put(new XLogProfileWR.Data(time, txid, data));
        if (!ok) {
            Logger$.MODULE$.println("S142", 10, "queue exceeded!!");
        }
    }

    @Override
    public void close() {
        FileUtil.close(this.index());
        FileUtil.close(this.writer());
        this.writer_$eq(null);
        this.index_$eq(null);
    }

    public void open(String date) {
        try {
            String path = this.getDBPath(date);
            File f = new File(path);
            Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
            String file = new StringBuilder().append((Object)path).append((Object)"/").append((Object)this.prefix()).toString();
            this.index_$eq(XLogProfileIndex$.MODULE$.open(file));
            this.writer_$eq(XLogProfileDataWriter$.MODULE$.open(date, file));
            return;
        }
        catch (Throwable throwable) {
            this.close();
            throwable.printStackTrace();
            return;
        }
    }

    public String getDBPath(String date) {
        StringBuffer sb = new StringBuffer();
        sb.append(DBCtr$.MODULE$.getRootPath());
        sb.append("/").append(date).append(XLogWR$.MODULE$.dir());
        return sb.toString();
    }

    private XLogProfileWR$() {
        MODULE$ = this;
        this.queue = new RequestQueue(Configure.getInstance().profile_queue_size);
        this.prefix = "xlog";
        this.currentDateUnit = 0L;
        this.index = null;
        this.writer = null;
        ThreadScala$.MODULE$.start("scouter.server.db.XLogProfileWR", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void apply$mcV$sp() {
                while (true) {
                    XLogProfileWR.Data m;
                    block6: {
                        if (!DBCtr$.MODULE$.running()) {
                            XLogProfileWR$.MODULE$.close();
                            return;
                        }
                        m = XLogProfileWR$.MODULE$.queue().get();
                        ServerStat.put("profile.db.queue", XLogProfileWR$.MODULE$.queue().size());
                        try {
                            if (XLogProfileWR$.MODULE$.currentDateUnit() != DateUtil.getDateUnit(m.time())) {
                                XLogProfileWR$.MODULE$.currentDateUnit_$eq(DateUtil.getDateUnit(m.time()));
                                XLogProfileWR$.MODULE$.close();
                                XLogProfileWR$.MODULE$.open(DateUtil.yyyymmdd(m.time()));
                            }
                            if (XLogProfileWR$.MODULE$.index() == null) {
                                OftenAction$.MODULE$.act("XLogWR", 10, (Function0<BoxedUnit>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        XLogProfileWR$.MODULE$.queue().clear();
                                        XLogProfileWR$.MODULE$.currentDateUnit_$eq(0L);
                                    }
                                });
                                Logger$.MODULE$.println("S141", 10, "can't open ");
                            }
                            break block6;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        continue;
                    }
                    long offset = XLogProfileWR$.MODULE$.writer().write(m.data());
                    XLogProfileWR$.MODULE$.index().addByTxid(m.txid(), offset);
                }
            }
        });
    }
}

