/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.db.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scouter.io.DataInputX;
import scouter.server.Configure;
import scouter.server.Logger$;
import scouter.server.db.io.IndexKeyFile2$;
import scouter.server.db.io.KeyFileItem2;
import scouter.server.db.io.MemHashBlock;
import scouter.server.db.io.RealKeyFile2;
import scouter.util.CompareUtil;
import scouter.util.HashUtil;
import scouter.util.IClose;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u0001\u0003\u0001-\u0011Q\"\u00138eKb\\U-\u001f$jY\u0016\u0014$BA\u0002\u0005\u0003\tIwN\u0003\u0002\u0006\r\u0005\u0011AM\u0019\u0006\u0003\u000f!\taa]3sm\u0016\u0014(\"A\u0005\u0002\u000fM\u001cw.\u001e;fe\u000e\u00011c\u0001\u0001\r)A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!AB(cU\u0016\u001cG\u000f\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005!Q\u000f^5m\u0013\tIbC\u0001\u0004J\u00072|7/\u001a\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005)q\f]1uQB\u0011Qd\t\b\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!eH\u0001\u0007!J,G-\u001a4\n\u0005\u0011*#AB*ue&twM\u0003\u0002#?!Aq\u0005\u0001B\u0001B\u0003%\u0001&\u0001\u0005iCND7+\u001b>f!\tq\u0012&\u0003\u0002+?\t\u0019\u0011J\u001c;\t\u000b1\u0002A\u0011A\u0017\u0002\rqJg.\u001b;?)\rq\u0003'\r\t\u0003_\u0001i\u0011A\u0001\u0005\u00067-\u0002\r\u0001\b\u0005\bO-\u0002\n\u00111\u0001)\u0011\u001d\u0019\u0004A1A\u0005\u0002Q\nAaY8oMV\tQ\u0007\u0005\u00027o5\ta!\u0003\u00029\r\tI1i\u001c8gS\u001e,(/\u001a\u0005\u0007u\u0001\u0001\u000b\u0011B\u001b\u0002\u000b\r|gN\u001a\u0011\t\u000fq\u0002!\u0019!C\u0001{\u0005\u0011QJQ\u000b\u0002Q!1q\b\u0001Q\u0001\n!\n1!\u0014\"!\u0011\u001d\t\u0005A1A\u0005\u0002\t\u000bA\u0001]1uQV\tA\u0004\u0003\u0004E\u0001\u0001\u0006I\u0001H\u0001\u0006a\u0006$\b\u000e\t\u0005\b\r\u0002\u0011\r\u0011\"\u0001H\u0003%A\u0017m\u001d5CY>\u001c7.F\u0001I!\ty\u0013*\u0003\u0002K\u0005\taQ*Z7ICND'\t\\8dW\"1A\n\u0001Q\u0001\n!\u000b!\u0002[1tQ\ncwnY6!\u0011\u001dq\u0005A1A\u0005\u0002=\u000bqa[3z\r&dW-F\u0001Q!\ty\u0013+\u0003\u0002S\u0005\ta!+Z1m\u0017\u0016Lh)\u001b7fe!1A\u000b\u0001Q\u0001\nA\u000b\u0001b[3z\r&dW\r\t\u0005\u0006-\u0002!\taV\u0001\u0004aV$H\u0003\u0002-\\G\u0016\u0004\"AH-\n\u0005i{\"a\u0002\"p_2,\u0017M\u001c\u0005\u00069V\u0003\r!X\u0001\tS:$W\r_&fsB\u0019aD\u00181\n\u0005}{\"!B!se\u0006L\bC\u0001\u0010b\u0013\t\u0011wD\u0001\u0003CsR,\u0007\"\u00023V\u0001\u0004i\u0016A\u00033bi\u0006|eMZ:fi\")a-\u0016a\u0001O\u0006\u0019A\u000f\u001e7\u0011\u0005yA\u0017BA5 \u0005\u0011auN\\4\t\u000bY\u0003A\u0011A6\u0015\u0007acW\u000eC\u0003]U\u0002\u0007Q\fC\u0003eU\u0002\u0007Q\fC\u0003p\u0001\u0011\u0005\u0001/A\u0006va\u0012\fG/Z(s!V$Hc\u0001-rg\")!O\u001ca\u0001;\u0006\u00191.Z=\t\u000bQt\u0007\u0019A/\u0002\u000bY\fG.^3\t\u000b=\u0004A\u0011\u0001<\u0015\ta;\b0\u001f\u0005\u0006eV\u0004\r!\u0018\u0005\u0006iV\u0004\r!\u0018\u0005\u0006MV\u0004\ra\u001a\u0005\u0006w\u0002!\t\u0001`\u0001\u0007g\u0016$H\u000b\u0016'\u0015\u0007akh\u0010C\u0003su\u0002\u0007Q\fC\u0003gu\u0002\u0007q\rC\u0004\u0002\u0002\u0001!\t!a\u0001\u0002\u0007\u001d,G\u000fF\u0002^\u0003\u000bAQA]@A\u0002uCq!!\u0003\u0001\t\u0003\tY!\u0001\u0004iCN\\U-\u001f\u000b\u00041\u00065\u0001B\u0002:\u0002\b\u0001\u0007Q\fC\u0004\u0002\u0012\u0001!\t!a\u0005\u0002\r\u001d,G/\u00117m)\u0011\t)\"a\b\u0011\u000b\u0005]\u00111D/\u000e\u0005\u0005e!BA\f\u0011\u0013\u0011\ti\"!\u0007\u0003\t1K7\u000f\u001e\u0005\u0007e\u0006=\u0001\u0019A/\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u00051A-\u001a7fi\u0016$2\u0001KA\u0014\u0011\u0019\u0011\u0018\u0011\u0005a\u0001;\"9\u00111\u0006\u0001\u0005\u0002\u00055\u0012\u0001\u0002:fC\u0012$B!a\f\u00026A\u0019a$!\r\n\u0007\u0005MrD\u0001\u0003V]&$\b\u0002CA\u001c\u0003S\u0001\r!!\u000f\u0002\u000f!\fg\u000e\u001a7feB9a$a\u000f^;\u0006}\u0012bAA\u001f?\tIa)\u001e8di&|gN\r\t\u0004=\u0005\u0005\u0013bAA\"?\t\u0019\u0011I\\=\t\u000f\u0005-\u0002\u0001\"\u0001\u0002HQ1\u0011qFA%\u0003\u0017B\u0001\"a\u000e\u0002F\u0001\u0007\u0011\u0011\b\u0005\t\u0003\u001b\n)\u00051\u0001\u0002P\u00051!/Z1eKJ\u0004RAHA)OvK1!a\u0015 \u0005%1UO\\2uS>t\u0017\u0007C\u0004\u0002X\u0001!\t!!\u0017\u0002\u000f\u001d,Go\u0015;biR\u0011\u00111\f\t\b\u0003/\ti\u0006HA1\u0013\u0011\ty&!\u0007\u0003\u00075\u000b\u0007\u000fE\u0002\u000e\u0003GJ1!!\u001a\u000f\u0005\u0019qU/\u001c2fe\"9\u0011\u0011\u000e\u0001\u0005B\u0005-\u0014!B2m_N,GCAA\u0018\u000f%\tyGAA\u0001\u0012\u0003\t\t(A\u0007J]\u0012,\u0007pS3z\r&dWM\r\t\u0004_\u0005Md\u0001C\u0001\u0003\u0003\u0003E\t!!\u001e\u0014\t\u0005M\u0014q\u000f\t\u0004=\u0005e\u0014bAA>?\t1\u0011I\\=SK\u001aDq\u0001LA:\t\u0003\ty\b\u0006\u0002\u0002r!Q\u00111QA:#\u0003%\t!!\"\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t9IK\u0002)\u0003\u0013[#!a#\u0011\t\u00055\u0015qS\u0007\u0003\u0003\u001fSA!!%\u0002\u0014\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+{\u0012AC1o]>$\u0018\r^5p]&!\u0011\u0011TAH\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class IndexKeyFile2
implements IClose {
    private final Configure conf = Configure.getInstance();
    private final int MB;
    private final String path;
    private final MemHashBlock hashBlock;
    private final RealKeyFile2 keyFile;

    public static int $lessinit$greater$default$2() {
        return IndexKeyFile2$.MODULE$.$lessinit$greater$default$2();
    }

    public Configure conf() {
        return this.conf;
    }

    public int MB() {
        return this.MB;
    }

    public String path() {
        return this.path;
    }

    public MemHashBlock hashBlock() {
        return this.hashBlock;
    }

    public RealKeyFile2 keyFile() {
        return this.keyFile;
    }

    public boolean put(byte[] indexKey, byte[] dataOffset, long ttl) {
        if (indexKey == null || dataOffset == null) {
            throw new IOException("invalid key/value");
        }
        int keyHash = HashUtil.hash(indexKey);
        long prevKeyPos = this.hashBlock().get(keyHash);
        long newKeyPos = this.keyFile().append(prevKeyPos, ttl, indexKey, dataOffset);
        this.hashBlock().put(keyHash, newKeyPos);
        return true;
    }

    public boolean put(byte[] indexKey, byte[] dataOffset) {
        return this.put(indexKey, dataOffset, -1L);
    }

    public boolean updateOrPut(byte[] key, byte[] value) {
        return this.updateOrPut(key, value, -1L);
    }

    public boolean updateOrPut(byte[] key, byte[] value, long ttl) {
        if (key == null || value == null) {
            throw new IOException("invalid key/value");
        }
        int keyHash = HashUtil.hash(key);
        long realKeyPos = this.hashBlock().get(keyHash);
        try {
            int looping = 0;
            while (realKeyPos > 0L) {
                boolean result;
                byte[] oKey = this.keyFile().getKey(realKeyPos);
                if (CompareUtil.equals(oKey, key) && !(result = this.keyFile().update(realKeyPos, ttl, key, value))) {
                    return this.put(key, value, ttl);
                }
                realKeyPos = this.keyFile().getPrevPos(realKeyPos);
                ++looping;
            }
            if (looping > this.conf().log_index_traversal_warning_count) {
                Logger$.MODULE$.println("S161", 10, new StringBuilder().append((Object)"[warn] Too many index deep searching. ").append((Object)new String(key, "UTF8")).toString());
            }
            return this.put(key, value, ttl);
        }
        catch (IOException iOException) {
            Logger$.MODULE$.println("S162", new StringBuilder().append((Object)"pos=").append((Object)BoxesRunTime.boxToLong((long)realKeyPos)).append((Object)" keyFile.length=").append((Object)BoxesRunTime.boxToLong((long)this.keyFile().getLength())).toString());
            throw iOException;
        }
    }

    public boolean setTTL(byte[] key, long ttl) {
        if (key == null) {
            throw new IOException("invalid key/value");
        }
        int keyHash = HashUtil.hash(key);
        long realKeyPos = this.hashBlock().get(keyHash);
        try {
            int looping = 0;
            while (realKeyPos > 0L) {
                byte[] oKey = this.keyFile().getKey(realKeyPos);
                if (CompareUtil.equals(oKey, key)) {
                    if (this.keyFile().isDeletedOrExpired(realKeyPos)) {
                        return false;
                    }
                    this.keyFile().setTTL(realKeyPos, ttl);
                    return true;
                }
                realKeyPos = this.keyFile().getPrevPos(realKeyPos);
                ++looping;
            }
            if (looping > this.conf().log_index_traversal_warning_count) {
                Logger$.MODULE$.println("S161", 10, new StringBuilder().append((Object)"[warn] Too many index deep searching. ").append((Object)new String(key, "UTF8")).toString());
            }
            return false;
        }
        catch (IOException iOException) {
            Logger$.MODULE$.println("S162", new StringBuilder().append((Object)"pos=").append((Object)BoxesRunTime.boxToLong((long)realKeyPos)).append((Object)" keyFile.length=").append((Object)BoxesRunTime.boxToLong((long)this.keyFile().getLength())).toString());
            throw iOException;
        }
    }

    public byte[] get(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long realKeyPos = this.hashBlock().get(keyHash);
        try {
            int looping = 0;
            while (realKeyPos > 0L) {
                byte[] oKey = this.keyFile().getKey(realKeyPos);
                if (CompareUtil.equals(oKey, key)) {
                    if (this.keyFile().isDeletedOrExpired(realKeyPos)) {
                        return null;
                    }
                    return this.keyFile().getDataPos(realKeyPos);
                }
                realKeyPos = this.keyFile().getPrevPos(realKeyPos);
                ++looping;
            }
            if (looping > this.conf().log_index_traversal_warning_count) {
                Logger$.MODULE$.println("S152", 10, new StringBuilder().append((Object)"[warn] Too many index deep searching. ").append((Object)new String(key, "UTF8")).toString());
            }
            return null;
        }
        catch (IOException iOException) {
            Logger$.MODULE$.println("S124", new StringBuilder().append((Object)"pos=").append((Object)BoxesRunTime.boxToLong((long)realKeyPos)).append((Object)" keyFile.length=").append((Object)BoxesRunTime.boxToLong((long)this.keyFile().getLength())).toString());
            throw iOException;
        }
    }

    public boolean hasKey(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashBlock().get(keyHash);
        while (pos > 0L) {
            byte[] okey = this.keyFile().getKey(pos);
            if (CompareUtil.equals(okey, key)) {
                return !this.keyFile().isDeletedOrExpired(pos);
            }
            pos = this.keyFile().getPrevPos(pos);
        }
        return false;
    }

    public List<byte[]> getAll(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        ArrayList<byte[]> out = new ArrayList<byte[]>();
        int keyHash = HashUtil.hash(key);
        long pos = this.hashBlock().get(keyHash);
        while (pos > 0L) {
            byte[] okey;
            Object object = !this.keyFile().isDeleted(pos) ? (CompareUtil.equals(okey = this.keyFile().getKey(pos), key) ? BoxesRunTime.boxToBoolean((boolean)out.add(this.keyFile().getDataPos(pos))) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
            pos = this.keyFile().getPrevPos(pos);
        }
        return out;
    }

    public int delete(byte[] key) {
        if (key == null) {
            throw new IOException("invalid key");
        }
        int keyHash = HashUtil.hash(key);
        long pos = this.hashBlock().get(keyHash);
        while (pos > 0L) {
            byte[] okey = this.keyFile().getKey(pos);
            if (CompareUtil.equals(okey, key)) {
                if (this.keyFile().isDeleted(pos)) {
                    return 0;
                }
                this.keyFile().setDelete(pos, true);
                return 1;
            }
            pos = this.keyFile().getPrevPos(pos);
        }
        return 0;
    }

    public void read(Function2<byte[], byte[], Object> handler) {
        if (this.keyFile() == null) {
            return;
        }
        long pos = this.keyFile().getFirstPos();
        long length = this.keyFile().getLength();
        int done = 0;
        try {
            while (pos < length && pos > 0L) {
                KeyFileItem2 r = this.keyFile().getRecord(pos);
                Object object = !r.deleted() ? handler.apply((Object)r.key(), (Object)r.dataPos()) : BoxedUnit.UNIT;
                ++done;
                pos = r.offset();
            }
        }
        catch (Throwable throwable) {
            Logger$.MODULE$.println("S125", new StringBuilder().append((Object)this.keyFile().path()).append((Object)" : read=").append((Object)BoxesRunTime.boxToInteger((int)done)).append((Object)" pos=").append((Object)BoxesRunTime.boxToLong((long)pos)).append((Object)" file-len=").append((Object)BoxesRunTime.boxToLong((long)length)).append((Object)" ").append((Object)throwable).toString());
        }
    }

    public void read(Function2<byte[], byte[], Object> handler, Function1<Object, byte[]> reader) {
        if (this.keyFile() == null) {
            return;
        }
        long pos = this.keyFile().getFirstPos();
        long length = this.keyFile().getLength();
        int done = 0;
        try {
            while (pos < length && pos > 0L) {
                KeyFileItem2 r = this.keyFile().getRecord(pos);
                Object object = !r.deleted() ? handler.apply((Object)r.key(), reader.apply((Object)BoxesRunTime.boxToLong((long)DataInputX.toLong5(r.dataPos(), 0)))) : BoxedUnit.UNIT;
                ++done;
                pos = r.offset();
            }
        }
        catch (Throwable throwable) {
            Logger$.MODULE$.println("S126", new StringBuilder().append((Object)this.keyFile().path()).append((Object)" : read=").append((Object)BoxesRunTime.boxToInteger((int)done)).append((Object)" pos=").append((Object)BoxesRunTime.boxToLong((long)pos)).append((Object)" file-len=").append((Object)BoxesRunTime.boxToLong((long)length)).append((Object)" ").append((Object)throwable).toString());
        }
    }

    public Map<String, Number> getStat() {
        int deleted = 0;
        int count = 0;
        long pos = this.keyFile().getFirstPos();
        long length = this.keyFile().getLength();
        while (pos < length && pos > 0L) {
            KeyFileItem2 r = this.keyFile().getRecord(pos);
            if (r.deleted()) {
                ++deleted;
            } else {
                ++count;
            }
            pos = r.offset();
        }
        int scatter = this.hashBlock().getCount();
        HashMap<String, Number> out = new HashMap<String, Number>();
        out.put("count", Predef$.MODULE$.int2Integer(count));
        out.put("scatter", Predef$.MODULE$.int2Integer(scatter));
        out.put("deleted", Predef$.MODULE$.int2Integer(deleted));
        out.put("scan", Predef$.MODULE$.float2Float((float)(count + deleted) / (float)scatter));
        return out;
    }

    @Override
    public void close() {
        this.hashBlock().close();
        this.keyFile().close();
    }

    public IndexKeyFile2(String _path, int hashSize) {
        this.MB = 0x100000;
        this.path = _path;
        this.hashBlock = new MemHashBlock(this.path(), hashSize * this.MB());
        this.keyFile = new RealKeyFile2(this.path());
    }
}

