/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.http.handler;

import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import scouter.io.DataOutputX;
import scouter.lang.pack.ObjectPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.PerfCounterPack;
import scouter.lang.value.FloatValue;
import scouter.net.NetCafe;
import scouter.server.CounterManager;
import scouter.server.Logger;
import scouter.server.netio.data.NetDataProcessor;
import scouter.util.HashUtil;
import scouter.util.IPUtil;
import scouter.util.StringUtil;

public class CounterHandler {
    static CounterManager counterManager = CounterManager.getInstance();

    public static void process(Reader in) {
        JSONParser parser = new JSONParser();
        try {
            Object o = parser.parse(in);
            if (o instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)o;
                for (int i = 0; i < jsonArray.size(); ++i) {
                    Object element = jsonArray.get(i);
                    if (!(element instanceof JSONObject)) continue;
                    CounterHandler.process((JSONObject)element);
                }
            } else if (o instanceof JSONObject) {
                CounterHandler.process((JSONObject)o);
            } else {
                Logger.println("SC-8001", 30, "Incorrect body");
            }
        }
        catch (Throwable th) {
            Logger.println("SC-8000", 30, "Http body parsing error", th);
        }
    }

    private static void process(JSONObject json) throws Exception {
        JSONObject objectInfo = (JSONObject)json.get((Object)"object");
        if (objectInfo != null) {
            ObjectPack objPack = CounterHandler.extractObjectPack(objectInfo);
            InetAddress addr = CounterHandler.extractIpv4Address(objectInfo);
            CounterHandler.passToNetDataProcessor(objPack, addr);
            JSONArray perfArray = (JSONArray)json.get((Object)"counters");
            if (perfArray != null) {
                PerfCounterPack perfPack = CounterHandler.extractPerfCounterPack(perfArray, objPack.objName);
                CounterHandler.passToNetDataProcessor(perfPack, addr);
            }
        }
    }

    private static ObjectPack extractObjectPack(JSONObject objJson) {
        String host2 = (String)objJson.get((Object)"host");
        String name = (String)objJson.get((Object)"name");
        String objName = CounterHandler.getObjName(host2, name);
        int objHash = HashUtil.hash(objName);
        ObjectPack objPack = new ObjectPack();
        objPack.objHash = objHash;
        objPack.objName = objName;
        objPack.objType = (String)objJson.get((Object)"type");
        objPack.address = (String)objJson.get((Object)"address");
        return objPack;
    }

    private static InetAddress extractIpv4Address(JSONObject objJson) throws UnknownHostException {
        String address = (String)objJson.get((Object)"address");
        InetAddress addr = InetAddress.getByAddress(IPUtil.toBytes(address));
        return addr;
    }

    private static PerfCounterPack extractPerfCounterPack(JSONArray perfJson, String objName) {
        PerfCounterPack perfPack = new PerfCounterPack();
        perfPack.time = System.currentTimeMillis();
        perfPack.timetype = 1;
        perfPack.objName = objName;
        for (int i = 0; i < perfJson.size(); ++i) {
            JSONObject perf = (JSONObject)perfJson.get(i);
            String name = (String)perf.get((Object)"name");
            Number value = (Number)perf.get((Object)"value");
            perfPack.data.put(name, new FloatValue(value.floatValue()));
        }
        return perfPack;
    }

    private static void passToNetDataProcessor(Pack pack, InetAddress addr) throws IOException {
        DataOutputX out = new DataOutputX();
        out.write(NetCafe.CAFE);
        out.write(new DataOutputX().writePack(pack).toByteArray());
        NetDataProcessor.add(out.toByteArray(), addr);
    }

    private static String getObjName(String host2, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append(host2);
        if (StringUtil.isNotEmpty(name)) {
            sb.append("/");
            sb.append(name);
        }
        return sb.toString();
    }
}

