/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.http.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import scouter.lang.Counter;
import scouter.lang.DeltaType;
import scouter.lang.ObjectType;
import scouter.server.Logger;
import scouter.server.http.model.InfluxSingleLine;
import scouter.server.support.telegraf.TgCounterMapping;
import scouter.util.StringUtil;

public class CounterProtocol
extends Counter {
    private static final long KEEP_FRESH_MILLIS = 15000L;
    private boolean fresh = true;
    private long initTimestamp = System.currentTimeMillis();
    private List<String> nameTags = new ArrayList<String>();
    private List<String> displayNameTags = new ArrayList<String>();
    private int normalizeSec = 0;
    private DeltaType deltaType = DeltaType.NONE;

    public CounterProtocol() {
    }

    public CounterProtocol(String name) {
        super(name);
    }

    public static CounterProtocol of(TgCounterMapping mapping) {
        CounterProtocol counter = new CounterProtocol();
        counter.setName(mapping.counterName);
        counter.setDeltaType(mapping.deltaType);
        if (StringUtil.isNotEmpty(mapping.displayName)) {
            counter.setDisplayName(mapping.displayName);
        } else {
            counter.setDisplayName(mapping.counterName);
        }
        counter.setUnit(mapping.unit);
        counter.setTotal(mapping.totalizable);
        counter.setNormalizeSec(mapping.normalizeSeconds);
        return counter;
    }

    private void setFreshFalseIfIntervalExpired() {
        if (System.currentTimeMillis() - this.initTimestamp > 15000L) {
            this.fresh = false;
        }
    }

    public void setDeltaType(DeltaType deltaType) {
        this.deltaType = deltaType;
    }

    public DeltaType getDeltaType() {
        return this.deltaType;
    }

    public void setNormalizeSec(int normalizeSec) {
        this.normalizeSec = normalizeSec < 4 ? 0 : (normalizeSec > 60 ? 60 : normalizeSec);
    }

    public int getNormalizeSec() {
        return this.normalizeSec;
    }

    @Override
    public void setName(String nameWithTag) {
        char[] chars = nameWithTag.toCharArray();
        StringBuilder nameBuilder = new StringBuilder(chars.length);
        StringBuilder tagBuilder = new StringBuilder(chars.length);
        boolean sink = false;
        block3: for (char c : chars) {
            switch (c) {
                case '$': {
                    boolean bl = sink = !sink;
                    if (sink) continue block3;
                    nameBuilder.append('*');
                    tagBuilder.append('*');
                    continue block3;
                }
                default: {
                    if (!sink) {
                        nameBuilder.append(c);
                        continue block3;
                    }
                    tagBuilder.append(c);
                }
            }
        }
        String name = nameBuilder.toString();
        super.setName(name);
        if (tagBuilder.length() > 0) {
            this.nameTags = StringUtil.splitAsList(tagBuilder.toString(), '*');
        }
    }

    @Override
    public void setDisplayName(String displayNameWithTag) {
        char[] chars = displayNameWithTag.toCharArray();
        StringBuilder nameBuilder = new StringBuilder(chars.length);
        StringBuilder tagBuilder = new StringBuilder(chars.length);
        boolean sink = false;
        block3: for (char c : chars) {
            switch (c) {
                case '$': {
                    boolean bl = sink = !sink;
                    if (sink) continue block3;
                    nameBuilder.append('*');
                    tagBuilder.append('*');
                    continue block3;
                }
                default: {
                    if (!sink) {
                        nameBuilder.append(c);
                        continue block3;
                    }
                    tagBuilder.append(c);
                }
            }
        }
        String displayName = nameBuilder.toString();
        super.setDisplayName(displayName);
        if (tagBuilder.length() > 0) {
            this.displayNameTags = StringUtil.splitAsList(tagBuilder.toString(), '*');
        }
    }

    public String getTaggedName(Map<String, String> tagMap) {
        return this.generateTaggedName(this.getName(), this.nameTags, tagMap);
    }

    public String getTaggedDelataName(Map<String, String> tagMap) {
        return this.generateTaggedDeltaName(this.getName(), this.nameTags, tagMap);
    }

    public String getTaggedDisplayName(Map<String, String> tagMap) {
        return this.generateTaggedName(this.getDisplayName(), this.displayNameTags, tagMap);
    }

    public String getTaggedDeltaDisplayName(Map<String, String> tagMap) {
        return this.generateTaggedDeltaName(this.getDisplayName(), this.displayNameTags, tagMap);
    }

    public String getDelateUnit() {
        return this.generateDeltaUnit(this.getUnit());
    }

    private String generateTaggedDeltaName(String name, List<String> tags, Map<String, String> tagMap) {
        return this.generateTaggedName(name, tags, tagMap) + "_$delta";
    }

    private String generateTaggedName(String name, List<String> tags, Map<String, String> tagMap) {
        if (tags == null || tags.size() == 0) {
            return name;
        }
        if (name.indexOf(42) < 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name.length());
        int tagCounter = 0;
        block3: for (char c : name.toCharArray()) {
            switch (c) {
                case '*': {
                    sb.append(tagMap.get(tags.get(tagCounter++)));
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private String generateDeltaUnit(String unit) {
        return unit + "/s";
    }

    public List<Counter> toCounters(Map<String, String> tagMap) {
        ArrayList<Counter> counters = new ArrayList<Counter>();
        if (this.hasNormalCounter()) {
            counters.add(this.toNormalCounter(tagMap));
        }
        if (this.hasDeltaCounter()) {
            counters.add(this.toDeltaCounter(tagMap));
        }
        return counters;
    }

    public Counter toNormalCounter(Map<String, String> tagMap) {
        if (!this.hasNormalCounter()) {
            return null;
        }
        Counter normalCounter = this.clone();
        normalCounter.setName(this.generateTaggedName(this.getName(), this.nameTags, tagMap));
        normalCounter.setDisplayName(this.generateTaggedName(this.getDisplayName(), this.displayNameTags, tagMap));
        return normalCounter;
    }

    public Counter toDeltaCounter(Map<String, String> tagMap) {
        if (!this.hasDeltaCounter()) {
            return null;
        }
        Counter deltaCounter = this.clone();
        deltaCounter.setName(this.generateTaggedDeltaName(this.getName(), this.nameTags, tagMap));
        deltaCounter.setDisplayName(this.generateTaggedDeltaName(this.getDisplayName(), this.displayNameTags, tagMap));
        deltaCounter.setUnit(this.generateDeltaUnit(deltaCounter.getUnit()));
        return deltaCounter;
    }

    public boolean hasDeltaCounter() {
        return this.getDeltaType() == DeltaType.DELTA || this.getDeltaType() == DeltaType.BOTH;
    }

    public boolean hasNormalCounter() {
        return this.getDeltaType() != DeltaType.DELTA;
    }

    public boolean isNewOrChangedCounter(ObjectType objectType, InfluxSingleLine line) {
        boolean isNew = this.checkNewOrChanged4NormalCounter(objectType, line);
        if (!isNew) {
            isNew = this.checkNewOrChanged4DeltaCounter(objectType, line);
            if (isNew) {
                Logger.println("New Telegraf Delta Counter : " + this.getTaggedDelataName(line.getTags()));
            }
        } else {
            Logger.println("New Telegraf Counter : " + this.getTaggedName(line.getTags()));
        }
        this.setFreshFalseIfIntervalExpired();
        return isNew;
    }

    private boolean checkNewOrChanged4NormalCounter(ObjectType objectType, InfluxSingleLine line) {
        if (!this.hasNormalCounter()) {
            return false;
        }
        Counter counter = objectType.getCounter(this.getTaggedName(line.getTags()));
        if (counter == null) {
            return true;
        }
        return this.checkChangedDeeper(false, counter, line, this.getUnit(), this.getIcon());
    }

    private boolean checkNewOrChanged4DeltaCounter(ObjectType objectType, InfluxSingleLine line) {
        if (!this.hasDeltaCounter()) {
            return false;
        }
        Counter counter = objectType.getCounter(this.getTaggedDelataName(line.getTags()));
        if (counter == null) {
            return true;
        }
        return this.checkChangedDeeper(true, counter, line, this.generateDeltaUnit(this.getUnit()), this.getIcon());
    }

    private boolean checkChangedDeeper(boolean isDeltaCounter, Counter counter, InfluxSingleLine line, String unit, String icon) {
        if (this.fresh) {
            String taggedDisplayName;
            String string = taggedDisplayName = isDeltaCounter ? this.getTaggedDeltaDisplayName(line.getTags()) : this.getTaggedDisplayName(line.getTags());
            if (!(taggedDisplayName.equals(counter.getDisplayName()) && unit.equals(counter.getUnit()) && icon.equals(counter.getIcon()) && this.isTotal() == counter.isTotal())) {
                return true;
            }
        }
        return false;
    }
}

