/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.kube;

import java.util.concurrent.ConcurrentHashMap;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.ObjectPack;
import scouter.server.Logger;
import scouter.server.netio.AgentCall;
import scouter.util.StringUtil;

public class PodSeqManager {
    private static final ConcurrentHashMap<String, PodSeqManager> managerMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ObjectPack> initialHostObjMap = new ConcurrentHashMap();
    private final Object lock = new Object();
    private final String podName;
    private final ConcurrentHashMap<String, Integer> hostSeqMap;
    private final ConcurrentHashMap<Integer, String> seqHostMap;

    private PodSeqManager(String podName) {
        this.podName = podName;
        this.hostSeqMap = new ConcurrentHashMap();
        this.seqHostMap = new ConcurrentHashMap();
    }

    public static synchronized PodSeqManager getInstance(String podName) {
        return managerMap.computeIfAbsent(podName, PodSeqManager::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPodSeq(ObjectPack pack) {
        Object object = this.lock;
        synchronized (object) {
            String hostName = pack.tags.getText("hostName");
            int kubeSeq = pack.tags.getInt("kubeSeq");
            boolean useKubeSeq = pack.tags.getBoolean("useKubeSeq");
            pack.addKubeProp(this.podName, hostName, -1);
            if (!useKubeSeq || StringUtil.isEmpty(hostName)) {
                return;
            }
            if (kubeSeq <= -1) {
                Logger.println("S104-0", String.format("Init host agent for hostName: %s, pod: %s, obj: %s", hostName, this.podName, pack));
                this.applyNewPodSeqToPack(pack, hostName);
            } else {
                pack.podSeq = kubeSeq;
                String hostInMap = this.seqHostMap.get(kubeSeq);
                if (hostInMap == null) {
                    Logger.println("S104-1", String.format("recover host's pod seq: %s, host: %s, pod: %s", kubeSeq, hostName, this.podName));
                    this.seqHostMap.put(kubeSeq, hostName);
                    this.hostSeqMap.put(hostName, kubeSeq);
                } else if (!hostInMap.equals(hostName)) {
                    Logger.println("S104-2", String.format("already taken the pod seq: %s, it will be init. host: %s, pod: %s", kubeSeq, hostName, this.podName));
                    this.applyNewPodSeqToPack(pack, hostName);
                } else {
                    initialHostObjMap.remove(hostName);
                }
            }
        }
    }

    private void applyNewPodSeqToPack(ObjectPack pack, String hostName) {
        pack.pushSeq = true;
        ObjectPack initialPack = initialHostObjMap.get(hostName);
        if (initialPack == null) {
            initialHostObjMap.put(hostName, pack);
            pack.initialTime = System.currentTimeMillis();
            pack.podSeq = this.getNewPodSeq(hostName);
            pack.allowProceed = false;
        } else {
            pack.copyKubePropFrom(initialPack);
            if (initialPack.initialTime > System.currentTimeMillis() - 15000L) {
                pack.allowProceed = false;
            } else {
                pack.pushSeq = false;
                this.removePodSeq(hostName);
            }
        }
    }

    private int getNewPodSeq(String hostName) {
        Integer prevSeq = this.hostSeqMap.get(hostName);
        if (prevSeq != null) {
            this.seqHostMap.put(prevSeq, hostName);
            return prevSeq;
        }
        int newSeq = -1;
        for (int i = 0; i < 10000; ++i) {
            String hostInMap = this.seqHostMap.get(i);
            if (hostInMap != null) continue;
            newSeq = i;
            this.hostSeqMap.put(hostName, newSeq);
            this.seqHostMap.put(newSeq, hostName);
            break;
        }
        return newSeq;
    }

    public void objectInactivated(String hostName) {
        if (hostName != null) {
            this.removePodSeq(hostName);
            this.removeInitialHostObject(hostName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePodSeq(String hostName) {
        Object object = this.lock;
        synchronized (object) {
            Integer seq = this.hostSeqMap.remove(hostName);
            if (seq != null) {
                this.seqHostMap.remove(seq);
            }
        }
    }

    private void removeInitialHostObject(String hostName) {
        initialHostObjMap.remove(hostName);
    }

    public static void pushSeqToAgent(ObjectPack pack) {
        if (pack.pushSeq) {
            try {
                MapPack param = new MapPack();
                param.put("seq", pack.podSeq);
                AgentCall.call(pack, "OBJECT_SET_KUBE_SEQ", param);
            }
            catch (Exception e) {
                Logger.println("S104-e1", 10, "error to call agent " + pack + ", err: " + e.getMessage());
            }
        }
    }
}

