/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.netio.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.server.Configure;
import scouter.server.Logger;
import scouter.server.netio.service.anotation.ServiceHandler;
import scouter.util.scan.Scanner;

public class ServiceHandlingProxy {
    protected static HashMap<String, Invocation> handlers = new HashMap();

    public static void load() {
        String pkg = Scanner.cutOutLast(ServiceHandlingProxy.class.getName(), ".");
        Set<String> classes = new Scanner(pkg).process(ServiceHandlingProxy.class.getClassLoader());
        Set<String> custom = new Scanner(System.getProperty("scouter.handler")).process();
        classes.addAll(custom);
        Iterator<String> itr = classes.iterator();
        while (itr.hasNext()) {
            try {
                Class<?> c = Class.forName(itr.next());
                if (!Modifier.isPublic(c.getModifiers())) continue;
                try {
                    Method[] m = c.getDeclaredMethods();
                    for (int i = 0; i < m.length; ++i) {
                        ServiceHandler mapAn = m[i].getAnnotation(ServiceHandler.class);
                        if (mapAn == null) continue;
                        String key = mapAn.value();
                        Invocation news = new Invocation(c.newInstance(), m[i]);
                        Invocation olds = handlers.get(key);
                        if (olds != null) {
                            Logger.println("Warning duplicated Handler key=" + key + " old=" + olds + " new=" + news);
                        } else if (Configure.getInstance().log_service_handler_list) {
                            Logger.println("ServiceHandler " + key + "=>" + news);
                        }
                        handlers.put(key, news);
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void process(String cmd, DataInputX in, DataOutputX out, boolean login) {
        Invocation handler = handlers.get(cmd);
        if (handler == null) {
            throw new RuntimeException("no handler  cmd=" + cmd);
        }
        handler.exec(in, out, login);
    }

    public static void main(String[] args) {
        ServiceHandlingProxy.load();
    }

    protected static class Invocation {
        Object object;
        Method method;

        public Invocation(Object object, Method method) {
            this.object = object;
            this.method = method;
        }

        public void exec(DataInputX in, DataOutputX out, boolean login) {
            try {
                this.method.invoke(this.object, in, out, login);
            }
            catch (InvocationTargetException t) {
                if (t.getCause() != null) {
                    t.getCause().printStackTrace();
                } else {
                    t.printStackTrace();
                }
            }
            catch (Exception e) {
                Logger.println("S777", 10, "Service Exception", e);
                e.printStackTrace();
            }
        }

        public String toString() {
            return this.object.getClass().getName() + "." + this.method.getName();
        }
    }
}

