/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.netio.service.handle;

import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.CounterKey;
import scouter.lang.TimeTypeEnum;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.ObjectPack;
import scouter.lang.value.DoubleValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.NullValue;
import scouter.lang.value.Value;
import scouter.server.core.AgentManager$;
import scouter.server.db.DailyCounterRD$;
import scouter.server.netio.service.anotation.ServiceHandler;
import scouter.server.netio.service.handle.DailyCounterService$;
import scouter.util.ArrayUtil;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.StringUtil;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u00015\u00111\u0003R1jYf\u001cu.\u001e8uKJ\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\r!\fg\u000e\u001a7f\u0015\t)a!A\u0004tKJ4\u0018nY3\u000b\u0005\u001dA\u0011!\u00028fi&|'BA\u0005\u000b\u0003\u0019\u0019XM\u001d<fe*\t1\"A\u0004tG>,H/\u001a:\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012aD4fi\u0012\u000b\u0017\u000e\\=D_VtG/\u001a:\u0015\tqyr\u0005\f\t\u0003\u001fuI!A\b\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006Ae\u0001\r!I\u0001\u0004I&t\u0007C\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u000b\u0003\tIw.\u0003\u0002'G\tQA)\u0019;b\u0013:\u0004X\u000f\u001e-\t\u000b!J\u0002\u0019A\u0015\u0002\t\u0011|W\u000f\u001e\t\u0003E)J!aK\u0012\u0003\u0017\u0011\u000bG/Y(viB,H\u000f\u0017\u0005\u0006[e\u0001\rAL\u0001\u0006Y><\u0017N\u001c\t\u0003\u001f=J!\u0001\r\t\u0003\u000f\t{w\u000e\\3b]\"\"\u0011D\r\u001d:!\t\u0019d'D\u00015\u0015\t)D!A\u0005b]>$\u0018\r^5p]&\u0011q\u0007\u000e\u0002\u000f'\u0016\u0014h/[2f\u0011\u0006tG\r\\3s\u0003\u00151\u0018\r\\;fC\u0005Q\u0014!D\"P+:#VIU0U\u001f\u0012\u000b\u0015\fC\u0003=\u0001\u0011\u0005Q(\u0001\nhKR$\u0015-\u001b7z\u0007>,h\u000e^3s\u00032dG\u0003\u0002\u000f?\u007f\u0001CQ\u0001I\u001eA\u0002\u0005BQ\u0001K\u001eA\u0002%BQ!L\u001eA\u00029BCa\u000f\u001a9\u0005\u0006\n1)A\tD\u001fVsE+\u0012*`)>#\u0015)W0B\u00192CQ!\u0012\u0001\u0005\u0002\u0019\u000b\u0001cZ3u%\u0016\fG\u000eR1uKR{G/\u00197\u0015\tq9\u0005*\u0013\u0005\u0006A\u0011\u0003\r!\t\u0005\u0006Q\u0011\u0003\r!\u000b\u0005\u0006[\u0011\u0003\rA\f\u0015\u0005\tJB4*I\u0001M\u0003E\u0019u*\u0016(U\u000bJ{Fk\u0014#B3~#v\n\u0016\u0005\u0006\u001d\u0002!\taT\u0001\u0018O\u0016$\b+Y:u\t\u0006$X\rV8uC2\u001cu.\u001e8uKJ$B\u0001\b)R%\")\u0001%\u0014a\u0001C!)\u0001&\u0014a\u0001S!)Q&\u0014a\u0001]!\"QJ\r\u001dUC\u0005)\u0016!F\"P+:#VIU0Q\u0003N#v\fR!U\u000b~#v\n\u0016\u0005\u0006/\u0002!\t\u0001W\u0001\u000fO\u0016$\b+Y:u\t\u0006$X-\u00117m)\u0011a\u0012LW.\t\u000b\u00012\u0006\u0019A\u0011\t\u000b!2\u0006\u0019A\u0015\t\u000b52\u0006\u0019\u0001\u0018)\tY\u0013\u0004(X\u0011\u0002=\u0006)2iT+O)\u0016\u0013v\fU!T)~#\u0015\tV#`\u00032c\u0005\"\u00021\u0001\t\u0003\t\u0017AE4fiB\u000b7\u000f\u001e'p]\u001e$\u0015\r^3BY2$B\u0001\b2dI\")\u0001e\u0018a\u0001C!)\u0001f\u0018a\u0001S!)Qf\u0018a\u0001]!\"qL\r\u001dgC\u00059\u0017!G\"P+:#VIU0Q\u0003N#v\fT(O\u000f\u0012\u000bE+R0B\u00192CQ!\u001b\u0001\u0005\u0002)\f!cZ3u!\u0006\u001cH\u000fT8oO\u0012\u000bG/\u001a+piR!Ad\u001b7n\u0011\u0015\u0001\u0003\u000e1\u0001\"\u0011\u0015A\u0003\u000e1\u0001*\u0011\u0015i\u0003\u000e1\u0001/Q\u0011A'\u0007O8\"\u0003A\f\u0011dQ(V\u001dR+%k\u0018)B'R{Fj\u0014(H\t\u0006#Vi\u0018+P)\")!\u000f\u0001C\u0001g\u0006Yq-\u001a;QCN$H)\u0019;f)\u0011aB/\u001e<\t\u000b\u0001\n\b\u0019A\u0011\t\u000b!\n\b\u0019A\u0015\t\u000b5\n\b\u0019\u0001\u0018)\tE\u0014\u0004\b_\u0011\u0002s\u0006\t2iT+O)\u0016\u0013v\fU!T)~#\u0015\tV#\t\u000bm\u0004A\u0011\u0001?\u0002'\u001d,GoQ8v]R,'/\u0012=jgR$\u0015-_:\u0015\tqihp \u0005\u0006Ai\u0004\r!\t\u0005\u0006Qi\u0004\r!\u000b\u0005\u0006[i\u0004\rA\f\u0015\u0006uJB\u00141A\u0011\u0003\u0003\u000b\tacR#U?\u000e{UK\u0014+F%~+\u0005,S*U?\u0012\u000b\u0015l\u0015\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0003A9W\r\u001e)bgR$\u0015\r^3He>,\b\u000fF\u0004\u001d\u0003\u001b\ty!!\u0005\t\r\u0001\n9\u00011\u0001\"\u0011\u0019A\u0013q\u0001a\u0001S!1Q&a\u0002A\u00029Bc!a\u00023q\u0005U\u0011EAA\f\u0003]\u0019u*\u0016(U\u000bJ{\u0006+Q*U?\u0012\u000bE+R0H%>+\u0006\u000bC\u0004\u0002\u001c\u0001!\t!!\b\u0002\u001b\u001d,G\u000fV8eCf<%o\\;q)\u001da\u0012qDA\u0011\u0003GAa\u0001IA\r\u0001\u0004\t\u0003B\u0002\u0015\u0002\u001a\u0001\u0007\u0011\u0006\u0003\u0004.\u00033\u0001\rA\f\u0015\u0007\u00033\u0011\u0004(a\n\"\u0005\u0005%\u0012aE\"P+:#VIU0U\u001f\u0012\u000b\u0015lX$S\u001fV\u0003\u0006bBA\u0017\u0001\u0011\u0005\u0011qF\u0001\u0015O\u0016$\b+Y:u\u0019>tw\rR1uK\u001e\u0013x.\u001e9\u0015\u000fq\t\t$a\r\u00026!1\u0001%a\u000bA\u0002\u0005Ba\u0001KA\u0016\u0001\u0004I\u0003BB\u0017\u0002,\u0001\u0007a\u0006\u000b\u0004\u0002,IB\u0014\u0011H\u0011\u0003\u0003w\t1dQ(V\u001dR+%k\u0018)B'R{Fj\u0014(H\t\u0006#ViX$S\u001fV\u0003\u0006")
public class DailyCounterService {
    @ServiceHandler(value="COUNTER_TODAY")
    public void getDailyCounter(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        int objHash = param.getInt("objHash");
        String counter = param.getText("counter");
        byte timetype = (byte)param.getInt("timetype");
        String date = DateUtil.yyyymmdd();
        long stime = DateUtil.yyyymmdd(date);
        CounterKey ck = new CounterKey(objHash, counter, timetype);
        Value[] v = DailyCounterRD$.MODULE$.getValues(date, ck);
        MapPack mpack = new MapPack();
        ListValue timeLv = mpack.newList("time");
        ListValue valueLv = mpack.newList("value");
        int delta = TimeTypeEnum.getTime(ck.timetype);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len((Object)v) - 1).foreach((Function1)new Serializable(this, stime, v, timeLv, valueLv, delta){
            public static final long serialVersionUID = 0L;
            private final long stime$1;
            private final Value[] v$1;
            private final ListValue timeLv$1;
            private final ListValue valueLv$1;
            private final int delta$1;

            public final ListValue apply(int i) {
                long time = this.stime$1 + (long)(this.delta$1 * i);
                Value value = this.v$1[i];
                if (value == null) {
                    value = new NullValue();
                }
                this.timeLv$1.add(time);
                return this.valueLv$1.add(value);
            }
            {
                this.stime$1 = stime$1;
                this.v$1 = v$1;
                this.timeLv$1 = timeLv$1;
                this.valueLv$1 = valueLv$1;
                this.delta$1 = delta$1;
            }
        });
        dout.writeByte(3);
        dout.writePack(mpack);
    }

    @ServiceHandler(value="COUNTER_TODAY_ALL")
    public void getDailyCounterAll(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String counter = param.getText("counter");
        String objType2 = param.getText("objType");
        if (StringUtil.isEmpty(objType2)) {
            System.out.println("please check.. COUNTER_TODAY_ALL objType is null");
            return;
        }
        String date = DateUtil.yyyymmdd();
        long stime = DateUtil.yyyymmdd(date);
        MapPack objPackMap = AgentManager$.MODULE$.getCurrentObjects(objType2);
        ListValue objHashLv = objPackMap.getList("objHash");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len(objHashLv) - 1).foreach((Function1)new Serializable(this, dout, counter, date, stime, objHashLv){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$1;
            private final String counter$1;
            private final String date$1;
            public final long stime$2;
            private final ListValue objHashLv$1;

            public final Object apply(int i) {
                Object object;
                int objHash = this.objHashLv$1.getInt(i);
                try {
                    CounterKey ck = new CounterKey(objHash, this.counter$1, 3);
                    Value[] v = DailyCounterRD$.MODULE$.getValues(this.date$1, ck);
                    if (v != null) {
                        MapPack mpack = new MapPack();
                        mpack.put("objHash", objHash);
                        ListValue timeLv = mpack.newList("time");
                        ListValue valueLv = mpack.newList("value");
                        int delta = TimeTypeEnum.getTime(ck.timetype);
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), v.length - 1).foreach((Function1)new Serializable(this, v, timeLv, valueLv, delta){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$getDailyCounterAll$1 $outer;
                            private final Value[] v$2;
                            private final ListValue timeLv$2;
                            private final ListValue valueLv$2;
                            private final int delta$2;

                            public final ListValue apply(int j) {
                                long time = this.$outer.stime$2 + (long)(this.delta$2 * j);
                                Value value = this.v$2[j];
                                if (value == null) {
                                    value = new NullValue();
                                }
                                this.timeLv$2.add(time);
                                return this.valueLv$2.add(value);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.v$2 = v$2;
                                this.timeLv$2 = timeLv$2;
                                this.valueLv$2 = valueLv$2;
                                this.delta$2 = delta$2;
                            }
                        });
                        this.dout$1.writeByte(3);
                        object = this.dout$1.writePack(mpack);
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                }
                catch (Throwable throwable) {
                    ObjectPack op = AgentManager$.MODULE$.getAgent(objHash);
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)op.objName).append((Object)" invalid data : ").append((Object)throwable.getMessage()).toString());
                    throwable.printStackTrace();
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                this.dout$1 = dout$1;
                this.counter$1 = counter$1;
                this.date$1 = date$1;
                this.stime$2 = stime$2;
                this.objHashLv$1 = objHashLv$1;
            }
        });
    }

    @ServiceHandler(value="COUNTER_TODAY_TOT")
    public void getRealDateTotal(DataInputX din, DataOutputX dout, boolean login) {
        MapPack inout = din.readMapPack();
        String counter = inout.getText("counter");
        String mode = inout.getText("mode");
        String objType2 = inout.getText("objType");
        if (StringUtil.isEmpty(objType2)) {
            System.out.println("please check.. COUNTER_TODAY_TOT objType is null");
            return;
        }
        String date = DateUtil.yyyymmdd();
        byte period = 3;
        int delta = TimeTypeEnum.getTime(period);
        int timeLength = TimeTypeEnum.getTime((byte)6) / delta;
        double[] values = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{timeLength}), ClassTag$.MODULE$.Double());
        int[] cnt = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{timeLength}), ClassTag$.MODULE$.Int());
        MapPack objPackMap = AgentManager$.MODULE$.getCurrentObjects(objType2);
        ListValue objHashLv = objPackMap.getList("objHash");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len(objHashLv) - 1).foreach$mVc$sp((Function1)new Serializable(this, counter, date, period, values, cnt, objHashLv){
            public static final long serialVersionUID = 0L;
            private final String counter$2;
            private final String date$2;
            private final byte period$1;
            public final double[] values$1;
            public final int[] cnt$1;
            private final ListValue objHashLv$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int objHash = this.objHashLv$2.getInt(i);
                try {
                    CounterKey ck = new CounterKey(objHash, this.counter$2, this.period$1);
                    Value[] v = DailyCounterRD$.MODULE$.getValues(this.date$2, ck);
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len((Object)v) - 1).foreach$mVc$sp((Function1)new Serializable(this, v){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$getRealDateTotal$1 $outer;
                        private final Value[] v$3;

                        public final void apply(int j) {
                            this.apply$mcVI$sp(j);
                        }

                        public void apply$mcVI$sp(int j) {
                            double doubleValue;
                            Value value = this.v$3[j];
                            double d = doubleValue = value == null ? 0.0 : CastUtil.cdouble(value);
                            if (doubleValue > 0.0) {
                                this.$outer.cnt$1[j] = this.$outer.cnt$1[j] + 1;
                                this.$outer.values$1[j] = this.$outer.values$1[j] + doubleValue;
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.v$3 = v$3;
                        }
                    });
                }
                catch (Throwable throwable) {
                    ObjectPack op = AgentManager$.MODULE$.getAgent(objHash);
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)op.objName).append((Object)" invalid data : ").append((Object)throwable.getMessage()).toString());
                    throwable.printStackTrace();
                }
            }
            {
                this.counter$2 = counter$2;
                this.date$2 = date$2;
                this.period$1 = period$1;
                this.values$1 = values$1;
                this.cnt$1 = cnt$1;
                this.objHashLv$2 = objHashLv$2;
            }
        });
        long stime = DateUtil.yyyymmdd(date);
        MapPack mpack = new MapPack();
        ListValue timeLv = mpack.newList("time");
        ListValue valueLv = mpack.newList("value");
        boolean isAvg = "avg".equalsIgnoreCase(mode);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), values.length - 1).foreach((Function1)new Serializable(this, delta, values, cnt, stime, timeLv, valueLv, isAvg){
            public static final long serialVersionUID = 0L;
            private final int delta$3;
            private final double[] values$1;
            private final int[] cnt$1;
            private final long stime$3;
            private final ListValue timeLv$3;
            private final ListValue valueLv$3;
            private final boolean isAvg$1;

            public final ListValue apply(int i) {
                this.timeLv$3.add(this.stime$3 + (long)(this.delta$3 * i));
                if (this.isAvg$1 && this.cnt$1[i] > 1) {
                    this.values$1[i] = this.values$1[i] / (double)this.cnt$1[i];
                }
                return this.valueLv$3.add(new DoubleValue(this.values$1[i]));
            }
            {
                this.delta$3 = delta$3;
                this.values$1 = values$1;
                this.cnt$1 = cnt$1;
                this.stime$3 = stime$3;
                this.timeLv$3 = timeLv$3;
                this.valueLv$3 = valueLv$3;
                this.isAvg$1 = isAvg$1;
            }
        });
        dout.writeByte(3);
        dout.writePack(mpack);
    }

    @ServiceHandler(value="COUNTER_PAST_DATE_TOT")
    public void getPastDateTotalCounter(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String counter = param.getText("counter");
        String date = param.getText("date");
        String mode = param.getText("mode");
        String objType2 = param.getText("objType");
        if (StringUtil.isEmpty(objType2)) {
            System.out.println("please check.. COUNTER_PAST_DATE_TOT objType is null");
            return;
        }
        byte period = 3;
        int delta = TimeTypeEnum.getTime(period);
        int timeLength = TimeTypeEnum.getTime((byte)6) / delta;
        double[] values = new double[timeLength];
        int[] cnt = new int[timeLength];
        MapPack agentGrp = AgentManager$.MODULE$.getDailyObjects(date, objType2);
        ListValue objHashLv = agentGrp.getList("objHash");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len(objHashLv) - 1).foreach$mVc$sp((Function1)new Serializable(this, counter, date, period, values, cnt, objHashLv){
            public static final long serialVersionUID = 0L;
            private final String counter$3;
            private final String date$3;
            private final byte period$2;
            public final double[] values$2;
            public final int[] cnt$2;
            private final ListValue objHashLv$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int objHash = this.objHashLv$3.getInt(i);
                CounterKey ckey = new CounterKey(objHash, this.counter$3, this.period$2);
                Value[] outvalue = DailyCounterRD$.MODULE$.getValues(this.date$3, ckey);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len((Object)outvalue) - 1).foreach$mVc$sp((Function1)new Serializable(this, outvalue){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getPastDateTotalCounter$1 $outer;
                    private final Value[] outvalue$1;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        Value value = this.outvalue$1[j];
                        if (value != null) {
                            this.$outer.cnt$2[j] = this.$outer.cnt$2[j] + 1;
                            this.$outer.values$2[j] = this.$outer.values$2[j] + CastUtil.cdouble(value);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.outvalue$1 = outvalue$1;
                    }
                });
            }
            {
                this.counter$3 = counter$3;
                this.date$3 = date$3;
                this.period$2 = period$2;
                this.values$2 = values$2;
                this.cnt$2 = cnt$2;
                this.objHashLv$3 = objHashLv$3;
            }
        });
        long stime = DateUtil.yyyymmdd(date);
        MapPack mpack = new MapPack();
        ListValue timeLv = mpack.newList("time");
        ListValue valueLv = mpack.newList("value");
        boolean isAvg = "avg".equalsIgnoreCase(mode);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), values.length - 1).foreach((Function1)new Serializable(this, delta, values, cnt, stime, timeLv, valueLv, isAvg){
            public static final long serialVersionUID = 0L;
            private final int delta$4;
            private final double[] values$2;
            private final int[] cnt$2;
            private final long stime$4;
            private final ListValue timeLv$4;
            private final ListValue valueLv$4;
            private final boolean isAvg$2;

            public final ListValue apply(int i) {
                this.timeLv$4.add(this.stime$4 + (long)(this.delta$4 * i));
                if (this.isAvg$2 && this.cnt$2[i] > 1) {
                    this.values$2[i] = this.values$2[i] / (double)this.cnt$2[i];
                }
                return this.valueLv$4.add(new DoubleValue(this.values$2[i]));
            }
            {
                this.delta$4 = delta$4;
                this.values$2 = values$2;
                this.cnt$2 = cnt$2;
                this.stime$4 = stime$4;
                this.timeLv$4 = timeLv$4;
                this.valueLv$4 = valueLv$4;
                this.isAvg$2 = isAvg$2;
            }
        });
        dout.writeByte(3);
        dout.writePack(mpack);
    }

    @ServiceHandler(value="COUNTER_PAST_DATE_ALL")
    public void getPastDateAll(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String counter = param.getText("counter");
        String date = param.getText("date");
        String objType2 = param.getText("objType");
        if (StringUtil.isEmpty(objType2)) {
            System.out.println("please check.. COUNTER_LOAD_DATE_ALL objType is null");
            return;
        }
        MapPack agentGrp = AgentManager$.MODULE$.getDailyObjects(date, objType2);
        long stime = DateUtil.yyyymmdd(date);
        ListValue objHashLv = agentGrp.getList("objHash");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len(objHashLv) - 1).foreach$mVc$sp((Function1)new Serializable(this, dout, counter, date, stime, objHashLv){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$2;
            private final String counter$4;
            private final String date$4;
            public final long stime$5;
            private final ListValue objHashLv$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int objHash = this.objHashLv$4.getInt(i);
                MapPack mpack = new MapPack();
                mpack.put("objHash", objHash);
                ListValue timeLv = mpack.newList("time");
                ListValue valueLv = mpack.newList("value");
                Value[] v = DailyCounterRD$.MODULE$.getValues(this.date$4, new CounterKey(objHash, this.counter$4, 3));
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len((Object)v) - 1).foreach((Function1)new Serializable(this, timeLv, valueLv, v){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getPastDateAll$1 $outer;
                    private final ListValue timeLv$5;
                    private final ListValue valueLv$5;
                    private final Value[] v$4;

                    public final ListValue apply(int j) {
                        long time = this.$outer.stime$5 + 300000L * (long)j;
                        this.timeLv$5.add(time);
                        return this.valueLv$5.add(this.v$4[j]);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.timeLv$5 = timeLv$5;
                        this.valueLv$5 = valueLv$5;
                        this.v$4 = v$4;
                    }
                });
                this.dout$2.writeByte(3);
                this.dout$2.writePack(mpack);
                this.dout$2.flush();
            }
            {
                this.dout$2 = dout$2;
                this.counter$4 = counter$4;
                this.date$4 = date$4;
                this.stime$5 = stime$5;
                this.objHashLv$4 = objHashLv$4;
            }
        });
    }

    @ServiceHandler(value="COUNTER_PAST_LONGDATE_ALL")
    public void getPastLongDateAll(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String counter = param.getText("counter");
        String sDate = param.getText("sDate");
        String eDate = param.getText("eDate");
        String objType2 = param.getText("objType");
        ListValue objHashParamLv = param.getList("objHash");
        if (StringUtil.isEmpty(objType2) && (objHashParamLv == null || objHashParamLv.size() == 0)) {
            System.out.println("please check.. COUNTER_LOAD_TIME_ALL objType is null");
            return;
        }
        ObjectRef objHashLv = ObjectRef.create((Object)(objHashParamLv != null && objHashParamLv.size() > 0 ? objHashParamLv : AgentManager$.MODULE$.getPeriodicObjects(sDate, eDate, objType2).getList("objHash")));
        long stime = DateUtil.yyyymmdd(sDate);
        long etime = DateUtil.yyyymmdd(eDate) + 86400000L;
        LongRef date = LongRef.create((long)stime);
        while (date.elem <= etime - 86400000L) {
            String d = DateUtil.yyyymmdd(date.elem);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len((ListValue)objHashLv.elem) - 1).foreach$mVc$sp((Function1)new Serializable(this, dout, counter, objHashLv, date, d){
                public static final long serialVersionUID = 0L;
                private final DataOutputX dout$3;
                private final String counter$5;
                private final ObjectRef objHashLv$5;
                public final LongRef date$5;
                private final String d$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    int objHash = ((ListValue)this.objHashLv$5.elem).getInt(i);
                    try {
                        MapPack mpack = new MapPack();
                        mpack.put("objHash", objHash);
                        ListValue timeLv = mpack.newList("time");
                        ListValue valueLv = mpack.newList("value");
                        Value[] v = DailyCounterRD$.MODULE$.getValues(this.d$1, new CounterKey(objHash, this.counter$5, 3));
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len((Object)v) - 1).foreach((Function1)new Serializable(this, timeLv, valueLv, v){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$getPastLongDateAll$1 $outer;
                            private final ListValue timeLv$6;
                            private final ListValue valueLv$6;
                            private final Value[] v$5;

                            public final ListValue apply(int j) {
                                long time = this.$outer.date$5.elem + 300000L * (long)j;
                                this.timeLv$6.add(time);
                                return this.valueLv$6.add(this.v$5[j]);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.timeLv$6 = timeLv$6;
                                this.valueLv$6 = valueLv$6;
                                this.v$5 = v$5;
                            }
                        });
                        this.dout$3.writeByte(3);
                        this.dout$3.writePack(mpack);
                        this.dout$3.flush();
                    }
                    catch (Throwable throwable) {
                        ObjectPack op = AgentManager$.MODULE$.getAgent(objHash);
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)op.objName).append((Object)" invalid data : ").append((Object)throwable.getMessage()).toString());
                        throwable.printStackTrace();
                    }
                }
                {
                    this.dout$3 = dout$3;
                    this.counter$5 = counter$5;
                    this.objHashLv$5 = objHashLv$5;
                    this.date$5 = date$5;
                    this.d$1 = d$1;
                }
            });
            date.elem += 86400000L;
        }
    }

    @ServiceHandler(value="COUNTER_PAST_LONGDATE_TOT")
    public void getPastLongDateTot(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String counter = param.getText("counter");
        String sDate = param.getText("sDate");
        String eDate = param.getText("eDate");
        String mode = param.getText("mode");
        String objType2 = param.getText("objType");
        if (StringUtil.isEmpty(objType2)) {
            System.out.println("please check.. COUNTER_PAST_LONGDATE_TOT objType is null");
            return;
        }
        long stime = DateUtil.yyyymmdd(sDate);
        long etime = DateUtil.yyyymmdd(eDate) + 86400000L;
        byte period = 3;
        int delta = TimeTypeEnum.getTime(period);
        int timeLength = (int)((etime - stime) / (long)delta);
        double[] values = new double[timeLength];
        int[] cnt = new int[timeLength];
        MapPack agentGrp = AgentManager$.MODULE$.getPeriodicObjects(sDate, eDate, objType2);
        long date = stime;
        IntRef dayPointer = IntRef.create((int)0);
        int cntPerDay = 288;
        while (date <= etime - 86400000L) {
            String d = DateUtil.yyyymmdd(date);
            ListValue objHashLv = agentGrp.getList("objHash");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len(objHashLv) - 1).foreach$mVc$sp((Function1)new Serializable(this, counter, period, values, cnt, dayPointer, d, objHashLv){
                public static final long serialVersionUID = 0L;
                private final String counter$6;
                private final byte period$3;
                public final double[] values$3;
                public final int[] cnt$3;
                public final IntRef dayPointer$1;
                private final String d$2;
                private final ListValue objHashLv$6;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    int objHash = this.objHashLv$6.getInt(i);
                    try {
                        CounterKey ckey = new CounterKey(objHash, this.counter$6, this.period$3);
                        Value[] outvalue = DailyCounterRD$.MODULE$.getValues(this.d$2, ckey);
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len((Object)outvalue) - 1).foreach$mVc$sp((Function1)new Serializable(this, outvalue){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$getPastLongDateTot$1 $outer;
                            private final Value[] outvalue$2;

                            public final void apply(int j) {
                                this.apply$mcVI$sp(j);
                            }

                            public void apply$mcVI$sp(int j) {
                                Value value = this.outvalue$2[j];
                                double doubleValue = CastUtil.cdouble(value);
                                if (doubleValue > 0.0) {
                                    int n = this.$outer.dayPointer$1.elem + j;
                                    this.$outer.cnt$3[n] = this.$outer.cnt$3[n] + 1;
                                    int n2 = this.$outer.dayPointer$1.elem + j;
                                    this.$outer.values$3[n2] = this.$outer.values$3[n2] + doubleValue;
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.outvalue$2 = outvalue$2;
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        ObjectPack op = AgentManager$.MODULE$.getAgent(objHash);
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)op.objName).append((Object)" invalid data : ").append((Object)throwable.getMessage()).toString());
                        throwable.printStackTrace();
                    }
                }
                {
                    this.counter$6 = counter$6;
                    this.period$3 = period$3;
                    this.values$3 = values$3;
                    this.cnt$3 = cnt$3;
                    this.dayPointer$1 = dayPointer$1;
                    this.d$2 = d$2;
                    this.objHashLv$6 = objHashLv$6;
                }
            });
            date += 86400000L;
            dayPointer.elem += cntPerDay;
        }
        long t = DateUtil.yyyymmdd(sDate);
        MapPack mpack = new MapPack();
        ListValue timeLv = mpack.newList("time");
        ListValue valueLv = mpack.newList("value");
        boolean isAvg = "avg".equalsIgnoreCase(mode);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len(values) - 1).foreach((Function1)new Serializable(this, delta, values, cnt, t, timeLv, valueLv, isAvg){
            public static final long serialVersionUID = 0L;
            private final int delta$5;
            private final double[] values$3;
            private final int[] cnt$3;
            private final long t$1;
            private final ListValue timeLv$7;
            private final ListValue valueLv$7;
            private final boolean isAvg$3;

            public final ListValue apply(int i) {
                this.timeLv$7.add(this.t$1 + (long)(this.delta$5 * i));
                if (this.isAvg$3 && this.cnt$3[i] > 1) {
                    this.values$3[i] = this.values$3[i] / (double)this.cnt$3[i];
                }
                DoubleValue value = new DoubleValue(this.values$3[i]);
                return this.valueLv$7.add(value);
            }
            {
                this.delta$5 = delta$5;
                this.values$3 = values$3;
                this.cnt$3 = cnt$3;
                this.t$1 = t$1;
                this.timeLv$7 = timeLv$7;
                this.valueLv$7 = valueLv$7;
                this.isAvg$3 = isAvg$3;
            }
        });
        dout.writeByte(3);
        dout.writePack(mpack);
    }

    @ServiceHandler(value="COUNTER_PAST_DATE")
    public void getPastDate(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String date = param.getText("date");
        int objHash = param.getInt("objHash");
        String counter = param.getText("counter");
        long stime = DateUtil.yyyymmdd(date);
        MapPack mpack = new MapPack();
        ListValue timeLv = mpack.newList("time");
        ListValue valueLv = mpack.newList("value");
        CounterKey ckey = new CounterKey(objHash, counter, 3);
        Value[] outvalue = DailyCounterRD$.MODULE$.getValues(date, ckey);
        if (outvalue == null) {
            return;
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len((Object)outvalue) - 1).foreach((Function1)new Serializable(this, stime, timeLv, valueLv, outvalue){
            public static final long serialVersionUID = 0L;
            private final long stime$6;
            private final ListValue timeLv$8;
            private final ListValue valueLv$8;
            private final Value[] outvalue$3;

            public final ListValue apply(int i) {
                long time = this.stime$6 + 300000L * (long)i;
                Value value = this.outvalue$3[i];
                this.timeLv$8.add(time);
                return this.valueLv$8.add(value);
            }
            {
                this.stime$6 = stime$6;
                this.timeLv$8 = timeLv$8;
                this.valueLv$8 = valueLv$8;
                this.outvalue$3 = outvalue$3;
            }
        });
        dout.writeByte(3);
        dout.writePack(mpack);
        dout.flush();
    }

    @ServiceHandler(value="GET_COUNTER_EXIST_DAYS")
    public void getCounterExistDays(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String counter = param.getText("counter");
        String objType2 = param.getText("objType");
        int duration = param.getInt("duration");
        long etime = param.getLong("etime");
        long stime = etime - (long)duration * 86400000L;
        MapPack p = new MapPack();
        ListValue dateLv = p.newList("date");
        ListValue existLv = p.newList("exist");
        LongRef time = LongRef.create((long)stime);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), duration).foreach$mVc$sp((Function1)new Serializable(this, counter, objType2, dateLv, existLv, time){
            public static final long serialVersionUID = 0L;
            public final String counter$7;
            private final String objType$1;
            private final ListValue dateLv$1;
            private final ListValue existLv$1;
            private final LongRef time$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                BooleanRef result = BooleanRef.create((boolean)false);
                String yyyymmdd = DateUtil.yyyymmdd(this.time$1.elem);
                MapPack agentGrp = AgentManager$.MODULE$.getDailyObjects(yyyymmdd, this.objType$1);
                ListValue objHashLv = agentGrp.getList("objHash");
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len(objHashLv) - 1).foreach$mVc$sp((Function1)new Serializable(this, result, yyyymmdd, objHashLv){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getCounterExistDays$1 $outer;
                    private final BooleanRef result$1;
                    private final String yyyymmdd$1;
                    private final ListValue objHashLv$7;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        int objHash = this.objHashLv$7.getInt(j);
                        Value[] v = DailyCounterRD$.MODULE$.getValues(this.yyyymmdd$1, new CounterKey(objHash, this.$outer.counter$7, 3));
                        if (ArrayUtil.len((Object)v) > 0) {
                            this.result$1.elem = true;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.result$1 = result$1;
                        this.yyyymmdd$1 = yyyymmdd$1;
                        this.objHashLv$7 = objHashLv$7;
                    }
                });
                this.dateLv$1.add(yyyymmdd);
                this.existLv$1.add(result.elem);
                this.time$1.elem += 86400000L;
            }
            {
                this.counter$7 = counter$7;
                this.objType$1 = objType$1;
                this.dateLv$1 = dateLv$1;
                this.existLv$1 = existLv$1;
                this.time$1 = time$1;
            }
        });
        dout.writeByte(3);
        dout.writePack(p);
    }

    @ServiceHandler(value="COUNTER_PAST_DATE_GROUP")
    public void getPastDateGroup(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String counter = param.getText("counter");
        String date = param.getText("date");
        ListValue objHashLv = param.getList("objHash");
        long stime = DateUtil.yyyymmdd(date);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len(objHashLv) - 1).foreach$mVc$sp((Function1)new Serializable(this, dout, counter, date, objHashLv, stime){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$4;
            private final String counter$8;
            private final String date$6;
            private final ListValue objHashLv$8;
            public final long stime$7;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int objHash = this.objHashLv$8.getInt(i);
                CounterKey key = new CounterKey(objHash, this.counter$8, 3);
                MapPack mpack = new MapPack();
                mpack.put("objHash", objHash);
                ListValue timeLv = mpack.newList("time");
                ListValue valueLv = mpack.newList("value");
                Value[] v = DailyCounterRD$.MODULE$.getValues(this.date$6, key);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len((Object)v) - 1).foreach((Function1)new Serializable(this, timeLv, valueLv, v){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getPastDateGroup$1 $outer;
                    private final ListValue timeLv$9;
                    private final ListValue valueLv$9;
                    private final Value[] v$6;

                    public final ListValue apply(int j) {
                        long time = this.$outer.stime$7 + 300000L * (long)j;
                        Value value = this.v$6[j];
                        this.timeLv$9.add(time);
                        return this.valueLv$9.add(value);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.timeLv$9 = timeLv$9;
                        this.valueLv$9 = valueLv$9;
                        this.v$6 = v$6;
                    }
                });
                this.dout$4.writeByte(3);
                this.dout$4.writePack(mpack);
                this.dout$4.flush();
            }
            {
                this.dout$4 = dout$4;
                this.counter$8 = counter$8;
                this.date$6 = date$6;
                this.objHashLv$8 = objHashLv$8;
                this.stime$7 = stime$7;
            }
        });
    }

    @ServiceHandler(value="COUNTER_TODAY_GROUP")
    public void getTodayGroup(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String counter = param.getText("counter");
        ListValue objHashLv = param.getList("objHash");
        String date = DateUtil.yyyymmdd();
        long stime = DateUtil.yyyymmdd(date);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len(objHashLv) - 1).foreach((Function1)new Serializable(this, dout, counter, objHashLv, date, stime){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$5;
            private final String counter$9;
            private final ListValue objHashLv$9;
            private final String date$7;
            public final long stime$8;

            public final Object apply(int i) {
                Object object;
                int objHash = this.objHashLv$9.getInt(i);
                try {
                    CounterKey ck = new CounterKey(objHash, this.counter$9, 3);
                    Value[] v = DailyCounterRD$.MODULE$.getValues(this.date$7, ck);
                    MapPack mpack = new MapPack();
                    mpack.put("objHash", objHash);
                    ListValue timeLv = mpack.newList("time");
                    ListValue valueLv = mpack.newList("value");
                    int delta = TimeTypeEnum.getTime(ck.timetype);
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len((Object)v) - 1).foreach((Function1)new Serializable(this, v, timeLv, valueLv, delta){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$getTodayGroup$1 $outer;
                        private final Value[] v$7;
                        private final ListValue timeLv$10;
                        private final ListValue valueLv$10;
                        private final int delta$6;

                        public final ListValue apply(int j) {
                            long time = this.$outer.stime$8 + (long)(this.delta$6 * j);
                            Value value = this.v$7[j] == null ? new NullValue() : this.v$7[j];
                            this.timeLv$10.add(time);
                            return this.valueLv$10.add(value);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.v$7 = v$7;
                            this.timeLv$10 = timeLv$10;
                            this.valueLv$10 = valueLv$10;
                            this.delta$6 = delta$6;
                        }
                    });
                    this.dout$5.writeByte(3);
                    object = this.dout$5.writePack(mpack);
                }
                catch (Throwable throwable) {
                    ObjectPack op = AgentManager$.MODULE$.getAgent(objHash);
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)op.objName).append((Object)" invalid data : ").append((Object)throwable.getMessage()).toString());
                    throwable.printStackTrace();
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                this.dout$5 = dout$5;
                this.counter$9 = counter$9;
                this.objHashLv$9 = objHashLv$9;
                this.date$7 = date$7;
                this.stime$8 = stime$8;
            }
        });
    }

    @ServiceHandler(value="COUNTER_PAST_LONGDATE_GROUP")
    public void getPastLongDateGroup(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String counter = param.getText("counter");
        long stime = param.getLong("stime");
        long etime = param.getLong("etime");
        String lastDay = DateUtil.yyyymmdd(etime);
        ListValue objHashLv = param.getList("objHash");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ArrayUtil.len(objHashLv) - 1).foreach$mVc$sp((Function1)new Serializable(this, dout, counter, stime, lastDay, objHashLv){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$6;
            private final String counter$10;
            private final long stime$9;
            private final String lastDay$1;
            private final ListValue objHashLv$10;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int objHash = this.objHashLv$10.getInt(i);
                try {
                    long time = this.stime$9;
                    CounterKey key = new CounterKey(objHash, this.counter$10, 3);
                    MapPack mpack = new MapPack();
                    mpack.put("objHash", objHash);
                    ListValue timeLv = mpack.newList("time");
                    ListValue valueLv = mpack.newList("value");
                    String date = null;
                    while (!this.lastDay$1.equals(date)) {
                        date = DateUtil.yyyymmdd(time);
                        long oclock = DateUtil.yyyymmdd(date);
                        Value[] v = DailyCounterRD$.MODULE$.getValues(date, key);
                        if (v == null) {
                            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 287).foreach((Function1)new Serializable(this, timeLv, valueLv, oclock){
                                public static final long serialVersionUID = 0L;
                                private final ListValue timeLv$11;
                                private final ListValue valueLv$11;
                                private final long oclock$1;

                                public final ListValue apply(int j) {
                                    this.timeLv$11.add(this.oclock$1 + 300000L * (long)j);
                                    return this.valueLv$11.add(new NullValue());
                                }
                                {
                                    this.timeLv$11 = timeLv$11;
                                    this.valueLv$11 = valueLv$11;
                                    this.oclock$1 = oclock$1;
                                }
                            });
                        } else {
                            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), v.length - 1).foreach((Function1)new Serializable(this, timeLv, valueLv, oclock, v){
                                public static final long serialVersionUID = 0L;
                                private final ListValue timeLv$11;
                                private final ListValue valueLv$11;
                                private final long oclock$1;
                                private final Value[] v$8;

                                public final ListValue apply(int j) {
                                    this.timeLv$11.add(this.oclock$1 + 300000L * (long)j);
                                    return this.valueLv$11.add(this.v$8[j]);
                                }
                                {
                                    this.timeLv$11 = timeLv$11;
                                    this.valueLv$11 = valueLv$11;
                                    this.oclock$1 = oclock$1;
                                    this.v$8 = v$8;
                                }
                            });
                        }
                        time += 86400000L;
                    }
                    this.dout$6.writeByte(3);
                    this.dout$6.writePack(mpack);
                    this.dout$6.flush();
                }
                catch (Throwable throwable) {
                    ObjectPack op = AgentManager$.MODULE$.getAgent(objHash);
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)op.objName).append((Object)" invalid data : ").append((Object)throwable.getMessage()).toString());
                    throwable.printStackTrace();
                }
            }
            {
                this.dout$6 = dout$6;
                this.counter$10 = counter$10;
                this.stime$9 = stime$9;
                this.lastDay$1 = lastDay$1;
                this.objHashLv$10 = objHashLv$10;
            }
        });
    }
}

