/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.netio.service.handle;

import scala.reflect.ScalaSignature;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.MapPack;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.ListValue;
import scouter.server.db.VisitorDB$;
import scouter.server.db.VisitorHourlyDB$;
import scouter.server.netio.service.anotation.ServiceHandler;
import scouter.util.DateUtil;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001\u001b\tqa+[:ji>\u00148+\u001a:wS\u000e,'BA\u0002\u0005\u0003\u0019A\u0017M\u001c3mK*\u0011QAB\u0001\bg\u0016\u0014h/[2f\u0015\t9\u0001\"A\u0003oKRLwN\u0003\u0002\n\u0015\u000511/\u001a:wKJT\u0011aC\u0001\bg\u000e|W\u000f^3s\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0003\u001b\u0001\u0011\u00051$A\bwSNLGo\u001c:SK\u0006dG/[7f)\u0011ard\n\u0017\u0011\u0005=i\u0012B\u0001\u0010\u0011\u0005\u0011)f.\u001b;\t\u000b\u0001J\u0002\u0019A\u0011\u0002\u0007\u0011Lg\u000e\u0005\u0002#K5\t1E\u0003\u0002%\u0015\u0005\u0011\u0011n\\\u0005\u0003M\r\u0012!\u0002R1uC&s\u0007/\u001e;Y\u0011\u0015A\u0013\u00041\u0001*\u0003\u0011!w.\u001e;\u0011\u0005\tR\u0013BA\u0016$\u0005-!\u0015\r^1PkR\u0004X\u000f\u001e-\t\u000b5J\u0002\u0019\u0001\u0018\u0002\u000b1|w-\u001b8\u0011\u0005=y\u0013B\u0001\u0019\u0011\u0005\u001d\u0011un\u001c7fC:DC!\u0007\u001a9sA\u00111GN\u0007\u0002i)\u0011Q\u0007B\u0001\nC:|G/\u0019;j_:L!a\u000e\u001b\u0003\u001dM+'O^5dK\"\u000bg\u000e\u001a7fe\u0006)a/\u00197vK\u0006\n!(\u0001\tW\u0013NKEk\u0014*`%\u0016\u000bE\nV%N\u000b\")A\b\u0001C\u0001{\u0005!b/[:ji>\u0014(+Z1mi&lW\rV8uC2$B\u0001\b @\u0001\")\u0001e\u000fa\u0001C!)\u0001f\u000fa\u0001S!)Qf\u000fa\u0001]!\"1H\r\u001dCC\u0005\u0019\u0015A\u0006,J'&#vJU0S\u000b\u0006cE+S'F?R{E+\u0011'\t\u000b\u0015\u0003A\u0011\u0001$\u0002)YL7/\u001b;peJ+\u0017\r\u001c;j[\u0016<%o\\;q)\u0011ar\tS%\t\u000b\u0001\"\u0005\u0019A\u0011\t\u000b!\"\u0005\u0019A\u0015\t\u000b5\"\u0005\u0019\u0001\u0018)\t\u0011\u0013\u0004hS\u0011\u0002\u0019\u00061b+S*J)>\u0013vLU#B\u0019RKU*R0H%>+\u0006\u000bC\u0003O\u0001\u0011\u0005q*A\bwSNLGo\u001c:M_\u0006$G-\u0019;f)\u0011a\u0002+\u0015*\t\u000b\u0001j\u0005\u0019A\u0011\t\u000b!j\u0005\u0019A\u0015\t\u000b5j\u0005\u0019\u0001\u0018)\t5\u0013\u0004\bV\u0011\u0002+\u0006\u0001b+S*J)>\u0013v\fT(B\t\u0012\u000bE+\u0012\u0005\u0006/\u0002!\t\u0001W\u0001\u0015m&\u001c\u0018\u000e^8s\u0019>\fG\rZ1uKR{G/\u00197\u0015\tqI&l\u0017\u0005\u0006AY\u0003\r!\t\u0005\u0006QY\u0003\r!\u000b\u0005\u0006[Y\u0003\rA\f\u0015\u0005-JBT,I\u0001_\u0003Y1\u0016jU%U\u001fJ{FjT!E\t\u0006#Vi\u0018+P)\u0006c\u0005\"\u00021\u0001\t\u0003\t\u0017\u0001\u0006<jg&$xN\u001d'pC\u0012$\u0017\r^3He>,\b\u000f\u0006\u0003\u001dE\u000e$\u0007\"\u0002\u0011`\u0001\u0004\t\u0003\"\u0002\u0015`\u0001\u0004I\u0003\"B\u0017`\u0001\u0004q\u0003\u0006B03q\u0019\f\u0013aZ\u0001\u0017-&\u001b\u0016\nV(S?2{\u0015\t\u0012#B)\u0016{vIU(V!\")\u0011\u000e\u0001C\u0001U\u0006!b/[:ji>\u0014Hj\\1eQ>,(o\u0012:pkB$B\u0001H6m[\")\u0001\u0005\u001ba\u0001C!)\u0001\u0006\u001ba\u0001S!)Q\u0006\u001ba\u0001]!\"\u0001N\r\u001dpC\u0005\u0001\u0018A\u0006,J'&#vJU0M\u001f\u0006#\u0005jT+S?\u001e\u0013v*\u0016)")
public class VisitorService {
    @ServiceHandler(value="VISITOR_REALTIME")
    public void visitorRealtime(DataInputX din, DataOutputX dout, boolean login) {
        MapPack m = din.readMapPack();
        int objHash = m.getInt("objHash");
        long value = VisitorDB$.MODULE$.getVisitorObject(objHash);
        dout.writeByte(3);
        dout.writeValue(new DecimalValue(value));
    }

    @ServiceHandler(value="VISITOR_REALTIME_TOTAL")
    public void visitorRealtimeTotal(DataInputX din, DataOutputX dout, boolean login) {
        MapPack m = din.readMapPack();
        String objType2 = m.getText("objType");
        long value = VisitorDB$.MODULE$.getVisitorObjType(objType2);
        dout.writeByte(3);
        dout.writeValue(new DecimalValue(value));
    }

    @ServiceHandler(value="VISITOR_REALTIME_GROUP")
    public void visitorRealtimeGroup(DataInputX din, DataOutputX dout, boolean login) {
        MapPack m = din.readMapPack();
        ListValue objHashLv = m.getList("objHash");
        long value = VisitorDB$.MODULE$.getMergedVisitorObject(objHashLv);
        dout.writeByte(3);
        dout.writeValue(new DecimalValue(value));
    }

    @ServiceHandler(value="VISITOR_LOADDATE")
    public void visitorLoaddate(DataInputX din, DataOutputX dout, boolean login) {
        MapPack m = din.readMapPack();
        int objHash = m.getInt("objHash");
        String date = m.getText("date");
        long value = VisitorDB$.MODULE$.getVisitorObject(date, objHash);
        dout.writeByte(3);
        dout.writeValue(new DecimalValue(value));
    }

    @ServiceHandler(value="VISITOR_LOADDATE_TOTAL")
    public void visitorLoaddateTotal(DataInputX din, DataOutputX dout, boolean login) {
        MapPack m = din.readMapPack();
        String objType2 = m.getText("objType");
        String date = m.getText("date");
        long value = VisitorDB$.MODULE$.getVisitorObjType(date, objType2);
        dout.writeByte(3);
        dout.writeValue(new DecimalValue(value));
    }

    @ServiceHandler(value="VISITOR_LOADDATE_GROUP")
    public void visitorLoaddateGroup(DataInputX din, DataOutputX dout, boolean login) {
        MapPack m = din.readMapPack();
        ListValue objHashLv = m.getList("objHash");
        String startDate = m.getText("startDate");
        String endDate = m.getText("endDate");
        long etime = DateUtil.yyyymmdd(endDate);
        MapPack resultPack = new MapPack();
        for (long time = DateUtil.yyyymmdd(startDate); time <= etime; time += 86400000L) {
            String date = DateUtil.yyyymmdd(time);
            long value = VisitorDB$.MODULE$.getMergedVisitorObject(date, objHashLv);
            resultPack.put("date", date);
            resultPack.put("value", value);
            dout.writeByte(3);
            dout.writePack(resultPack);
        }
    }

    @ServiceHandler(value="VISITOR_LOADHOUR_GROUP")
    public void visitorLoadhourGroup(DataInputX din, DataOutputX dout, boolean login) {
        long time;
        MapPack m = din.readMapPack();
        ListValue objHashLv = m.getList("objHash");
        long stime = m.getLong("stime");
        long etime = m.getLong("etime");
        MapPack resultPack = new MapPack();
        ListValue timeLv = resultPack.newList("time");
        ListValue valueLv = resultPack.newList("value");
        String date = DateUtil.yyyymmdd(time);
        for (time = stime; time <= etime; time += 3600000L) {
            String dt = DateUtil.yyyymmdd(time);
            String string = date;
            String string2 = dt;
            if (string == null ? string2 != null : !string.equals(string2)) {
                date = dt;
                dout.writeByte(3);
                dout.writePack(resultPack);
                timeLv = resultPack.newList("time");
                valueLv = resultPack.newList("value");
            }
            long value = VisitorHourlyDB$.MODULE$.getMergedVisitorObject(date, time, objHashLv);
            timeLv.add(time);
            valueLv.add(value);
        }
        dout.writeByte(3);
        dout.writePack(resultPack);
    }
}

