/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.netio.service.handle;

import java.util.Vector;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.SpanContainerPack;
import scouter.lang.pack.SpanPack;
import scouter.lang.pack.SpanTypes;
import scouter.lang.pack.XLogPack;
import scouter.lang.pack.XLogProfilePack;
import scouter.lang.step.Step;
import scouter.lang.step.StepSingle;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.ListValue;
import scouter.server.Configure;
import scouter.server.core.app.SpanStepBuilder$;
import scouter.server.core.cache.CacheOut;
import scouter.server.core.cache.XLogCache$;
import scouter.server.db.TextRD$;
import scouter.server.db.XLogProfileRD$;
import scouter.server.db.XLogRD$;
import scouter.server.db.ZipkinSpanRD$;
import scouter.server.netio.service.anotation.ServiceHandler;
import scouter.server.util.EnumerScala$;
import scouter.util.DateUtil;
import scouter.util.IPUtil;
import scouter.util.IntSet;
import scouter.util.StrMatch;
import scouter.util.StringUtil;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u0001\u0003\u00015\u00111\u0002\u0017'pON+'O^5dK*\u00111\u0001B\u0001\u0007Q\u0006tG\r\\3\u000b\u0005\u00151\u0011aB:feZL7-\u001a\u0006\u0003\u000f!\tQA\\3uS>T!!\u0003\u0006\u0002\rM,'O^3s\u0015\u0005Y\u0011aB:d_V$XM]\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAQA\u0007\u0001\u0005\u0002m\t!bZ3u!J|g-\u001b7f)\u0011ard\n\u0017\u0011\u0005=i\u0012B\u0001\u0010\u0011\u0005\u0011)f.\u001b;\t\u000b\u0001J\u0002\u0019A\u0011\u0002\u0007\u0011Lg\u000e\u0005\u0002#K5\t1E\u0003\u0002%\u0015\u0005\u0011\u0011n\\\u0005\u0003M\r\u0012!\u0002R1uC&s\u0007/\u001e;Y\u0011\u0015A\u0013\u00041\u0001*\u0003\u0011!w.\u001e;\u0011\u0005\tR\u0013BA\u0016$\u0005-!\u0015\r^1PkR\u0004X\u000f\u001e-\t\u000b5J\u0002\u0019\u0001\u0018\u0002\u000b1|w-\u001b8\u0011\u0005=y\u0013B\u0001\u0019\u0011\u0005\u001d\u0011un\u001c7fC:DC!\u0007\u001a9sA\u00111GN\u0007\u0002i)\u0011Q\u0007B\u0001\nC:|G/\u0019;j_:L!a\u000e\u001b\u0003\u001dM+'O^5dK\"\u000bg\u000e\u001a7fe\u0006)a/\u00197vK\u0006\n!(A\u0007U%\u0006s\u0005l\u0018)S\u001f\u001aKE*\u0012\u0005\u0006y\u0001!\t!P\u0001\u000fO\u0016$h)\u001e7m!J|g-\u001b7f)\u0011abh\u0010!\t\u000b\u0001Z\u0004\u0019A\u0011\t\u000b!Z\u0004\u0019A\u0015\t\u000b5Z\u0004\u0019\u0001\u0018)\tm\u0012\u0004HQ\u0011\u0002\u0007\u0006\u0011BKU!O1~\u0003&k\u0014$J\u0019\u0016{f)\u0016'M\u0011\u0015)\u0005\u0001\"\u0003G\u0003a\u0001(o\\2fgN<U\r^*qC:\u001c\u0018i\u001d)s_\u001aLG.\u001a\u000b\u00069\u001dC\u0015K\u0016\u0005\u0006Q\u0011\u0003\r!\u000b\u0005\u0006\u0013\u0012\u0003\rAS\u0001\u0005I\u0006$X\r\u0005\u0002L\u001d:\u0011q\u0002T\u0005\u0003\u001bB\ta\u0001\u0015:fI\u00164\u0017BA(Q\u0005\u0019\u0019FO]5oO*\u0011Q\n\u0005\u0005\u0006%\u0012\u0003\raU\u0001\u0005ObLG\r\u0005\u0002\u0010)&\u0011Q\u000b\u0005\u0002\u0005\u0019>tw\rC\u0003X\t\u0002\u00071+\u0001\u0003uq&$\u0007\"B-\u0001\t\u0013Q\u0016A\u00069s_\u000e,7o]$fiN\u0003\u0018M\\:BgN#X\r]:\u0015\u000bqYF,\u00180\t\u000b!B\u0006\u0019A\u0015\t\u000b%C\u0006\u0019\u0001&\t\u000bIC\u0006\u0019A*\t\u000b]C\u0006\u0019A*\t\u000b\u0001\u0004A\u0011B1\u0002#\u001d,Go\u0015;faN4%o\\7Ta\u0006t7\u000f\u0006\u0003cwrl\b\u0003B\bdKVL!\u0001\u001a\t\u0003\rQ+\b\u000f\\33!\r17.\\\u0007\u0002O*\u0011\u0001.[\u0001\b[V$\u0018M\u00197f\u0015\tQ\u0007#\u0001\u0006d_2dWm\u0019;j_:L!\u0001\\4\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000f\u0005\u0002og6\tqN\u0003\u0002qc\u0006!1\u000f^3q\u0015\t\u0011(\"\u0001\u0003mC:<\u0017B\u0001;p\u0005)\u0019F/\u001a9TS:<G.\u001a\t\u0003mfl\u0011a\u001e\u0006\u0003qF\fA\u0001]1dW&\u0011!p\u001e\u0002\t'B\fg\u000eU1dW\")\u0011j\u0018a\u0001\u0015\")!k\u0018a\u0001'\")qk\u0018a\u0001'\"1q\u0010\u0001C\u0005\u0003\u0003\t1bZ3u'B\fgn]'baR1\u00111AA\u0005\u0003\u0017\u0001RaSA\u0003'VL1!a\u0002Q\u0005\ri\u0015\r\u001d\u0005\u0006\u0013z\u0004\rA\u0013\u0005\u0006%z\u0004\ra\u0015\u0005\b\u0003\u001f\u0001A\u0011BA\t\u0003E\u0001(o\\2fgN<U\r\u001e)s_\u001aLG.\u001a\u000b\n9\u0005M\u0011QCA\f\u00033Aa\u0001KA\u0007\u0001\u0004I\u0003BB%\u0002\u000e\u0001\u0007!\n\u0003\u0004X\u0003\u001b\u0001\ra\u0015\u0005\t\u00037\ti\u00011\u0001\u0002\u001e\u0005\u0019Q.\u0019=\u0011\u0007=\ty\"C\u0002\u0002\"A\u00111!\u00138u\u0011\u001d\t)\u0003\u0001C\u0005\u0003O\tQ\u0003\u001d:pG\u0016\u001c8oR3u\rVdG\u000e\u0015:pM&dW\rF\u0005\u001d\u0003S\tY#!\f\u00020!1\u0001&a\tA\u0002%Ba!SA\u0012\u0001\u0004Q\u0005BB,\u0002$\u0001\u00071\u000b\u0003\u0005\u0002\u001c\u0005\r\u0002\u0019AA\u000f\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003k\tAcZ3u%\u0016\fG\u000e^5nKB+'OZ$s_V\u0004Hc\u0002\u000f\u00028\u0005e\u00121\b\u0005\u0007A\u0005E\u0002\u0019A\u0011\t\r!\n\t\u00041\u0001*\u0011\u0019i\u0013\u0011\u0007a\u0001]!2\u0011\u0011\u0007\u001a9\u0003\u007f\t#!!\u0011\u0002+Q\u0013\u0016I\u0014-`%\u0016\u000bEj\u0018+J\u001b\u0016{vIU(V!\"9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0013aH4fiJ+\u0017\r\u001c;j[\u0016\u0004VM\u001d4He>,\b\u000fT1uKN$8i\\;oiR9A$!\u0013\u0002L\u00055\u0003B\u0002\u0011\u0002D\u0001\u0007\u0011\u0005\u0003\u0004)\u0003\u0007\u0002\r!\u000b\u0005\u0007[\u0005\r\u0003\u0019\u0001\u0018)\r\u0005\r#\u0007OA)C\t\t\u0019&\u0001\u000fU%\u0006s\u0005l\u0018*F\u00032{F+S'F?\u001e\u0013v*\u0016)`\u0019\u0006#Vi\u0015+\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z\u0005\u0019r-\u001a;ISN$xN]=QKJ4wI]8vaR9A$a\u0017\u0002^\u0005}\u0003B\u0002\u0011\u0002V\u0001\u0007\u0011\u0005\u0003\u0004)\u0003+\u0002\r!\u000b\u0005\u0007[\u0005U\u0003\u0019\u0001\u0018)\r\u0005U#\u0007OA2C\t\t)'A\u000bU%\u0006s\u0005l\u0018'P\u0003\u0012{F+S'F?\u001e\u0013v*\u0016)\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l\u0005)r-\u001a;ISN$xN]=QKJ4wI]8vaZ\u0013Dc\u0002\u000f\u0002n\u0005=\u0014\u0011\u000f\u0005\u0007A\u0005\u001d\u0004\u0019A\u0011\t\r!\n9\u00071\u0001*\u0011\u0019i\u0013q\ra\u0001]!2\u0011q\r\u001a9\u0003k\n#!a\u001e\u00021Q\u0013\u0016I\u0014-`\u0019>\u000bEi\u0018+J\u001b\u0016{vIU(V!~3&\u0007C\u0004\u0002|\u0001!\t!! \u0002?]\u0014\u0018\u000e^3ISN$xN]=QKJ4wI]8vaZ\u0013T*\u001a;b!\u0006\u001c7\u000eF\u0005\u001d\u0003\u007f\n\t)!\"\u0002\n\"1\u0001&!\u001fA\u0002%Bq!a!\u0002z\u0001\u0007a&A\u0004iCNluN]3\t\u000f\u0005\u001d\u0015\u0011\u0010a\u0001'\u0006AA.Y:u)&lW\rC\u0004\u0002\f\u0006e\u0004\u0019A*\u0002\u00111\f7\u000f\u001e+yS\u0012Dq!a$\u0001\t\u0003\t\t*\u0001\u0006sK\u0006$')_$y\u0013\u0012$r\u0001HAJ\u0003+\u000b9\n\u0003\u0004!\u0003\u001b\u0003\r!\t\u0005\u0007Q\u00055\u0005\u0019A\u0015\t\r5\ni\t1\u0001/Q\u0019\tiI\r\u001d\u0002\u001c\u0006\u0012\u0011QT\u0001\u001212{ui\u0018*F\u0003\u0012{&)W0H1&#\u0005bBAQ\u0001\u0011\u0005\u00111U\u0001\u000be\u0016\fGMQ=Uq&#Gc\u0002\u000f\u0002&\u0006\u001d\u0016\u0011\u0016\u0005\u0007A\u0005}\u0005\u0019A\u0011\t\r!\ny\n1\u0001*\u0011\u0019i\u0013q\u0014a\u0001]!2\u0011q\u0014\u001a9\u0003[\u000b#!a,\u0002#acujR0S\u000b\u0006#uLQ-`)bKE\tC\u0004\u00024\u0002!I!!.\u0002%\u001d,G\u000f\u0017'pO\u001e\f'\r\\3QCJ,g\u000e\u001e\u000b\u0006'\u0006]\u00161\u0018\u0005\b\u0003s\u000b\t\f1\u0001T\u0003\u0019\u0019\u0017\r\u001c7fe\"A\u0011QXAY\u0001\u0004\t\u0019!A\u0002nCBDq!!1\u0001\t\u0003\t\u0019-A\u0006m_\u0006$')\u001f+y\u0013\u0012\u001cHc\u0002\u000f\u0002F\u0006\u001d\u0017\u0011\u001a\u0005\u0007A\u0005}\u0006\u0019A\u0011\t\r!\ny\f1\u0001*\u0011\u0019i\u0013q\u0018a\u0001]!2\u0011q\u0018\u001a9\u0003\u001b\f#!a4\u0002%acujR0M\u001f\u0006#uLQ-`)bKEi\u0015\u0005\b\u0003'\u0004A\u0011AAk\u0003)aw.\u00193Cs\u001eC\u0018\n\u001a\u000b\b9\u0005]\u0017\u0011\\An\u0011\u0019\u0001\u0013\u0011\u001ba\u0001C!1\u0001&!5A\u0002%Ba!LAi\u0001\u0004q\u0003FBAiea\ny.\t\u0002\u0002b\u0006\t\u0002\fT(H?2{\u0015\tR0C3~;\u0005,\u0013#\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002h\u0006\u0019\u0012/^5dWN+\u0017M]2i12|w\rT5tiR9A$!;\u0002l\u00065\bB\u0002\u0011\u0002d\u0002\u0007\u0011\u0005\u0003\u0004)\u0003G\u0004\r!\u000b\u0005\u0007[\u0005\r\b\u0019\u0001\u0018)\r\u0005\r(\u0007OAyC\t\t\u00190A\u000bR+&\u001b5jU#B%\u000eCu\f\u0017'P\u000f~c\u0015j\u0015+\t\u000f\u0005]\b\u0001\"\u0001\u0002z\u0006q1/Z1sG\"DFn\\4MSN$Hc\u0002\u000f\u0002|\u0006u\u0018q \u0005\u0007A\u0005U\b\u0019A\u0011\t\r!\n)\u00101\u0001*\u0011\u0019i\u0013Q\u001fa\u0001]!2\u0011Q\u001f\u001a9\u0005\u0007\t#A!\u0002\u0002!M+\u0015IU\"I?bcujR0M\u0013N#\u0006")
public class XLogService {
    @ServiceHandler(value="TRANX_PROFILE")
    public void getProfile(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String date = param.getText("date");
        long txid = param.getLong("txid");
        long gxid = param.getLong("gxid");
        int xlogType = param.getInt("xlogType");
        int max = param.getInt("max");
        if (StringUtil.isEmpty(date)) {
            date = DateUtil.yyyymmdd();
        }
        try {
            if (gxid == 0L) {
                DataInputX din2 = new DataInputX(XLogRD$.MODULE$.getByTxid(date, txid));
                XLogPack xlog = (XLogPack)din2.readPack();
                gxid = xlog.gxid;
                xlogType = xlog.xType;
            }
            if (xlogType == 5) {
                this.processGetSpansAsProfile(dout, date, gxid, txid);
            } else {
                this.processGetProfile(dout, date, txid, max);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @ServiceHandler(value="TRANX_PROFILE_FULL")
    public void getFullProfile(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String date = param.getText("date");
        long txid = param.getLong("txid");
        long gxid = param.getLong("gxid");
        int xlogType = param.getInt("xlogType");
        int max = -1;
        if (StringUtil.isEmpty(date)) {
            date = DateUtil.yyyymmdd();
        }
        if (gxid == 0L) {
            DataInputX din2 = new DataInputX(XLogRD$.MODULE$.getByTxid(date, txid));
            XLogPack xlog = (XLogPack)din2.readPack();
            gxid = xlog.gxid;
            xlogType = xlog.xType;
        }
        if (xlogType == 5) {
            this.processGetSpansAsSteps(dout, date, gxid, txid);
        } else {
            this.processGetFullProfile(dout, date, txid, max);
        }
    }

    private void processGetSpansAsProfile(DataOutputX dout, String date, long gxid, long txid) {
        Tuple2<ListBuffer<StepSingle>, SpanPack> tuple2 = this.getStepsFromSpans(date, gxid, txid);
        if (tuple2 != null) {
            Tuple2 tuple22;
            ListBuffer stepList = (ListBuffer)tuple2._1();
            SpanPack mySpanPack = (SpanPack)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)stepList, (Object)mySpanPack);
            ListBuffer stepList2 = (ListBuffer)tuple23._1();
            SpanPack mySpanPack2 = (SpanPack)tuple23._2();
            XLogProfilePack profilePack = new XLogProfilePack();
            profilePack.txid = txid;
            profilePack.objHash = mySpanPack2.objHash;
            profilePack.profile = Step.toBytes((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)stepList2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Step apply(StepSingle x$2) {
                    return x$2;
                }
            }, ListBuffer$.MODULE$.canBuildFrom())).asJava());
            profilePack.service = mySpanPack2.name;
            profilePack.elapsed = mySpanPack2.elapsed;
            dout.writeByte(3);
            dout.writePack(profilePack);
            return;
        }
        throw new MatchError(tuple2);
    }

    private void processGetSpansAsSteps(DataOutputX dout, String date, long gxid, long txid) {
        Tuple2<ListBuffer<StepSingle>, SpanPack> tuple2 = this.getStepsFromSpans(date, gxid, txid);
        if (tuple2 != null) {
            Tuple2 tuple22;
            ListBuffer stepList = (ListBuffer)tuple2._1();
            SpanPack mySpanPck = (SpanPack)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)stepList, (Object)mySpanPck);
            ListBuffer stepList2 = (ListBuffer)tuple23._1();
            SpanPack mySpanPck2 = (SpanPack)tuple23._2();
            dout.writeByte(3);
            dout.writeBlob(Step.toBytes((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)stepList2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Step apply(StepSingle x$4) {
                    return x$4;
                }
            }, ListBuffer$.MODULE$.canBuildFrom())).asJava()));
            return;
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<ListBuffer<StepSingle>, SpanPack> getStepsFromSpans(String date, long gxid, long txid) {
        ListBuffer spanBuffer = new ListBuffer();
        List<byte[]> spanContainerPackList = ZipkinSpanRD$.MODULE$.getByGxid(date, gxid);
        spanContainerPackList.foreach((Function1)new Serializable(this, spanBuffer){
            public static final long serialVersionUID = 0L;
            private final ListBuffer spanBuffer$1;

            public final ListBuffer<SpanPack> apply(byte[] bytes) {
                DataInputX din = new DataInputX(bytes);
                SpanContainerPack container = (SpanContainerPack)din.readPack();
                return this.spanBuffer$1.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(SpanPack.toObjectList(container.spans)).asScala());
            }
            {
                this.spanBuffer$1 = spanBuffer$1;
            }
        });
        return SpanStepBuilder$.MODULE$.toSteps(gxid, txid, (ListBuffer<SpanPack>)spanBuffer);
    }

    private Map<Object, SpanPack> getSpansMap(String date, long gxid) {
        HashMap spanMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        List<byte[]> spanContainerPackList = ZipkinSpanRD$.MODULE$.getByGxid(date, gxid);
        spanContainerPackList.foreach((Function1)new Serializable(this, spanMap){
            public static final long serialVersionUID = 0L;
            private final HashMap spanMap$1;

            public final HashMap<Object, SpanPack> apply(byte[] bytes) {
                DataInputX din = new DataInputX(bytes);
                SpanContainerPack container = (SpanContainerPack)din.readPack();
                return (HashMap)this.spanMap$1.$plus$plus$eq((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(SpanPack.toObjectList(container.spans)).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, SpanPack> apply(SpanPack p) {
                        return new Tuple2((Object)BoxesRunTime.boxToLong((long)p.txid), (Object)p);
                    }
                }, Buffer$.MODULE$.canBuildFrom()));
            }
            {
                this.spanMap$1 = spanMap$1;
            }
        });
        return spanMap.toMap(Predef$.MODULE$.$conforms());
    }

    private void processGetProfile(DataOutputX dout, String date, long txid, int max) {
        byte[] profilePacket = XLogProfileRD$.MODULE$.getProfile(date, txid, max);
        if (profilePacket != null) {
            dout.writeByte(3);
            XLogProfilePack p = new XLogProfilePack();
            p.profile = profilePacket;
            dout.writePack(p);
        }
    }

    private void processGetFullProfile(DataOutputX dout, String date, long txid, int max) {
        XLogProfileRD$.MODULE$.getFullProfile(date, txid, max, (Function1<byte[], Object>)new Serializable(this, dout){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$1;

            public final DataOutputX apply(byte[] data) {
                this.dout$1.writeByte(3);
                return this.dout$1.writeBlob(data);
            }
            {
                this.dout$1 = dout$1;
            }
        });
    }

    @ServiceHandler(value="TRANX_REAL_TIME_GROUP")
    public void getRealtimePerfGroup(DataInputX din, DataOutputX dout, boolean login) {
        CacheOut<byte[]> d;
        MapPack param = din.readMapPack();
        int index = param.getInt("index");
        long loop = param.getLong("loop");
        int limit = param.getInt("limit");
        limit = Math.max(Configure.getInstance().xlog_realtime_lower_bound_ms, limit);
        ListValue objHashLv = param.getList("objHash");
        IntSet intSet = objHashLv == null || objHashLv.size() < 1 ? null : new IntSet(objHashLv.size(), 1.0f);
        EnumerScala$.MODULE$.foreach(objHashLv, new Serializable(this, intSet){
            public static final long serialVersionUID = 0L;
            private final IntSet intSet$1;

            public final boolean apply(DecimalValue obj) {
                return this.intSet$1.add(obj.intValue());
            }
            {
                this.intSet$1 = intSet$1;
            }
        });
        CacheOut<byte[]> cacheOut = d = intSet == null ? XLogCache$.MODULE$.get(loop, index, limit) : XLogCache$.MODULE$.get(intSet, loop, index, limit);
        if (d == null) {
            return;
        }
        MapPack outparam = new MapPack();
        outparam.put("loop", new DecimalValue(d.loop()));
        outparam.put("index", new DecimalValue(d.index()));
        dout.writeByte(3);
        dout.writePack(outparam);
        EnumerScala$.MODULE$.forward(d.data(), new Serializable(this, dout){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$2;

            public final DataOutputX apply(byte[] p) {
                this.dout$2.writeByte(3);
                return this.dout$2.write(p);
            }
            {
                this.dout$2 = dout$2;
            }
        });
    }

    @ServiceHandler(value="TRANX_REAL_TIME_GROUP_LATEST")
    public void getRealtimePerfGroupLatestCount(DataInputX din, DataOutputX dout, boolean login) {
        CacheOut<byte[]> d;
        MapPack param = din.readMapPack();
        int index = param.getInt("index");
        long loop = param.getLong("loop");
        int count = param.getInt("count");
        ListValue objHashLv = param.getList("objHash");
        IntSet objHashSet = objHashLv == null || objHashLv.size() < 1 ? null : new IntSet(objHashLv.size(), 1.0f);
        EnumerScala$.MODULE$.foreach(objHashLv, new Serializable(this, objHashSet){
            public static final long serialVersionUID = 0L;
            private final IntSet objHashSet$1;

            public final boolean apply(DecimalValue obj) {
                return this.objHashSet$1.add(obj.intValue());
            }
            {
                this.objHashSet$1 = objHashSet$1;
            }
        });
        CacheOut<byte[]> cacheOut = d = objHashSet == null ? XLogCache$.MODULE$.getWithinCount(loop, index, count) : XLogCache$.MODULE$.getWithinCount(objHashSet, loop, index, count);
        if (d == null) {
            return;
        }
        MapPack outparam = new MapPack();
        outparam.put("loop", new DecimalValue(d.loop()));
        outparam.put("index", new DecimalValue(d.index()));
        dout.writeByte(3);
        dout.writePack(outparam);
        EnumerScala$.MODULE$.forward(d.data(), new Serializable(this, dout){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$3;

            public final DataOutputX apply(byte[] p) {
                this.dout$3.writeByte(3);
                return this.dout$3.write(p);
            }
            {
                this.dout$3 = dout$3;
            }
        });
    }

    @ServiceHandler(value="TRANX_LOAD_TIME_GROUP")
    public void getHistoryPerfGroup(DataInputX din, DataOutputX dout, boolean login) {
        NonLocalReturnControl nonLocalReturnControl2;
        block5: {
            Object object = new Object();
            try {
                MapPack param = din.readMapPack();
                String date = param.getText("date");
                long stime = param.getLong("stime");
                long etime = param.getLong("etime");
                int limitTime = param.getInt("limit");
                int limit = Math.max(Configure.getInstance().xlog_pasttime_lower_bound_ms, limitTime);
                int max = param.getInt("max");
                boolean rev = param.getBoolean("reverse");
                ListValue objHashLv = param.getList("objHash");
                if (objHashLv == null || objHashLv.size() < 1) {
                    return;
                }
                IntSet objHashSet = new IntSet();
                EnumerScala$.MODULE$.foreach(objHashLv, new Serializable(this, objHashSet){
                    public static final long serialVersionUID = 0L;
                    private final IntSet objHashSet$2;

                    public final boolean apply(DecimalValue obj) {
                        return this.objHashSet$2.add(obj.intValue());
                    }
                    {
                        this.objHashSet$2 = objHashSet$2;
                    }
                });
                IntRef cnt = IntRef.create((int)0);
                Serializable handler = new Serializable(this, dout, limit, max, objHashSet, cnt, object){
                    public static final long serialVersionUID = 0L;
                    private final DataOutputX dout$4;
                    private final int limit$1;
                    private final int max$1;
                    private final IntSet objHashSet$2;
                    private final IntRef cnt$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(long time, byte[] data) {
                        XLogPack x = (XLogPack)new DataInputX(data).readPack();
                        if (this.objHashSet$2.contains(x.objHash) && x.elapsed > this.limit$1) {
                            this.dout$4.writeByte(3);
                            this.dout$4.write(data);
                            this.dout$4.flush();
                            ++this.cnt$1.elem;
                        }
                        if (this.max$1 > 0 && this.cnt$1.elem >= this.max$1) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                    }
                    {
                        this.dout$4 = dout$4;
                        this.limit$1 = limit$1;
                        this.max$1 = max$1;
                        this.objHashSet$2 = objHashSet$2;
                        this.cnt$1 = cnt$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                };
                if (rev) {
                    XLogRD$.MODULE$.readFromEndTime(date, stime, etime, (Function2<Object, byte[], Object>)handler);
                } else {
                    XLogRD$.MODULE$.readByTime(date, stime, etime, (Function2<Object, byte[], Object>)handler);
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block5;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    @ServiceHandler(value="TRANX_LOAD_TIME_GROUP_V2")
    public void getHistoryPerfGroupV2(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String date = param.getText("date");
        long stime = param.getLong("stime");
        long etime = param.getLong("etime");
        long lastBucketTime = param.getLong("lastBucketTime");
        long txid = param.getLong("txid");
        int limitCount = param.getInt("pageCount");
        ListValue objHashLv = param.getList("objHash");
        if (objHashLv == null || objHashLv.size() < 1) {
            this.writeHistoryPerfGroupV2MetaPack(dout, false, 0L, 0L);
            return;
        }
        if (txid == 0L && lastBucketTime != 0L || txid != 0L && lastBucketTime == 0L) {
            this.writeHistoryPerfGroupV2MetaPack(dout, false, 0L, 0L);
            return;
        }
        if (limitCount == 0) {
            this.writeHistoryPerfGroupV2MetaPack(dout, false, 0L, 0L);
            return;
        }
        IntSet objHashSet = new IntSet();
        EnumerScala$.MODULE$.foreach(objHashLv, new Serializable(this, objHashSet){
            public static final long serialVersionUID = 0L;
            private final IntSet objHashSet$3;

            public final boolean apply(DecimalValue obj) {
                return this.objHashSet$3.add(obj.intValue());
            }
            {
                this.objHashSet$3 = objHashSet$3;
            }
        });
        LongRef lastTime = LongRef.create((long)0L);
        ObjectRef lastData = ObjectRef.create(null);
        IntRef count = IntRef.create((int)0);
        BooleanRef start = BooleanRef.create((boolean)true);
        if (txid != 0L) {
            start.elem = false;
        }
        BooleanRef hasMore = BooleanRef.create((boolean)false);
        Serializable handler = new Serializable(this, dout, txid, limitCount, objHashSet, lastTime, lastData, count, start, hasMore){
            public static final long serialVersionUID = 0L;
            private final DataOutputX dout$5;
            private final long txid$1;
            private final int limitCount$1;
            private final IntSet objHashSet$3;
            private final LongRef lastTime$1;
            private final ObjectRef lastData$1;
            private final IntRef count$1;
            private final BooleanRef start$1;
            private final BooleanRef hasMore$1;

            public final int apply(long time, byte[] data) {
                XLogPack xLog = (XLogPack)new DataInputX(data).readPack();
                if (this.start$1.elem) {
                    if (this.objHashSet$3.contains(xLog.objHash)) {
                        if (this.count$1.elem < this.limitCount$1) {
                            this.dout$5.writeByte(3);
                            this.dout$5.write(data);
                            this.dout$5.flush();
                            this.lastTime$1.elem = time;
                            this.lastData$1.elem = xLog;
                        } else {
                            this.hasMore$1.elem = true;
                        }
                        ++this.count$1.elem;
                    }
                } else if (xLog.txid == this.txid$1) {
                    this.start$1.elem = true;
                }
                return this.count$1.elem;
            }
            {
                this.dout$5 = dout$5;
                this.txid$1 = txid$1;
                this.limitCount$1 = limitCount$1;
                this.objHashSet$3 = objHashSet$3;
                this.lastTime$1 = lastTime$1;
                this.lastData$1 = lastData$1;
                this.count$1 = count$1;
                this.start$1 = start$1;
                this.hasMore$1 = hasMore$1;
            }
        };
        XLogRD$.MODULE$.readByTimeLimitCount(date, stime, etime, lastBucketTime, limitCount, (Function2<Object, byte[], Object>)handler);
        if (lastTime.elem > 0L) {
            this.writeHistoryPerfGroupV2MetaPack(dout, hasMore.elem, lastTime.elem, ((XLogPack)lastData.elem).txid);
        } else {
            this.writeHistoryPerfGroupV2MetaPack(dout, false, 0L, 0L);
        }
    }

    public void writeHistoryPerfGroupV2MetaPack(DataOutputX dout, boolean hasMore, long lastTime, long lastTxid) {
        MapPack metaPack = new MapPack();
        metaPack.put("hasMore", new BooleanValue(hasMore));
        metaPack.put("lastXLogTime", new DecimalValue(lastTime));
        metaPack.put("lastTxid", new DecimalValue(lastTxid));
        dout.writeByte(3);
        dout.writePack(metaPack);
    }

    @ServiceHandler(value="XLOG_READ_BY_GXID")
    public void readByGxId(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String date = param.getText("date");
        long gxid = param.getLong("gxid");
        try {
            Vector<byte[]> list = XLogRD$.MODULE$.getByGxid(date, gxid);
            EnumerScala$.MODULE$.forward(list, new Serializable(this, dout){
                public static final long serialVersionUID = 0L;
                private final DataOutputX dout$6;

                public final void apply(byte[] xlog) {
                    this.dout$6.writeByte(3);
                    this.dout$6.write(xlog);
                    this.dout$6.flush();
                }
                {
                    this.dout$6 = dout$6;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ServiceHandler(value="XLOG_READ_BY_TXID")
    public void readByTxId(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String date = param.getText("date");
        long txid = param.getLong("txid");
        long gxid = param.getLong("gxid");
        try {
            Map<Object, SpanPack> spanMap;
            byte[] xbytes = XLogRD$.MODULE$.getByTxid(date, txid);
            boolean xbytesChecked = false;
            if (xbytes == null && gxid != 0L && (spanMap = this.getSpansMap(date, gxid)).nonEmpty()) {
                long superTxId = this.getXLoggableParent(txid, spanMap);
                xbytes = XLogRD$.MODULE$.getByTxid(date, superTxId);
                xbytesChecked = true;
            }
            if (xbytes != null) {
                if (!xbytesChecked) {
                    XLogPack xlog = (XLogPack)new DataInputX(xbytes).readPack();
                    if ((xlog.xType == 5 || xlog.b3Mode) && xlog.caller != 0L && xlog.caller != xlog.gxid) {
                        Map<Object, SpanPack> spanMap2 = this.getSpansMap(date, xlog.gxid);
                        xlog.caller = this.getXLoggableParent(xlog.caller, spanMap2);
                        xbytes = new DataOutputX().writePack(xlog).toByteArray();
                    }
                }
                dout.writeByte(3);
                dout.write(xbytes);
                dout.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private long getXLoggableParent(long caller, Map<Object, SpanPack> map) {
        long l;
        block2: {
            while (map.contains((Object)BoxesRunTime.boxToLong((long)caller))) {
                SpanPack pack = (SpanPack)map.apply((Object)BoxesRunTime.boxToLong((long)caller));
                if (SpanTypes.isParentXLoggable(pack.spanType)) {
                    l = caller;
                    break block2;
                }
                caller = pack.caller;
            }
            l = 0L;
        }
        return l;
    }

    @ServiceHandler(value="XLOG_LOAD_BY_TXIDS")
    public void loadByTxIds(DataInputX din, DataOutputX dout, boolean login) {
        Object object = new Object();
        try {
            MapPack param = din.readMapPack();
            String date = param.getText("date");
            ListValue txidLv = param.getList("txid");
            IntRef loadCount = IntRef.create((int)0);
            try {
                EnumerScala$.MODULE$.foreach(txidLv, new Serializable(this, dout, date, loadCount, object){
                    public static final long serialVersionUID = 0L;
                    private final DataOutputX dout$7;
                    private final String date$1;
                    private final IntRef loadCount$1;
                    private final Object nonLocalReturnKey2$1;

                    public final void apply(DecimalValue txidValue) {
                        ++this.loadCount$1.elem;
                        if (this.loadCount$1.elem >= Configure.getInstance().req_search_xlog_max_count) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey2$1, BoxedUnit.UNIT);
                        }
                        byte[] xbytes = XLogRD$.MODULE$.getByTxid(this.date$1, txidValue.longValue());
                        if (xbytes != null) {
                            this.dout$7.writeByte(3);
                            this.dout$7.write(xbytes);
                            this.dout$7.flush();
                        }
                    }
                    {
                        this.dout$7 = dout$7;
                        this.date$1 = date$1;
                        this.loadCount$1 = loadCount$1;
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                });
            }
            catch (Exception exception) {}
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                nonLocalReturnControl.value$mcV$sp();
            }
            throw nonLocalReturnControl;
        }
    }

    @ServiceHandler(value="XLOG_LOAD_BY_GXID")
    public void loadByGxId(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        long stime = param.getLong("stime");
        long etime = param.getLong("etime");
        long gxid = param.getLong("gxid");
        String date = DateUtil.yyyymmdd(stime);
        String date2 = DateUtil.yyyymmdd(etime);
        try {
            Vector<byte[]> list = XLogRD$.MODULE$.getByGxid(date, gxid);
            EnumerScala$.MODULE$.forward(list, new Serializable(this, dout){
                public static final long serialVersionUID = 0L;
                private final DataOutputX dout$8;

                public final void apply(byte[] xlog) {
                    this.dout$8.writeByte(3);
                    this.dout$8.write(xlog);
                    this.dout$8.flush();
                }
                {
                    this.dout$8 = dout$8;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!date.equals(date2)) {
            try {
                Vector<byte[]> list = XLogRD$.MODULE$.getByGxid(date2, gxid);
                EnumerScala$.MODULE$.forward(list, new Serializable(this, dout){
                    public static final long serialVersionUID = 0L;
                    private final DataOutputX dout$8;

                    public final void apply(byte[] xlog) {
                        this.dout$8.writeByte(3);
                        this.dout$8.write(xlog);
                        this.dout$8.flush();
                    }
                    {
                        this.dout$8 = dout$8;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @ServiceHandler(value="QUICKSEARCH_XLOG_LIST")
    public void quickSearchXlogList(DataInputX din, DataOutputX dout, boolean login) {
        MapPack param = din.readMapPack();
        String date = param.getText("date");
        long txid = param.getLong("txid");
        long gxid = param.getLong("gxid");
        if (txid != 0L) {
            try {
                byte[] xbytes = XLogRD$.MODULE$.getByTxid(date, txid);
                if (xbytes != null) {
                    dout.writeByte(3);
                    dout.write(xbytes);
                    dout.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (gxid != 0L) {
            try {
                Vector<byte[]> list = XLogRD$.MODULE$.getByGxid(date, gxid);
                if (list == null) {
                    return;
                }
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), list.size() - 1).foreach$mVc$sp((Function1)new Serializable(this, dout, list){
                    public static final long serialVersionUID = 0L;
                    private final DataOutputX dout$9;
                    private final Vector list$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        byte[] xlog = (byte[])this.list$1.get(i);
                        this.dout$9.writeByte(3);
                        this.dout$9.write(xlog);
                        this.dout$9.flush();
                    }
                    {
                        this.dout$9 = dout$9;
                        this.list$1 = list$1;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @ServiceHandler(value="SEARCH_XLOG_LIST")
    public void searchXlogList(DataInputX din, DataOutputX dout, boolean login) {
        NonLocalReturnControl nonLocalReturnControl2;
        block5: {
            Object object = new Object();
            try {
                MapPack param = din.readMapPack();
                long stime = param.getLong("stime");
                long etime = param.getLong("etime");
                String service = param.getText("service");
                int objHash = param.getInt("objHash");
                String ip = param.getText("ip");
                String login2 = param.getText("login");
                String desc = param.getText("desc");
                String text1 = param.getText("text1");
                String text2 = param.getText("text2");
                String text3 = param.getText("text3");
                String text4 = param.getText("text4");
                String text5 = param.getText("text5");
                StrMatch serviceMatch = service == null ? null : new StrMatch(service);
                StrMatch ipMatch = ip == null ? null : new StrMatch(ip);
                StrMatch loginMatch = login2 == null ? null : new StrMatch(login2);
                StrMatch descMatch = desc == null ? null : new StrMatch(desc);
                StrMatch text1Match = text1 == null ? null : new StrMatch(text1);
                StrMatch text2Match = text2 == null ? null : new StrMatch(text2);
                StrMatch text3Match = text3 == null ? null : new StrMatch(text3);
                StrMatch text4Match = text4 == null ? null : new StrMatch(text4);
                StrMatch text5Match = text5 == null ? null : new StrMatch(text5);
                String date = DateUtil.yyyymmdd(stime);
                String date2 = DateUtil.yyyymmdd(etime);
                long mtime = 0L;
                boolean twoDays = false;
                IntRef loadCount = IntRef.create((int)0);
                if (!date.equals(date2)) {
                    mtime = DateUtil.yyyymmdd(date2);
                    twoDays = true;
                }
                Serializable handler = new Serializable(this, dout, objHash, serviceMatch, ipMatch, loginMatch, descMatch, text1Match, text2Match, text3Match, text4Match, text5Match, loadCount, object){
                    public static final long serialVersionUID = 0L;
                    private final DataOutputX dout$10;
                    private final int objHash$1;
                    private final StrMatch serviceMatch$1;
                    private final StrMatch ipMatch$1;
                    private final StrMatch loginMatch$1;
                    private final StrMatch descMatch$1;
                    private final StrMatch text1Match$1;
                    private final StrMatch text2Match$1;
                    private final StrMatch text3Match$1;
                    private final StrMatch text4Match$1;
                    private final StrMatch text5Match$1;
                    private final IntRef loadCount$2;
                    private final Object nonLocalReturnKey3$1;

                    public final void apply(long time, byte[] data) {
                        String text5Name;
                        String text4Name;
                        String text3Name;
                        String text2Name;
                        String text1Name;
                        String descName;
                        String loginName;
                        String serviceName;
                        if (this.loadCount$2.elem >= Configure.getInstance().req_search_xlog_max_count) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey3$1, BoxedUnit.UNIT);
                        }
                        XLogPack x = (XLogPack)new DataInputX(data).readPack();
                        boolean ok = true;
                        if (this.ipMatch$1 != null) {
                            if (x.ipaddr == null) {
                                ok = false;
                            }
                            if (!this.ipMatch$1.include(IPUtil.toString(x.ipaddr))) {
                                ok = false;
                            }
                        }
                        if (this.objHash$1 != 0 && x.objHash != this.objHash$1) {
                            ok = false;
                        }
                        if (this.serviceMatch$1 != null && !this.serviceMatch$1.include(serviceName = TextRD$.MODULE$.getString(DateUtil.yyyymmdd(time), "service", x.service))) {
                            ok = false;
                        }
                        if (this.loginMatch$1 != null && !this.loginMatch$1.include(loginName = TextRD$.MODULE$.getString(DateUtil.yyyymmdd(time), "login", x.login))) {
                            ok = false;
                        }
                        if (this.descMatch$1 != null && !this.descMatch$1.include(descName = TextRD$.MODULE$.getString(DateUtil.yyyymmdd(time), "desc", x.desc))) {
                            ok = false;
                        }
                        if (this.text1Match$1 != null && !this.text1Match$1.include(text1Name = x.text1)) {
                            ok = false;
                        }
                        if (this.text2Match$1 != null && !this.text2Match$1.include(text2Name = x.text2)) {
                            ok = false;
                        }
                        if (this.text3Match$1 != null && !this.text3Match$1.include(text3Name = x.text3)) {
                            ok = false;
                        }
                        if (this.text4Match$1 != null && !this.text4Match$1.include(text4Name = x.text4)) {
                            ok = false;
                        }
                        if (this.text5Match$1 != null && !this.text5Match$1.include(text5Name = x.text5)) {
                            ok = false;
                        }
                        if (ok) {
                            this.dout$10.writeByte(3);
                            this.dout$10.write(data);
                            this.dout$10.flush();
                            ++this.loadCount$2.elem;
                        }
                    }
                    {
                        this.dout$10 = dout$10;
                        this.objHash$1 = objHash$1;
                        this.serviceMatch$1 = serviceMatch$1;
                        this.ipMatch$1 = ipMatch$1;
                        this.loginMatch$1 = loginMatch$1;
                        this.descMatch$1 = descMatch$1;
                        this.text1Match$1 = text1Match$1;
                        this.text2Match$1 = text2Match$1;
                        this.text3Match$1 = text3Match$1;
                        this.text4Match$1 = text4Match$1;
                        this.text5Match$1 = text5Match$1;
                        this.loadCount$2 = loadCount$2;
                        this.nonLocalReturnKey3$1 = nonLocalReturnKey3$1;
                    }
                };
                if (twoDays) {
                    XLogRD$.MODULE$.readByTime(date, stime, mtime - 1L, (Function2<Object, byte[], Object>)handler);
                    XLogRD$.MODULE$.readByTime(date2, mtime, etime, (Function2<Object, byte[], Object>)handler);
                } else {
                    XLogRD$.MODULE$.readByTime(date, stime, etime, (Function2<Object, byte[], Object>)handler);
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block5;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }
}

