/*
 * Decompiled with CFR 0.152.
 */
package scouter.server.tagcnt.next;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import scala.Function0;
import scala.Function1;
import scala.Function6;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scouter.lang.value.Value;
import scouter.server.Logger$;
import scouter.server.tagcnt.core.CountEnv$;
import scouter.server.tagcnt.core.DBKey;
import scouter.server.tagcnt.core.NextTagCountData;
import scouter.server.tagcnt.next.IndexFile;
import scouter.server.tagcnt.next.WorkDB;
import scouter.server.util.EnumerScala$;
import scouter.server.util.ThreadScala$;
import scouter.util.BackJob;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.IClose;
import scouter.util.LinkedMap;
import scouter.util.RequestQueue;
import scouter.util.ThreadUtil;

public final class NextTagCountDB$
implements IClose {
    public static final NextTagCountDB$ MODULE$;
    private final LinkedMap<DBKey, WorkDB> database;
    private ArrayList<DBKey> idleConns;
    private final Runnable r;
    private final RequestQueue<HashMap<NextTagCountData, float[]>> queue;
    private final long lastflush;

    static {
        new NextTagCountDB$();
    }

    public LinkedMap<DBKey, WorkDB> database() {
        return this.database;
    }

    public ArrayList<DBKey> idleConns() {
        return this.idleConns;
    }

    public void idleConns_$eq(ArrayList<DBKey> x$1) {
        this.idleConns = x$1;
    }

    public Runnable r() {
        return this.r;
    }

    public RequestQueue<HashMap<NextTagCountData, float[]>> queue() {
        return this.queue;
    }

    public int getQueueSize() {
        return this.queue().size();
    }

    public boolean isQueueOk() {
        return this.queue().size() < CountEnv$.MODULE$.MAX_QUE_SIZE();
    }

    public void add(HashMap<NextTagCountData, float[]> data) {
        while (!this.isQueueOk()) {
            ThreadUtil.qWait();
            Logger$.MODULE$.println("S185", 10, "NextTagCountDB queue is exceeded");
        }
        this.queue().put(data);
    }

    public long lastflush() {
        return this.lastflush;
    }

    public void process(HashMap<NextTagCountData, float[]> p) {
        EnumerScala$.MODULE$.foreach(p.keySet().iterator(), new Serializable(p){
            public static final long serialVersionUID = 0L;
            private final HashMap p$1;

            public final void apply(NextTagCountData key) {
                float[] value = (float[])this.p$1.get(key);
                WorkDB db = NextTagCountDB$.MODULE$.scouter$server$tagcnt$next$NextTagCountDB$$openWrite(key.time(), key.objType());
                try {
                    if (db != null) {
                        db.table().add(key.tagKey(), key.value(), (int)(key.hourUnit() % 24L), value);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            {
                this.p$1 = p$1;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized WorkDB scouter$server$tagcnt$next$NextTagCountDB$$openWrite(long time, String objType2) {
        long dateunit = DateUtil.getDateUnit(time);
        WorkDB db = this.database().get(new DBKey(dateunit, objType2));
        if (db != null) {
            db.lastActive_$eq(System.currentTimeMillis());
            return db;
        }
        db = this.open(time, objType2);
        if (db == null) {
            return null;
        }
        db.lastActive_$eq(System.currentTimeMillis());
        LinkedMap<DBKey, WorkDB> linkedMap = this.database();
        synchronized (linkedMap) {
            while (true) {
                if (this.database().size() < CountEnv$.MODULE$.MAX_ACTIVEDB()) {
                    this.database().put(new DBKey(dateunit, objType2), db);
                    return db;
                }
                this.liftedTree1$1();
            }
        }
    }

    public void scouter$server$tagcnt$next$NextTagCountDB$$closeIdleConnections() {
        if (this.idleConns().isEmpty()) {
            return;
        }
        ArrayList<DBKey> idles = this.idleConns();
        this.idleConns_$eq(new ArrayList<DBKey>());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), idles.size() - 1).foreach((Function1)new Serializable(idles){
            public static final long serialVersionUID = 0L;
            private final ArrayList idles$1;

            public final IClose apply(int i) {
                WorkDB o = NextTagCountDB$.MODULE$.database().remove((DBKey)this.idles$1.get(i));
                return FileUtil.close(o);
            }
            {
                this.idles$1 = idles$1;
            }
        });
    }

    public WorkDB open(String date, String objType2) {
        long time = DateUtil.getTime(date, "yyyyMMdd");
        return this.open(time, objType2);
    }

    public synchronized WorkDB open(long time, String objType2) {
        if (time == 0L) {
            new Throwable().printStackTrace();
        }
        WorkDB db = null;
        try {
            String date = DateUtil.yyyymmdd(time);
            String path = CountEnv$.MODULE$.getDBPath(date, objType2);
            File f = new File(path);
            Object object = !f.exists() ? BoxesRunTime.boxToBoolean((boolean)f.mkdirs()) : BoxedUnit.UNIT;
            db = new WorkDB(path);
            db.open();
            db.objType_$eq(objType2);
            db.logDate_$eq(date);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return db;
    }

    public float[] getTagValueCount(String date, String objType2, long tagKey, Value value) {
        WorkDB db = this.open(date, objType2);
        try {
            return db.table().get(tagKey, value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            FileUtil.close(db);
        }
        return null;
    }

    public void read(String date, String objType2, Function6<Object, Value, Object, long[], IndexFile, Object, Object> handler) {
        WorkDB db = this.open(date, objType2);
        try {
            try {
                db.table().read(handler);
            }
            catch (Throwable throwable) {}
        }
        finally {
            FileUtil.close(db);
        }
    }

    @Override
    public void close() {
        LinkedMap<DBKey, WorkDB> linkedMap = this.database();
        synchronized (linkedMap) {
            while (this.database().size() > 0) {
                this.database().removeFirst().close();
            }
            return;
        }
    }

    private final void liftedTree1$1() {
        try {
            this.database().removeFirst().close();
        }
        catch (Throwable throwable) {}
    }

    private NextTagCountDB$() {
        MODULE$ = this;
        this.database = new LinkedMap();
        this.idleConns = new ArrayList();
        this.r = new Runnable(){

            public void run() {
                long now = System.currentTimeMillis();
                EnumerScala$.MODULE$.foreach(NextTagCountDB$.MODULE$.database().keys(), new Serializable(this, now){
                    public static final long serialVersionUID = 0L;
                    private final long now$1;

                    public final Object apply(DBKey key) {
                        WorkDB db = NextTagCountDB$.MODULE$.database().get(key);
                        return db == null ? BoxedUnit.UNIT : (this.now$1 - db.lastActive() > 300000L ? BoxesRunTime.boxToBoolean((boolean)NextTagCountDB$.MODULE$.idleConns().add(key)) : BoxedUnit.UNIT);
                    }
                    {
                        this.now$1 = now$1;
                    }
                });
            }
        };
        BackJob.getInstance().add("BG-NextTagCountDB", 10000L, this.r());
        this.queue = new RequestQueue(CountEnv$.MODULE$.MAX_QUE_SIZE() + 1);
        this.lastflush = System.currentTimeMillis();
        ThreadScala$.MODULE$.start("scouter.server.tagcnt.next.NextTagCountDB", (Function0<BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (CountEnv$.MODULE$.running()) {
                    NextTagCountDB$.MODULE$.scouter$server$tagcnt$next$NextTagCountDB$$closeIdleConnections();
                    HashMap<NextTagCountData, float[]> p = NextTagCountDB$.MODULE$.queue().get();
                    NextTagCountDB$.MODULE$.process(p);
                }
                FileUtil.close(NextTagCountDB$.MODULE$);
            }
        });
    }
}

