/*
 * Decompiled with CFR 0.152.
 */
package scouter.util.logo;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;
import java.util.regex.Pattern;
import scouter.Version;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FileUtil;
import scouter.util.ParamText;
import scouter.util.StringUtil;

public class Logo {
    public static void print() {
        Logo.print(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void print(boolean server) {
        if (server) {
            Logo.printDLogo();
        }
        InputStream in = null;
        try {
            String scouter_logo = System.getProperty("scouter.logo", "scouter.logo");
            in = Logo.class.getResourceAsStream(scouter_logo);
            if (in == null) {
                FileUtil.close(in);
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            while (line != null) {
                if (server) {
                    System.out.println(new ParamText(line).getText(Version.getServerFullVersion()));
                } else {
                    System.out.println(new ParamText(line).getText(Version.getAgentFullVersion()));
                }
                line = reader.readLine();
            }
            FileUtil.close(in);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            FileUtil.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void print(PrintWriter w, boolean server) {
        InputStream in = null;
        try {
            String scouter_logo = System.getProperty("scouter.logo", "scouter.logo");
            in = Logo.class.getResourceAsStream(scouter_logo);
            if (in == null) {
                FileUtil.close(in);
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            while (line != null) {
                if (server) {
                    w.println(new ParamText(line).getText(Version.getServerFullVersion()));
                } else {
                    w.println(new ParamText(line).getText(Version.getAgentFullVersion()));
                }
                line = reader.readLine();
            }
            w.flush();
            FileUtil.close(in);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            FileUtil.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printDLogo() {
        String keyFlag = "!@#$logo!@#$";
        int flagLength = "!@#$logo!@#$".length();
        String delim = ",";
        class LogoData {
            String key;
            String contents;

            LogoData() {
            }

            public String toString() {
                return "LogoData{key='" + this.key + '\'' + ", contents='" + this.contents + '\'' + '}';
            }
        }
        ArrayList<LogoData> arr = new ArrayList<LogoData>();
        InputStream in = null;
        try {
            String line;
            in = Logo.class.getResourceAsStream("/scouter/util/logo/scouter-day.logo");
            if (in == null) {
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            boolean init2 = false;
            StringBuilder sb = null;
            LogoData logoData = null;
            while ((line = reader.readLine()) != null) {
                int flagPos = line.indexOf("!@#$logo!@#$");
                if (flagPos >= 0) {
                    String key = line.substring(flagPos + flagLength);
                    if (init2) {
                        logoData.contents = sb.toString();
                    }
                    logoData = new LogoData();
                    logoData.key = key;
                    arr.add(logoData);
                    sb = new StringBuilder(200);
                    init2 = true;
                    continue;
                }
                if (!init2) continue;
                sb.append(line).append(System.getProperty("line.separator"));
            }
            if (logoData != null) {
                logoData.contents = sb.toString();
            }
            ArrayList arrTodayLogo = new ArrayList();
            for (int i = arr.size(); i > 0; --i) {
                String[] dateFlags = StringUtil.tokenizer(((LogoData)arr.get((int)(i - 1))).key, ",");
                int len = dateFlags.length;
                if (len != 3) continue;
                String yymmdd = DateUtil.yyyymmdd();
                String yyyy = yymmdd.substring(0, 4);
                String mm = yymmdd.substring(4, 6);
                String dd = yymmdd.substring(6);
                if (!Logo.match(yyyy, dateFlags[0]) || !Logo.match(mm, dateFlags[1]) || !Logo.match(dd, dateFlags[2])) continue;
                arrTodayLogo.add(arr.get(i - 1));
            }
            int todayLogoCount = arrTodayLogo.size();
            if (todayLogoCount > 0) {
                int pos;
                if (todayLogoCount == 1) {
                    pos = 0;
                } else {
                    Random r = new Random(System.currentTimeMillis());
                    pos = r.nextInt(todayLogoCount);
                }
                String todayLogo = ((LogoData)arrTodayLogo.get((int)pos)).contents;
                System.out.println(todayLogo);
                System.out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileUtil.close(in);
        }
    }

    private static boolean match(String dateString, String input) {
        if (!Pattern.matches("^[\\*0-9*-]*$", input)) {
            return false;
        }
        if ("*".equals(input)) {
            return true;
        }
        if (dateString.equals(input)) {
            return true;
        }
        if (input.indexOf(45) >= 0) {
            String[] digit = StringUtil.tokenizer(input, "-");
            if (digit.length != 2) {
                return false;
            }
            int idata = CastUtil.cint(dateString);
            if (idata >= CastUtil.cint(digit[0]) && idata <= CastUtil.cint(digit[1])) {
                return true;
            }
        } else if (CastUtil.cint(dateString) == CastUtil.cint(input)) {
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        Logo.printDLogo();
    }
}

