/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.consumer;

import com.google.common.base.Strings;
import java.util.Iterator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouter.lang.conf.ValueType;
import scouter.lang.conf.ValueTypeDesc;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.util.CastUtil;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.model.configure.ConfObject;
import scouterx.webapp.model.configure.ConfigureData;
import scouterx.webapp.request.SetConfigRequest;

public class ConfigureConsumer {
    private static final Logger log = LoggerFactory.getLogger(ConfigureConsumer.class);
    final int STATUS_SUCCESS_CODE = 200;
    final int STATUS_FAIL_CODE = 404;

    public ConfigureData saveServerConfig(SetConfigRequest configRequest, Server server) {
        ConfigureData configureData = new ConfigureData();
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server.getId());){
            MapPack param = new MapPack();
            param.put("setConfig", configRequest.getValues().replaceAll("\\\\", "\\\\\\\\"));
            MapPack out = (MapPack)tcpProxy.getSingle("SET_CONFIGURE_SERVER", (Pack)param);
            if (Objects.nonNull(out)) {
                String config = out.getText("result");
                if ("true".equalsIgnoreCase(config)) {
                    this.loadConfigList(configureData, tcpProxy, "LIST_CONFIGURE_SERVER", null);
                    configureData.setStatus(200);
                } else {
                    configureData.setStatus(404);
                }
            }
        }
        return configureData;
    }

    public ConfigureData saveObjectConfig(SetConfigRequest configRequest, int objHash, Server server) {
        ConfigureData configureData = new ConfigureData();
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server.getId());){
            MapPack param = new MapPack();
            param.put("setConfig", configRequest.getValues().replaceAll("\\\\", "\\\\\\\\"));
            param.put("objHash", (long)objHash);
            MapPack out = (MapPack)tcpProxy.getSingle("SET_CONFIGURE_WAS", (Pack)param);
            if (Objects.nonNull(out)) {
                String config = out.getText("result");
                if ("true".equalsIgnoreCase(config)) {
                    MapPack param2 = new MapPack();
                    param2.put("objHash", (long)objHash);
                    this.loadConfigList(configureData, tcpProxy, "LIST_CONFIGURE_WAS", param2);
                    configureData.setStatus(200);
                } else {
                    configureData.setStatus(404);
                }
            }
        }
        return configureData;
    }

    public ConfigureData retrieveObjectConfig(int objHash, Server server) {
        ConfigureData configureData = new ConfigureData();
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server.getId());){
            MapPack param = new MapPack();
            param.put("objHash", (long)objHash);
            this.loadConfig(configureData, tcpProxy, "GET_CONFIGURE_WAS", param, false);
            this.loadConfigList(configureData, tcpProxy, "LIST_CONFIGURE_WAS", param);
            this.loadConfigDesc(configureData, tcpProxy, param);
            this.loadConfigValueType(configureData, tcpProxy, param);
            this.loadConfigValueTypeDesc(configureData, tcpProxy, param);
            configureData.setStatus(200);
        }
        return configureData;
    }

    public ConfigureData retrieveServerConfig(Server server, boolean isServer) {
        ConfigureData configureData = new ConfigureData();
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server.getId());){
            this.loadConfig(configureData, tcpProxy, "GET_CONFIGURE_SERVER", null, isServer);
            this.loadConfigList(configureData, tcpProxy, "LIST_CONFIGURE_SERVER", null);
            this.loadConfigDesc(configureData, tcpProxy, new MapPack());
            this.loadConfigValueType(configureData, tcpProxy, new MapPack());
            this.loadConfigValueTypeDesc(configureData, tcpProxy, new MapPack());
            configureData.setStatus(200);
        }
        return configureData;
    }

    private void loadConfig(ConfigureData configureData, TcpProxy tcpProxy, String requestCmd, MapPack param, boolean isServer) {
        MapPack pack = (MapPack)tcpProxy.getSingle(requestCmd, (Pack)param);
        if (Objects.nonNull(pack)) {
            if (isServer) {
                configureData.setContents(pack.getText("serverConfig"));
            } else {
                configureData.setContents(pack.getText("agentConfig"));
            }
        }
    }

    private void loadConfigList(ConfigureData configureData, TcpProxy tcpProxy, String requestCmd, MapPack param) {
        MapPack pack = (MapPack)tcpProxy.getSingle(requestCmd, (Pack)param);
        if (pack != null) {
            ListValue keyList = pack.getList("key");
            ListValue valueList = pack.getList("value");
            ListValue defaultList = pack.getList("default");
            for (int i = 0; i < keyList.size(); ++i) {
                ConfObject obj = new ConfObject();
                String key = CastUtil.cString((Object)keyList.get(i));
                String value = CastUtil.cString((Object)valueList.get(i));
                String def = CastUtil.cString((Object)defaultList.get(i));
                obj.key = Strings.nullToEmpty((String)key);
                obj.value = Strings.nullToEmpty((String)value);
                obj.def = Strings.nullToEmpty((String)def);
                configureData.getConfigStateList().add(obj);
            }
        }
    }

    private void loadConfigDesc(ConfigureData configureData, TcpProxy tcpProxy, MapPack param) {
        MapPack pack = (MapPack)tcpProxy.getSingle("CONFIGURE_DESC", (Pack)param);
        if (Objects.nonNull(pack)) {
            Iterator keys = pack.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                configureData.getDescMap().put(key, pack.getText(key));
                if (!key.contains("$")) continue;
                configureData.getDescMap().put(this.removeVariableString(key), pack.getText(key));
            }
        }
    }

    private void loadConfigValueType(ConfigureData configureData, TcpProxy tcpProxy, MapPack param) {
        MapPack pack = (MapPack)tcpProxy.getSingle("CONFIGURE_VALUE_TYPE", (Pack)param);
        if (Objects.nonNull(pack)) {
            Iterator keys = pack.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                configureData.getValueTypeMap().put(key, ValueType.of((int)pack.getInt(key)));
                if (!key.contains("$")) continue;
                configureData.getValueTypeMap().put(this.removeVariableString(key), ValueType.of((int)pack.getInt(key)));
            }
        }
    }

    private void loadConfigValueTypeDesc(ConfigureData configureData, TcpProxy tcpProxy, MapPack param) {
        MapPack pack = (MapPack)tcpProxy.getSingle("CONFIGURE_VALUE_TYPE_DESC", (Pack)param);
        if (Objects.nonNull(pack)) {
            Iterator keys = pack.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                configureData.getValueTypeDescMap().put(key, ValueTypeDesc.of((MapValue)((MapValue)pack.get(key))));
                if (!key.contains("$")) continue;
                configureData.getValueTypeDescMap().put(this.removeVariableString(key), ValueTypeDesc.of((MapValue)((MapValue)pack.get(key))));
            }
        }
    }

    public String removeVariableString(String text) {
        StringBuilder resultBuilder = new StringBuilder(text.length());
        char[] org = text.toCharArray();
        boolean sink = false;
        block3: for (int i = 0; i < org.length; ++i) {
            switch (org[i]) {
                case '$': {
                    sink = !sink;
                    continue block3;
                }
                default: {
                    if (sink) continue block3;
                    resultBuilder.append(org[i]);
                }
            }
        }
        return resultBuilder.toString();
    }
}

