/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.layer.service.ObjectService;
import scouterx.webapp.model.configure.ConfApplyScopeEnum;
import scouterx.webapp.model.configure.ConfObjectState;
import scouterx.webapp.request.SetConfigKvRequest;

public class ConfigureKVHandleConsumer {
    private final ObjectService agentService = new ObjectService();

    public boolean saveKVServerConfig(SetConfigKvRequest configRequest, Server server) {
        boolean isSuccess = false;
        try {
            String text = this.loadConfigureText(server.getId(), 0);
            Pattern pattern = Pattern.compile("(?m)^" + configRequest.getKey() + "\\s*=.*\\n?");
            Matcher matcher = pattern.matcher(text);
            String replacement = configRequest.getKey() + "=" + configRequest.getValue() + "\n";
            String replacedText = null;
            replacedText = matcher.find() ? matcher.replaceFirst(replacement) : text + "\n\n#auto-added\n" + replacement;
            if (this.saveConfigure(server.getId(), 0, replacedText)) {
                isSuccess = true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return isSuccess;
    }

    public Optional<List<ConfObjectState>> applyConfig(ConfApplyScopeEnum scope, SetConfigKvRequest configRequest, String objType, Server server) {
        List<ConfObjectState> resulList = null;
        switch (scope) {
            case TYPE_IN_SERVER: {
                resulList = this.applyConfigToTypeInServer(configRequest.getKey(), configRequest.getValue(), objType, server);
                break;
            }
        }
        return Optional.ofNullable(resulList);
    }

    private List<ConfObjectState> applyConfigToTypeInServer(String confKey, String confValue, String objType, Server server) {
        ArrayList<ConfObjectState> resultList = new ArrayList<ConfObjectState>();
        this.agentService.retrieveObjectList(server).stream().filter(object -> objType.equals(object.getObjType())).forEach(object -> {
            try {
                if (!object.isAlive()) {
                    resultList.add(new ConfObjectState(object.getObjHash(), false));
                } else {
                    String text = this.loadConfigureText(server.getId(), object.getObjHash());
                    Pattern pattern = Pattern.compile("(?m)^" + confKey + "\\s*=.*\\n?");
                    Matcher matcher = pattern.matcher(text);
                    String replacement = confKey + "=" + confValue + "\n";
                    String replacedText = null;
                    replacedText = matcher.find() ? matcher.replaceFirst(replacement) : text + "\n\n#auto-added\n" + replacement;
                    if (this.saveConfigure(server.getId(), object.getObjHash(), replacedText)) {
                        resultList.add(new ConfObjectState(object.getObjHash(), true));
                    } else {
                        resultList.add(new ConfObjectState(object.getObjHash(), false));
                    }
                }
            }
            catch (ConfigLoadException e) {
                resultList.add(new ConfObjectState(object.getObjHash(), false));
            }
        });
        return resultList;
    }

    private String loadConfigureText(int serverId, int objHash) throws ConfigLoadException {
        String content = null;
        MapPack resultMapPack = null;
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            MapPack param = new MapPack();
            if (objHash == 0) {
                resultMapPack = (MapPack)tcp.getSingle("GET_CONFIGURE_SERVER", (Pack)param);
            } else {
                param.put("objHash", (long)objHash);
                resultMapPack = (MapPack)tcp.getSingle("GET_CONFIGURE_WAS", (Pack)param);
            }
        }
        catch (Throwable throwable) {
            throw new ConfigLoadException();
        }
        if (resultMapPack != null) {
            content = objHash == 0 ? resultMapPack.getText("serverConfig") : resultMapPack.getText("agentConfig");
        }
        return content;
    }

    private boolean saveConfigure(int serverId, int objHash, String configText) {
        boolean success = false;
        TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
        try {
            MapPack param = new MapPack();
            param.put("setConfig", configText.replaceAll("\\\\", "\\\\\\\\"));
            MapPack out = null;
            if (objHash == 0) {
                out = (MapPack)tcp.getSingle("SET_CONFIGURE_SERVER", (Pack)param);
            } else {
                param.put("objHash", (long)objHash);
                out = (MapPack)tcp.getSingle("SET_CONFIGURE_WAS", (Pack)param);
            }
            if (out != null) {
                String config = out.getText("result");
                success = "true".equalsIgnoreCase(config);
            }
        }
        catch (Throwable throwable) {
            success = false;
        }
        return success;
    }

    public class ConfigLoadException
    extends Exception {
    }
}

