/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import java.util.List;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.lang3.StringUtils;
import scouter.util.Hexa32;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.layer.service.ActiveServiceService;
import scouterx.webapp.model.ActiveThread;
import scouterx.webapp.model.ThreadContents;
import scouterx.webapp.model.scouter.SActiveService;
import scouterx.webapp.model.scouter.SActiveServiceStepCount;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/activeService")
@Api(value="Active service")
@Singleton
@Produces(value={"application/json"})
public class ActiveServiceController {
    @Context
    HttpServletRequest servletRequest;
    private final ActiveServiceService activeServiceService = new ActiveServiceService();

    @GET
    @Path(value="/stepCount/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<SActiveServiceStepCount>> retrieveRealTimeActiveServiceByObjType(@PathParam(value="objType") @Valid @NotNull String objType, @QueryParam(value="serverId") int serverId) {
        List<SActiveServiceStepCount> activeServiceList = this.activeServiceService.retrieveRealTimeActiveServiceByObjType(objType, ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(activeServiceList);
    }

    @GET
    @Path(value="/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<SActiveService>> retrieveRealTimeActiveServiceListByObjType(@PathParam(value="objType") @Valid @NotNull String objType, @QueryParam(value="serverId") int serverId) {
        List<SActiveService> activeServiceList = this.activeServiceService.retrieveActiveServiceListByType(objType, ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(activeServiceList);
    }

    @GET
    @Path(value="/ofObject/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<SActiveService>> retrieveRealTimeActiveServiceListByObjHash(@PathParam(value="objHash") @Valid @NotNull int objHash, @QueryParam(value="serverId") int serverId) {
        List<SActiveService> activeServiceList = this.activeServiceService.retrieveActiveServiceListByObjHash(objHash, ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(activeServiceList);
    }

    @GET
    @Path(value="/control/thread/{threadId}/ofObject/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<ThreadContents> InterruptedRealTimeActiveServiceByObjHash(@PathParam(value="objHash") @Valid @NotNull int objHash, @PathParam(value="threadId") @Valid @NotNull long threadId, @QueryParam(value="action") @Valid @NotNull String action, @QueryParam(value="serverId") int serverId) {
        ThreadContents threadContents = this.activeServiceService.controlThread(objHash, threadId, action, ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(threadContents);
    }

    @GET
    @Path(value="/thread/{threadId}/ofObject/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<ActiveThread> retrieveActiveThread(@PathParam(value="objHash") @Valid @NotNull int objHash, @PathParam(value="threadId") @Valid @NotNull long threadId, @QueryParam(value="txidName") String txidName, @QueryParam(value="txid") long txid, @QueryParam(value="serverId") int serverId) {
        if (txid == 0L && StringUtils.isNotBlank((CharSequence)txidName)) {
            txid = Hexa32.toLong32((String)txidName);
        }
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        ActiveThread activeThread = this.activeServiceService.retrieveActiveThread(objHash, threadId, txid, server);
        return CommonResultView.success(activeThread);
    }
}

