/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import scouterx.webapp.framework.client.model.AgentModelThread;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.layer.service.ObjectService;
import scouterx.webapp.model.HeapHistogramData;
import scouterx.webapp.model.SocketObjectData;
import scouterx.webapp.model.ThreadObjectData;
import scouterx.webapp.model.VariableData;
import scouterx.webapp.model.scouter.SObject;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/object")
@Api(value="Object")
@Singleton
@Produces(value={"application/json"})
public class ObjectController {
    @Context
    HttpServletRequest servletRequest;
    private final ObjectService agentService = new ObjectService();

    @GET
    @ApiOperation(value="/", notes="get agent list that is monitored by scouter")
    @ApiImplicitParams(value={@ApiImplicitParam(name="serverId", value="server id", dataType="int", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK - Json Data"), @ApiResponse(code=500, message="Server error")})
    @Consumes(value={"application/json"})
    public CommonResultView<List<SObject>> retrieveObjectList(@QueryParam(value="serverId") int serverId) {
        List<SObject> agentList = this.agentService.retrieveObjectList(ServerManager.getInstance().getServer(serverId));
        return CommonResultView.success(agentList);
    }

    @GET
    @ApiOperation(value="/remove/inactive", notes="remove inactive object. target all connected servers")
    @ApiResponses(value={@ApiResponse(code=200, message="OK - Json Data"), @ApiResponse(code=500, message="Server error")})
    @Path(value="/remove/inactive")
    public CommonResultView removeInactiveByAll() {
        AgentModelThread.removeInactiveByAll();
        return CommonResultView.success();
    }

    @GET
    @ApiOperation(value="/remove/inactive/server", notes="remove inactive object. target by serverId ")
    @ApiImplicitParams(value={@ApiImplicitParam(name="serverId", value="server id", dataType="int", paramType="query")})
    @Path(value="/remove/inactive/server")
    public CommonResultView removeInactiveByServerId(@QueryParam(value="serverId") int serverId) {
        AgentModelThread.removeInactiveByServerId(serverId);
        return CommonResultView.success();
    }

    @GET
    @ApiOperation(value="/threadList/{objHash}", notes="get agent thread list that is monitored by scouter")
    @ApiImplicitParams(value={@ApiImplicitParam(name="objHash", value="object type", required=true, dataType="int", paramType="path"), @ApiImplicitParam(name="serverId", value="server id", dataType="int", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK - Json Data"), @ApiResponse(code=500, message="Server error")})
    @Path(value="/threadList/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<ThreadObjectData>> retrieveThreadList(@PathParam(value="objHash") @Valid @NotNull int objHash, @QueryParam(value="serverId") int serverId) {
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        List<ThreadObjectData> list = this.agentService.retrieveThreadList(objHash, server);
        return CommonResultView.success(list);
    }

    @GET
    @ApiOperation(value="/threadDump/{objHash}", notes="get agent thread dump that is monitored by scouter")
    @ApiImplicitParams(value={@ApiImplicitParam(name="objHash", value="object type", required=true, dataType="int", paramType="path"), @ApiImplicitParam(name="serverId", value="server id", dataType="int", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK - Json Data"), @ApiResponse(code=500, message="Server error")})
    @Path(value="/threadDump/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<String> retrieveThreadDump(@PathParam(value="objHash") @Valid @NotNull int objHash, @QueryParam(value="serverId") int serverId) {
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        String dump = this.agentService.retrieveThreadDump(objHash, server);
        return CommonResultView.success(dump);
    }

    @GET
    @ApiOperation(value="/heapHistogram/{objHash}", notes="get agent Heap histogram that is monitored by scouter")
    @ApiImplicitParams(value={@ApiImplicitParam(name="objHash", value="object type", required=true, dataType="int", paramType="path"), @ApiImplicitParam(name="serverId", value="server id", dataType="int", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK - Json Data"), @ApiResponse(code=500, message="Server error")})
    @Path(value="/heapHistogram/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<HeapHistogramData>> retrieveHeapHistogram(@PathParam(value="objHash") @Valid @NotNull int objHash, @QueryParam(value="serverId") int serverId) {
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        List<HeapHistogramData> list = this.agentService.retrieveHeapHistogram(objHash, server);
        return CommonResultView.success(list);
    }

    @GET
    @ApiOperation(value="/env/{objHash}", notes="get agent environment info that is monitored by scouter")
    @ApiImplicitParams(value={@ApiImplicitParam(name="objHash", value="object type", required=true, dataType="int", paramType="path"), @ApiImplicitParam(name="serverId", value="server id", dataType="int", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK - Json Data"), @ApiResponse(code=500, message="Server error")})
    @Path(value="/env/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<VariableData>> retrieveEnv(@PathParam(value="objHash") @Valid @NotNull int objHash, @QueryParam(value="serverId") int serverId) {
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        List<VariableData> list = this.agentService.retrieveEnv(objHash, server);
        return CommonResultView.success(list);
    }

    @GET
    @ApiOperation(value="/socket/{objHash}", notes="get agent socket info that is monitored by scouter")
    @ApiImplicitParams(value={@ApiImplicitParam(name="objHash", value="object type", required=true, dataType="int", paramType="path"), @ApiImplicitParam(name="serverId", value="server id", dataType="int", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="OK - Json Data"), @ApiResponse(code=500, message="Server error")})
    @Path(value="/socket/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<SocketObjectData>> retrieveSocket(@PathParam(value="objHash") @Valid @NotNull int objHash, @QueryParam(value="serverId") int serverId) {
        List<SocketObjectData> list = this.agentService.retrieveSocket(objHash, serverId);
        return CommonResultView.success(list);
    }
}

