/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.service;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import scouterx.lib3.tomcat.SessionIdGenerator;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.configure.ConfigureAdaptor;
import scouterx.webapp.framework.configure.ConfigureManager;
import scouterx.webapp.framework.exception.ErrorState;
import scouterx.webapp.framework.session.UserToken;
import scouterx.webapp.framework.session.UserTokenCache;
import scouterx.webapp.layer.service.CustomKvStoreService;
import scouterx.webapp.model.scouter.SUser;

public class UserTokenService {
    private static final String SESSION_STORE = "__WEB_SESSION__";
    private ConfigureAdaptor conf = ConfigureManager.getConfigure();
    private static final float TOUCH_RATE = 0.1f;
    public int sessionExpireSec = (int)((float)this.conf.getNetHttpApiSessionTimeout() * 1.1f);
    public int SessionTouchThresholdSec = (int)((float)this.conf.getNetHttpApiSessionTimeout() * 0.1f);
    private SessionIdGenerator sessionIdGenerator = new SessionIdGenerator();
    private CustomKvStoreService customKvStoreService = new CustomKvStoreService();

    public String publishToken(Server server, SUser user) {
        UserToken userToken = UserToken.newToken(user.getId(), this.sessionIdGenerator.generateSessionId(), server.getId());
        UserTokenCache.getInstance().put(userToken);
        String mergedStoreValue = this.getAndMergeToStoredValue(userToken);
        this.customKvStoreService.set(SESSION_STORE, userToken.getUserId(), mergedStoreValue, this.sessionExpireSec, server);
        return userToken.toBearerToken();
    }

    public void validateToken(UserToken token) {
        UserToken tokenTrusted = UserTokenCache.getInstance().get(token);
        if (tokenTrusted == null && (tokenTrusted = this.getStoredMatchedToken(token)) != null) {
            UserTokenCache.getInstance().put(tokenTrusted);
        }
        if (tokenTrusted == null || tokenTrusted.isExpired(this.sessionExpireSec)) {
            throw ErrorState.SESSION_EXPIRED.newBizException();
        }
        if (tokenTrusted.needToBeRenewed(this.SessionTouchThresholdSec)) {
            this.touchToken(token);
        }
    }

    private void touchToken(UserToken token) {
        UserToken renewedToken = token.renew();
        UserTokenCache.getInstance().putAsRecent(renewedToken);
        String mergedStoreValue = this.getAndMergeToStoredValue(renewedToken);
        this.customKvStoreService.set(SESSION_STORE, renewedToken.getUserId(), mergedStoreValue, this.sessionExpireSec, ServerManager.getInstance().getServer(renewedToken.getServerId()));
    }

    private UserToken getStoredMatchedToken(UserToken userToken) {
        String tokens = this.customKvStoreService.get(SESSION_STORE, userToken.getUserId(), ServerManager.getInstance().getServerIfNullDefault(userToken.getServerId()));
        Map userTokenMap = Arrays.stream(tokens.split(":")).map(v -> UserToken.fromStoreValue(v, 0)).filter(Objects::nonNull).collect(Collectors.toMap(UserToken::getToken, Function.identity()));
        return (UserToken)userTokenMap.get(userToken.getToken());
    }

    String getAndMergeToStoredValue(UserToken userToken) {
        String tokens = this.customKvStoreService.get(SESSION_STORE, userToken.getUserId(), ServerManager.getInstance().getServerIfNullDefault(userToken.getServerId()));
        return this.mergeStoredTokensWith(tokens, userToken);
    }

    String mergeStoredTokensWith(String tokens, UserToken userToken) {
        if (StringUtils.isBlank((CharSequence)tokens)) {
            return userToken.toStoreValue();
        }
        Map userTokenMap = Arrays.stream(tokens.split(":")).map(v -> UserToken.fromStoreValue(v, 0)).filter(v -> v.isNotExpired(this.sessionExpireSec)).collect(Collectors.toMap(UserToken::getToken, Function.identity()));
        userTokenMap.put(userToken.getToken(), userToken);
        return userTokenMap.values().stream().map(UserToken::toStoreValue).collect(Collectors.joining(":"));
    }
}

