/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import scouter.io.DataInputX;
import scouter.lang.step.ApiCallStep;
import scouter.lang.step.DispatchStep;
import scouter.lang.step.DumpStep;
import scouter.lang.step.HashedMessageStep;
import scouter.lang.step.MessageStep;
import scouter.lang.step.MethodStep;
import scouter.lang.step.ParameterizedMessageStep;
import scouter.lang.step.SocketStep;
import scouter.lang.step.SpanCallStep;
import scouter.lang.step.SpanStep;
import scouter.lang.step.SqlStep;
import scouter.lang.step.Step;
import scouter.lang.step.StepEnum;
import scouter.lang.step.ThreadCallPossibleStep;
import scouter.lang.step.ThreadSubmitStep;
import scouter.util.IPUtil;
import scouterx.webapp.framework.client.model.TextLoader;
import scouterx.webapp.framework.client.model.TextModel;
import scouterx.webapp.framework.client.model.TextTypeEnum;
import scouterx.webapp.model.scouter.step.SCommonSpanStep;
import scouterx.webapp.model.scouter.step.SSpanCallStep;
import scouterx.webapp.model.scouter.step.SSpanStep;

public class ProfileStepData {
    private String mainValue;
    private List<String> additionalValueList;
    private Step step;

    public static List<ProfileStepData> toList(byte[] buff, long date, int serverId) {
        if (buff == null) {
            return null;
        }
        TextLoader textLoader = new TextLoader(serverId);
        ArrayList<Step> stepList = new ArrayList<Step>();
        DataInputX din = new DataInputX(buff);
        try {
            while (din.available() > 0) {
                Step step = ProfileStepData.convert(din.readStep());
                stepList.add(step);
                ProfileStepData.addToTextLoader(step, textLoader);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        TextModel.startScope();
        textLoader.loadAll();
        ArrayList<ProfileStepData> profileStepDataList = new ArrayList<ProfileStepData>();
        for (Step step : stepList) {
            profileStepDataList.add(ProfileStepData.of(step, date, serverId));
        }
        TextModel.endScope();
        return profileStepDataList;
    }

    private static Step convert(Step step) {
        if (step instanceof SpanStep) {
            return SSpanStep.of((SpanStep)step);
        }
        if (step instanceof SpanCallStep) {
            return SSpanCallStep.of((SpanCallStep)step);
        }
        return step;
    }

    public static ProfileStepData of(Step step, long date, int serverId) {
        String mainValue = ProfileStepData.getStepMainValue(step, date, serverId);
        List<String> additionalValueList = ProfileStepData.getStepAdditionalValue(step, date, serverId);
        ProfileStepData profileStepData = ProfileStepData.builder().mainValue(mainValue).additionalValueList(additionalValueList).step(step).build();
        return profileStepData;
    }

    private static String getStepMainValue(Step step, long date, int serverId) {
        String mainValue = "";
        StepEnum.Type stepType = StepEnum.Type.of((byte)step.getStepType());
        TextTypeEnum textTypeEnum = TextTypeEnum.of(stepType.getAssociatedMainTextTypeName());
        switch (stepType) {
            case METHOD: 
            case METHOD2: {
                mainValue = textTypeEnum.getTextModel().getTextIfNullDefault(date, ((MethodStep)step).getHash(), serverId);
                break;
            }
            case SQL: 
            case SQL2: 
            case SQL3: {
                mainValue = textTypeEnum.getTextModel().getTextIfNullDefault(date, ((SqlStep)step).getHash(), serverId);
                break;
            }
            case APICALL: 
            case APICALL2: {
                mainValue = textTypeEnum.getTextModel().getTextIfNullDefault(date, ((ApiCallStep)step).getHash(), serverId);
                break;
            }
            case THREAD_SUBMIT: {
                mainValue = textTypeEnum.getTextModel().getTextIfNullDefault(date, ((ThreadSubmitStep)step).getHash(), serverId);
                break;
            }
            case HASHED_MESSAGE: {
                mainValue = textTypeEnum.getTextModel().getTextIfNullDefault(date, ((HashedMessageStep)step).getHash(), serverId);
                break;
            }
            case PARAMETERIZED_MESSAGE: {
                ParameterizedMessageStep pmStep = (ParameterizedMessageStep)step;
                mainValue = pmStep.buildMessasge(textTypeEnum.getTextModel().getTextIfNullDefault(date, pmStep.getHash(), serverId));
                break;
            }
            case DISPATCH: {
                mainValue = textTypeEnum.getTextModel().getTextIfNullDefault(date, ((DispatchStep)step).getHash(), serverId);
                break;
            }
            case THREAD_CALL_POSSIBLE: {
                mainValue = textTypeEnum.getTextModel().getTextIfNullDefault(date, ((ThreadCallPossibleStep)step).getHash(), serverId);
                break;
            }
            case SPAN: 
            case SPANCALL: {
                mainValue = textTypeEnum.getTextModel().getTextIfNullDefault(date, ((SCommonSpanStep)step).getHash(), serverId);
                break;
            }
            case DUMP: {
                break;
            }
            case MESSAGE: {
                mainValue = ((MessageStep)step).getMessage();
                break;
            }
            case SOCKET: {
                mainValue = IPUtil.toString((byte[])((SocketStep)step).getIpaddr());
            }
        }
        return mainValue;
    }

    private static List<String> getStepAdditionalValue(Step step, long date, int serverId) {
        StepEnum.Type stepType = StepEnum.Type.of((byte)step.getStepType());
        TextTypeEnum textTypeEnum = TextTypeEnum.of(stepType.getAssociatedMainTextTypeName());
        ArrayList<String> valueList = new ArrayList<String>();
        switch (stepType) {
            case DUMP: {
                DumpStep dumpStep = (DumpStep)step;
                for (int stackHash : dumpStep.stacks) {
                    valueList.add(TextTypeEnum.STACK_ELEMENT.getTextModel().getTextIfNullDefault(date, stackHash, serverId));
                }
                break;
            }
            case SPAN: 
            case SPANCALL: {
                SCommonSpanStep spanStep = (SCommonSpanStep)step;
                String localEndpointName = TextTypeEnum.OBJECT.getTextModel().getTextIfNullDefault(date, spanStep.getLocalEndpoint().getHash(), serverId);
                String remoteEndpointName = TextTypeEnum.OBJECT.getTextModel().getTextIfNullDefault(date, spanStep.getRemoteEndpoint().getHash(), serverId);
                spanStep.getLocalEndpoint().setServiceName(localEndpointName);
                spanStep.getRemoteEndpoint().setServiceName(remoteEndpointName);
                break;
            }
        }
        return valueList;
    }

    private static void addToTextLoader(Step step, TextLoader textLoader) {
        ProfileStepData.addMainValueHashToTextLoader(step, textLoader);
        ProfileStepData.addAdditionalValueHashesToTextLoader(step, textLoader);
    }

    private static void addMainValueHashToTextLoader(Step step, TextLoader textLoader) {
        StepEnum.Type stepType = StepEnum.Type.of((byte)step.getStepType());
        String textTypeName = stepType.getAssociatedMainTextTypeName();
        TextTypeEnum textTypeEnum = TextTypeEnum.of(textTypeName);
        switch (stepType) {
            case METHOD: 
            case METHOD2: {
                textLoader.addTextHash(textTypeEnum, ((MethodStep)step).getHash());
                break;
            }
            case SQL: 
            case SQL2: 
            case SQL3: {
                textLoader.addTextHash(textTypeEnum, ((SqlStep)step).getHash());
                break;
            }
            case APICALL: 
            case APICALL2: {
                textLoader.addTextHash(textTypeEnum, ((ApiCallStep)step).getHash());
                break;
            }
            case THREAD_SUBMIT: {
                textLoader.addTextHash(textTypeEnum, ((ThreadSubmitStep)step).getHash());
                break;
            }
            case HASHED_MESSAGE: {
                textLoader.addTextHash(textTypeEnum, ((HashedMessageStep)step).getHash());
                break;
            }
            case PARAMETERIZED_MESSAGE: {
                textLoader.addTextHash(textTypeEnum, ((ParameterizedMessageStep)step).getHash());
                break;
            }
            case DISPATCH: {
                textLoader.addTextHash(textTypeEnum, ((DispatchStep)step).getHash());
                break;
            }
            case THREAD_CALL_POSSIBLE: {
                textLoader.addTextHash(textTypeEnum, ((ThreadCallPossibleStep)step).getHash());
                break;
            }
            case SPAN: 
            case SPANCALL: {
                textLoader.addTextHash(textTypeEnum, ((SCommonSpanStep)step).getHash());
                break;
            }
            case DUMP: {
                break;
            }
        }
    }

    private static void addAdditionalValueHashesToTextLoader(Step step, TextLoader textLoader) {
        StepEnum.Type stepType = StepEnum.Type.of((byte)step.getStepType());
        String textTypeName = stepType.getAssociatedMainTextTypeName();
        TextTypeEnum textTypeEnum = TextTypeEnum.of(textTypeName);
        switch (stepType) {
            case DUMP: {
                DumpStep dumpStep = (DumpStep)step;
                for (int stackHash : dumpStep.stacks) {
                    textLoader.addTextHash(TextTypeEnum.STACK_ELEMENT, stackHash);
                }
                break;
            }
        }
    }

    @ConstructorProperties(value={"mainValue", "additionalValueList", "step"})
    ProfileStepData(String mainValue, List<String> additionalValueList, Step step) {
        this.mainValue = mainValue;
        this.additionalValueList = additionalValueList;
        this.step = step;
    }

    public static ProfileStepDataBuilder builder() {
        return new ProfileStepDataBuilder();
    }

    public String getMainValue() {
        return this.mainValue;
    }

    public List<String> getAdditionalValueList() {
        return this.additionalValueList;
    }

    public Step getStep() {
        return this.step;
    }

    public void setMainValue(String mainValue) {
        this.mainValue = mainValue;
    }

    public void setAdditionalValueList(List<String> additionalValueList) {
        this.additionalValueList = additionalValueList;
    }

    public void setStep(Step step) {
        this.step = step;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfileStepData)) {
            return false;
        }
        ProfileStepData other = (ProfileStepData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mainValue = this.getMainValue();
        String other$mainValue = other.getMainValue();
        if (this$mainValue == null ? other$mainValue != null : !this$mainValue.equals(other$mainValue)) {
            return false;
        }
        List<String> this$additionalValueList = this.getAdditionalValueList();
        List<String> other$additionalValueList = other.getAdditionalValueList();
        if (this$additionalValueList == null ? other$additionalValueList != null : !((Object)this$additionalValueList).equals(other$additionalValueList)) {
            return false;
        }
        Step this$step = this.getStep();
        Step other$step = other.getStep();
        return !(this$step == null ? other$step != null : !this$step.equals(other$step));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProfileStepData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mainValue = this.getMainValue();
        result = result * 59 + ($mainValue == null ? 43 : $mainValue.hashCode());
        List<String> $additionalValueList = this.getAdditionalValueList();
        result = result * 59 + ($additionalValueList == null ? 43 : ((Object)$additionalValueList).hashCode());
        Step $step = this.getStep();
        result = result * 59 + ($step == null ? 43 : $step.hashCode());
        return result;
    }

    public String toString() {
        return "ProfileStepData(mainValue=" + this.getMainValue() + ", additionalValueList=" + this.getAdditionalValueList() + ", step=" + this.getStep() + ")";
    }

    public static class ProfileStepDataBuilder {
        private String mainValue;
        private List<String> additionalValueList;
        private Step step;

        ProfileStepDataBuilder() {
        }

        public ProfileStepDataBuilder mainValue(String mainValue) {
            this.mainValue = mainValue;
            return this;
        }

        public ProfileStepDataBuilder additionalValueList(List<String> additionalValueList) {
            this.additionalValueList = additionalValueList;
            return this;
        }

        public ProfileStepDataBuilder step(Step step) {
            this.step = step;
            return this;
        }

        public ProfileStepData build() {
            return new ProfileStepData(this.mainValue, this.additionalValueList, this.step);
        }

        public String toString() {
            return "ProfileStepData.ProfileStepDataBuilder(mainValue=" + this.mainValue + ", additionalValueList=" + this.additionalValueList + ", step=" + this.step + ")";
        }
    }
}

