/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model.scouter;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import scouter.lang.pack.ObjectPack;
import scouter.lang.value.Value;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;

public class SObject {
    private String objType;
    private String objFamily;
    private int objHash;
    private String objName;
    private String address;
    private String version;
    private boolean alive = true;
    public long lastWakeUpTime;
    public HashMap<String, Object> tags = new HashMap();

    private SObject(ObjectPack p, Server server) {
        this.objType = p.objType;
        this.objFamily = server.getCounterEngine().getFamilyNameFromObjType(p.objType);
        this.objHash = p.objHash;
        this.objName = p.objName;
        this.address = p.address;
        this.version = p.version;
        this.alive = p.alive;
        this.lastWakeUpTime = p.wakeup;
        for (Map.Entry e : p.tags.toMap().entrySet()) {
            this.tags.put((String)e.getKey(), ((Value)e.getValue()).toJavaObject());
        }
    }

    public static SObject of(ObjectPack p, Server server) {
        return new SObject(p, ServerManager.getInstance().getServerIfNullDefault(server));
    }

    public String getObjType() {
        return this.objType;
    }

    public String getObjFamily() {
        return this.objFamily;
    }

    public int getObjHash() {
        return this.objHash;
    }

    public String getObjName() {
        return this.objName;
    }

    public String getAddress() {
        return this.address;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public long getLastWakeUpTime() {
        return this.lastWakeUpTime;
    }

    public HashMap<String, Object> getTags() {
        return this.tags;
    }

    public String toString() {
        return "SObject(objType=" + this.getObjType() + ", objFamily=" + this.getObjFamily() + ", objHash=" + this.getObjHash() + ", objName=" + this.getObjName() + ", address=" + this.getAddress() + ", version=" + this.getVersion() + ", alive=" + this.isAlive() + ", lastWakeUpTime=" + this.getLastWakeUpTime() + ", tags=" + this.getTags() + ")";
    }

    @ConstructorProperties(value={"objType", "objFamily", "objHash", "objName", "address", "version", "alive", "lastWakeUpTime", "tags"})
    public SObject(String objType, String objFamily, int objHash, String objName, String address, String version, boolean alive, long lastWakeUpTime, HashMap<String, Object> tags) {
        this.objType = objType;
        this.objFamily = objFamily;
        this.objHash = objHash;
        this.objName = objName;
        this.address = address;
        this.version = version;
        this.alive = alive;
        this.lastWakeUpTime = lastWakeUpTime;
        this.tags = tags;
    }
}

