/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model.summary;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import scouterx.webapp.framework.dto.DateAndMapPack;
import scouterx.webapp.framework.exception.ErrorState;
import scouterx.webapp.model.summary.SummaryItem;

public class Summary<T extends SummaryItem<T>> {
    private Map<Integer, T> itemMap = new HashMap<Integer, T>();

    public void merge(T newItem) {
        SummaryItem reservedItem = (SummaryItem)this.itemMap.get(((SummaryItem)newItem).getSummaryKey());
        if (reservedItem == null) {
            this.addItem(newItem);
        } else {
            this.mergeItem(newItem, reservedItem);
        }
    }

    private void mergeItem(T newItem, T reservedItem) {
        ((SummaryItem)reservedItem).merge(newItem);
    }

    private void addItem(T newItem) {
        this.itemMap.put(((SummaryItem)newItem).getSummaryKey(), newItem);
    }

    public static <T1 extends SummaryItem<T1>> Summary<T1> of(Class<T1> clazz, List<DateAndMapPack> dnmPack, int serverId) {
        try {
            SummaryItem instance = (SummaryItem)clazz.newInstance();
            return instance.toSummary(dnmPack, serverId);
        }
        catch (Exception e) {
            throw ErrorState.INTERNAL_SERVER_ERROR.newException(e.getMessage(), e);
        }
    }

    public Map<Integer, T> getItemMap() {
        return this.itemMap;
    }

    public void setItemMap(Map<Integer, T> itemMap) {
        this.itemMap = itemMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Summary)) {
            return false;
        }
        Summary other = (Summary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Integer, T> this$itemMap = this.getItemMap();
        Map<Integer, T> other$itemMap = other.getItemMap();
        return !(this$itemMap == null ? other$itemMap != null : !((Object)this$itemMap).equals(other$itemMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Summary;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Integer, T> $itemMap = this.getItemMap();
        result = result * 59 + ($itemMap == null ? 43 : ((Object)$itemMap).hashCode());
        return result;
    }

    public String toString() {
        return "Summary(itemMap=" + this.getItemMap() + ")";
    }
}

