/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.request;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Set;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.exception.ErrorState;
import scouterx.webapp.framework.util.ZZ;

public class PageableXLogRequest {
    public static final int MAX_PAGE_COUNT = 30000;
    public static final int DEFAULT_PAGE_COUNT = 10000;
    @NotNull
    @PathParam(value="yyyymmdd")
    String yyyymmdd;
    int serverId;
    @QueryParam(value="startTimeMillis")
    long startTimeMillis;
    @QueryParam(value="endTimeMillis")
    long endTimeMillis;
    @QueryParam(value="startHms")
    String startHms;
    @QueryParam(value="endHms")
    String endHms;
    @NotNull
    Set<Integer> objHashes;
    @Max(value=30000L)
    int pageCount;
    @QueryParam(value="lastTxid")
    long lastTxid;
    @QueryParam(value="lastXLogTime")
    long lastXLogTime;

    @QueryParam(value="objHashes")
    public void setObjHashes(String objHashes) {
        this.objHashes = ZZ.splitParamAsIntegerSet(objHashes);
    }

    @QueryParam(value="pageCount")
    public void setPageCount(int pageCount) {
        this.pageCount = pageCount > 0 ? pageCount : 10000;
    }

    @QueryParam(value="serverId")
    public void setServerId(int serverId) {
        this.serverId = ServerManager.getInstance().getServerIfNullDefault(serverId).getId();
    }

    public void validate() {
        if (this.lastTxid != 0L && this.lastXLogTime == 0L || this.lastTxid == 0L && this.lastXLogTime != 0L) {
            throw ErrorState.VALIDATE_ERROR.newBizException("lastTxid and lastXlogTime must coexist!");
        }
        if (StringUtils.isNotBlank((CharSequence)this.startHms) || StringUtils.isNotBlank((CharSequence)this.endHms)) {
            if (StringUtils.isBlank((CharSequence)this.startHms) || StringUtils.isBlank((CharSequence)this.endHms)) {
                throw ErrorState.VALIDATE_ERROR.newBizException("startHms and endHms should be not null !");
            }
            if (this.startTimeMillis > 0L || this.endTimeMillis > 0L) {
                throw ErrorState.VALIDATE_ERROR.newBizException("startYmdHms, endYmdHms and startTimeMillis, endTimeMills must not coexist!");
            }
            try {
                this.setTimeAsYmd();
            }
            catch (ParseException e) {
                throw ErrorState.VALIDATE_ERROR.newBizException("date is invalid!");
            }
        } else if (this.startTimeMillis <= 0L || this.endTimeMillis <= 0L) {
            throw ErrorState.VALIDATE_ERROR.newBizException("startTimeMillis and endTimeMillis must have value!");
        }
    }

    private void setTimeAsYmd() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        this.startTimeMillis = sdf.parse(this.yyyymmdd + this.startHms).getTime();
        this.endTimeMillis = sdf.parse(this.yyyymmdd + this.endHms).getTime();
    }

    public String getYyyymmdd() {
        return this.yyyymmdd;
    }

    public int getServerId() {
        return this.serverId;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    public String getStartHms() {
        return this.startHms;
    }

    public String getEndHms() {
        return this.endHms;
    }

    public Set<Integer> getObjHashes() {
        return this.objHashes;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public long getLastTxid() {
        return this.lastTxid;
    }

    public long getLastXLogTime() {
        return this.lastXLogTime;
    }

    public void setYyyymmdd(String yyyymmdd) {
        this.yyyymmdd = yyyymmdd;
    }

    public void setStartTimeMillis(long startTimeMillis) {
        this.startTimeMillis = startTimeMillis;
    }

    public void setEndTimeMillis(long endTimeMillis) {
        this.endTimeMillis = endTimeMillis;
    }

    public void setStartHms(String startHms) {
        this.startHms = startHms;
    }

    public void setEndHms(String endHms) {
        this.endHms = endHms;
    }

    public void setLastTxid(long lastTxid) {
        this.lastTxid = lastTxid;
    }

    public void setLastXLogTime(long lastXLogTime) {
        this.lastXLogTime = lastXLogTime;
    }

    public String toString() {
        return "PageableXLogRequest(yyyymmdd=" + this.getYyyymmdd() + ", serverId=" + this.getServerId() + ", startTimeMillis=" + this.getStartTimeMillis() + ", endTimeMillis=" + this.getEndTimeMillis() + ", startHms=" + this.getStartHms() + ", endHms=" + this.getEndHms() + ", objHashes=" + this.getObjHashes() + ", pageCount=" + this.getPageCount() + ", lastTxid=" + this.getLastTxid() + ", lastXLogTime=" + this.getLastXLogTime() + ")";
    }
}

