/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import java.util.List;
import scouter.agent.Configure;
import scouter.agent.asm.MethodMV;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.asm.util.HookingSet;
import scouter.agent.netio.data.DataProxy;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;

class MethodCV
extends ClassVisitor
implements Opcodes {
    public String className;
    private HookingSet mset;
    private List<HookingSet> excludeTarget;

    public MethodCV(ClassVisitor cv, HookingSet mset, List<HookingSet> excludeTarget, String className) {
        super(589824, cv);
        this.mset = mset;
        this.excludeTarget = excludeTarget;
        this.className = className;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null || !this.mset.isA(name, desc)) {
            return mv;
        }
        if (AsmUtil.isSpecial(name)) {
            return mv;
        }
        for (int i = 0; i < this.excludeTarget.size(); ++i) {
            HookingSet excludeSet = this.excludeTarget.get(i);
            if (!excludeSet.classMatch.include(this.className) || !excludeSet.isA(name, desc)) continue;
            return mv;
        }
        Configure conf = Configure.getInstance();
        boolean isPublic = conf.hook_method_access_public_enabled;
        boolean isProtected = conf.hook_method_access_protected_enabled;
        boolean isPrivate = conf.hook_method_access_private_enabled;
        boolean isNone = conf.hook_method_access_none_enabled;
        if (!conf.hook_method_lambda_enable || (access & 0x1000) != 4096 || name.indexOf("lambda$") != 0) {
            switch (access & 7) {
                case 1: {
                    if (isPublic) break;
                    return mv;
                }
                case 4: {
                    if (isProtected) break;
                    return mv;
                }
                case 2: {
                    if (isPrivate) break;
                    return mv;
                }
                default: {
                    if (isNone) break;
                    return mv;
                }
            }
        }
        if (conf.isIgnoreMethodPrefix(name)) {
            return mv;
        }
        String fullname = AsmUtil.makeMethodFullName(this.className, name, desc);
        int fullname_hash = DataProxy.sendMethodName(fullname);
        return new MethodMV(access, desc, mv, fullname, fullname_hash);
    }
}

