/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import scouter.agent.asm.util.AsmUtil;
import scouter.agent.trace.TraceSQL;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.Type;
import scouter.org.objectweb.asm.commons.LocalVariablesSorter;

class SqlMapMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String CLASS = TraceSQL.class.getName().replace('.', '/');
    private static final String METHOD = "sqlMap";
    private static final String SIGNATURE = "(Ljava/lang/String;Ljava/lang/String;)V";
    private Type[] paramTypes;
    private boolean isStatic;
    private String methodName;

    public SqlMapMV(int access, String desc, MethodVisitor mv, Type[] paramTypes, boolean isStatic, String classname, String methodname, String methoddesc) {
        super(589824, access, desc, mv);
        this.paramTypes = paramTypes;
        this.isStatic = isStatic;
        this.methodName = methodname;
    }

    @Override
    public void visitCode() {
        AsmUtil.PUSH(this.mv, this.methodName);
        boolean flag = false;
        int sidx = this.isStatic ? 0 : 1;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            Type tp = this.paramTypes[i];
            if ("java/lang/String".equals(tp.getInternalName())) {
                this.mv.visitVarInsn(25, sidx);
                flag = true;
                break;
            }
            sidx += tp.getSize();
        }
        if (!flag) {
            AsmUtil.PUSH(this.mv, "");
        }
        this.mv.visitMethodInsn(184, CLASS, METHOD, SIGNATURE, false);
        super.visitCode();
    }
}

