/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.proxy;

import scouter.agent.Logger;
import scouter.agent.proxy.ILettuceTrace;
import scouter.agent.proxy.LoaderManager;
import scouter.agent.trace.TraceContext;

public class LettuceTraceFactory {
    private static ILettuceTrace lettuceTrace;
    private static Object lock;
    private static final String CLIENT = "scouter.xtra.redis.LettuceTracer";
    public static final ILettuceTrace dummy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILettuceTrace create(ClassLoader parent) {
        try {
            if (lettuceTrace == null) {
                Object object = lock;
                synchronized (object) {
                    if (lettuceTrace == null) {
                        ClassLoader loader = LoaderManager.getRedisClient(parent);
                        if (loader == null) {
                            Logger.println("Lettuce Client Load Error.. Dummy Loaded");
                            lettuceTrace = dummy;
                        } else {
                            Class<?> c = Class.forName(CLIENT, true, loader);
                            lettuceTrace = (ILettuceTrace)c.newInstance();
                        }
                    }
                }
            }
            return lettuceTrace;
        }
        catch (Throwable e) {
            e.printStackTrace();
            Logger.println("SC-146", "fail to create", e);
            return dummy;
        }
    }

    static {
        lock = new Object();
        dummy = new ILettuceTrace(){

            @Override
            public void startRedis(TraceContext ctx, Object channel) {
            }

            @Override
            public String getCommand(Object command) {
                return null;
            }

            @Override
            public String parseArgs(Object object) {
                return null;
            }
        };
    }
}

