/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.proxy;

import scouter.agent.Logger;
import scouter.agent.proxy.IReactiveSupport;
import scouter.agent.proxy.LoaderManager;
import scouter.agent.trace.TraceContext;

public class ReactiveSupportFactory {
    private static final String REACTIVE_SUPPORT = "scouter.xtra.reactive.ReactiveSupport";
    private static final String REACTIVE_SUPPORT_W_COROUTINE = "scouter.xtra.reactive.ReactiveSupportWithCoroutine";
    public static final IReactiveSupport dummy = new IReactiveSupport(){

        @Override
        public Object subscriptOnContext(Object mono0, TraceContext traceContext) {
            return mono0;
        }

        @Override
        public void contextOperatorHook() {
        }

        @Override
        public Object monoCoroutineContextHook(Object coroutineContext, TraceContext traceContext) {
            return coroutineContext;
        }

        @Override
        public String dumpScannable(TraceContext traceContext, TraceContext.TimedScannable timedScannable, long now) {
            return null;
        }
    };

    public static IReactiveSupport create(ClassLoader parent) {
        try {
            ClassLoader loader = LoaderManager.getReactiveClient(parent);
            if (loader == null) {
                return dummy;
            }
            IReactiveSupport reactiveSupport = null;
            try {
                Class<?> c = Class.forName(REACTIVE_SUPPORT_W_COROUTINE, true, loader);
                reactiveSupport = (IReactiveSupport)c.newInstance();
            }
            catch (Throwable e) {
                Logger.println("A133-0", "fail to create reactive support: REACTIVE_SUPPORT_W_COROUTINE", e);
                Class<?> c = Class.forName(REACTIVE_SUPPORT, true, loader);
                reactiveSupport = (IReactiveSupport)c.newInstance();
                Logger.println("success to create reactive support without coroutine support");
            }
            return reactiveSupport;
        }
        catch (Throwable e) {
            Logger.println("A133-2", "fail to create", e);
            return dummy;
        }
    }
}

