/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace;

import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.proxy.IMongoDbTracer;
import scouter.agent.proxy.MongoDbTraceFactory;
import scouter.agent.trace.StepTransferMap;
import scouter.agent.trace.TraceContext;
import scouter.agent.trace.TraceContextManager;

public class TraceMongoDB {
    public static final String V405 = "v405";
    public static final String V382 = "v382";
    public static final String V364 = "v364";
    static IMongoDbTracer tracer;
    static Configure conf;

    public static Object startExecute(Object _this, Object connection, Object namespace, Object command, Object readPreference, Object payload, String version) {
        TraceContext ctx = TraceContextManager.getContext();
        if (ctx == null) {
            return null;
        }
        try {
            StepTransferMap.ID id;
            if (tracer == null) {
                tracer = MongoDbTraceFactory.create(namespace.getClass().getClassLoader(), version);
            }
            if ((id = tracer.generateAndTransferMongoQueryStep(ctx, _this, connection)) == null) {
                return null;
            }
            Object callback = tracer.genCallback(id, namespace, command, readPreference, payload);
            if (callback == null) {
                return null;
            }
            return callback;
        }
        catch (Throwable t) {
            Logger.println("MTC01", t.getMessage(), t);
            return null;
        }
    }

    public static void endExecute(Object callback, Throwable throwable) {
        if (callback == null) {
            return;
        }
        if (tracer == null) {
            return;
        }
        try {
            tracer.doCallback(callback, null, throwable);
        }
        catch (Throwable t) {
            Logger.println("MTC02", t.getMessage(), t);
        }
    }

    public static Object startExecuteAsync(Object _this, Object connection, Object namespace, Object command, Object readPreference, Object payload, Object callback, String version) {
        TraceContext ctx = TraceContextManager.getContext();
        if (ctx == null) {
            return callback;
        }
        try {
            StepTransferMap.ID id;
            if (tracer == null) {
                tracer = MongoDbTraceFactory.create(namespace.getClass().getClassLoader(), version);
            }
            if ((id = tracer.generateAndTransferMongoQueryStep(ctx, _this, connection)) == null) {
                return callback;
            }
            return tracer.wrapCallback(id, namespace, command, readPreference, payload, callback);
        }
        catch (Throwable e) {
            Logger.println("MTC03", e.getMessage(), e);
            return callback;
        }
    }

    static {
        conf = Configure.getInstance();
    }
}

