/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.util;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import scouter.agent.JavaAgent;
import scouter.agent.Logger;

public class ModuleUtil {
    private static final ModuleUtil instance = JavaAgent.isJava9plus() ? new ModuleUtil() : null;
    private final Method getModuleMethod;
    private final Class moduleClass;
    private final Method redefineModuleMethod;

    private ModuleUtil() {
        try {
            this.getModuleMethod = Class.class.getMethod("getModule", new Class[0]);
            this.moduleClass = Class.forName("java.lang.Module");
            this.redefineModuleMethod = Instrumentation.class.getMethod("redefineModule", this.moduleClass, Set.class, Map.class, Map.class, Set.class, Map.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object getModule(Class clazz) throws Exception {
        return instance.getModuleInternal(clazz);
    }

    public static void grantAccess(Instrumentation instrumentation, String fromClassName, String toClassName) throws Exception {
        instance.grantAccessInternal(instrumentation, fromClassName, null, toClassName, null);
    }

    public static void grantAccess(Instrumentation instrumentation, String fromClassName, ClassLoader fromClassLoader, String toClassName, ClassLoader toClassLoader) throws Exception {
        instance.grantAccessInternal(instrumentation, fromClassName, fromClassLoader, toClassName, toClassLoader);
    }

    private Object getModuleInternal(Class clazz) throws Exception {
        return this.getModuleMethod.invoke((Object)clazz, new Object[0]);
    }

    private void grantAccessInternal(Instrumentation instrumentation, String fromClassName, ClassLoader fromClassLoader, String toClassName, ClassLoader toClassLoader) throws Exception {
        Class<?> toClass;
        Class<?> fromClass;
        try {
            fromClass = fromClassLoader == null ? Class.forName(fromClassName) : Class.forName(fromClassName, true, fromClassLoader);
        }
        catch (ClassNotFoundException e) {
            Logger.println("MODULEUTIL-1", e.getMessage() + " : " + fromClassName, e);
            return;
        }
        try {
            toClass = toClassLoader == null ? Class.forName(toClassName) : Class.forName(toClassName, true, toClassLoader);
        }
        catch (ClassNotFoundException e) {
            Logger.println("MODULEUTIL-2", e.getMessage() + " : " + toClassName, e);
            return;
        }
        HashMap extraOpens = new HashMap();
        Package pkg = toClass.getPackage();
        if (pkg != null) {
            HashSet<Object> openSet = new HashSet<Object>();
            openSet.add(this.getModuleMethod.invoke(fromClass, new Object[0]));
            extraOpens.put(pkg.getName(), openSet);
        }
        this.redefineModuleMethod.invoke((Object)instrumentation, this.getModuleMethod.invoke(toClass, new Object[0]), new HashSet(), new HashMap(), extraOpens, new HashSet(), new HashMap());
        Logger.println("extra opens module. from = " + fromClassName + " to = " + toClassName);
    }
}

