/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;
import scouter.util.LongEnumer;
import scouter.util.StringEnumer;

public class StringLongLinkedMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private StringLongLinkedEntry[] table;
    private StringLongLinkedEntry header;
    private int count;
    private int threshold;
    private final float loadFactor;
    private long NONE = 0L;
    private int max;

    public StringLongLinkedMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new StringLongLinkedEntry[initCapacity];
        this.header.link_next = this.header.link_prev = (this.header = new StringLongLinkedEntry(null, 0L, null));
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public StringLongLinkedMap() {
        this(101, 0.75f);
    }

    public StringLongLinkedMap setNullValue(long none) {
        this.NONE = none;
        return this;
    }

    public int size() {
        return this.count;
    }

    public String[] keyArray() {
        String[] _keys = new String[this.size()];
        StringEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextString();
        }
        return _keys;
    }

    public synchronized StringEnumer keys() {
        return new Enumer(TYPE.KEYS);
    }

    public synchronized LongEnumer values() {
        return new Enumer(TYPE.VALUES);
    }

    public synchronized Enumeration<StringLongLinkedEntry> entries() {
        return new Enumer(TYPE.ENTRIES);
    }

    public synchronized boolean containsValue(long value) {
        StringLongLinkedEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            StringLongLinkedEntry e = tab[i];
            while (e != null) {
                if (e.value == value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(String key) {
        StringLongLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringLongLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized long get(String key) {
        if (key == null) {
            return this.NONE;
        }
        StringLongLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringLongLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        return this.NONE;
    }

    public synchronized long getFirsValue() {
        if (this.isEmpty()) {
            return this.NONE;
        }
        return this.header.link_next.value;
    }

    public synchronized long getLastValue() {
        if (this.isEmpty()) {
            return this.NONE;
        }
        return this.header.link_prev.value;
    }

    private int hash(String key) {
        return key.hashCode() & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        StringLongLinkedEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        StringLongLinkedEntry[] newMap = new StringLongLinkedEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            StringLongLinkedEntry old = oldMap[i];
            while (old != null) {
                StringLongLinkedEntry e = old;
                old = old.next;
                String key = e.key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public StringLongLinkedMap setMax(int max) {
        this.max = max;
        return this;
    }

    public long put(String key, long value) {
        return this._put(key, value, MODE.LAST);
    }

    public long putLast(String key, long value) {
        return this._put(key, value, MODE.FORCE_LAST);
    }

    public long putFirst(String key, long value) {
        return this._put(key, value, MODE.FORCE_FIRST);
    }

    private synchronized long _put(String key, long value, MODE m) {
        if (key == null) {
            return this.NONE;
        }
        StringLongLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringLongLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                long old = e.value;
                e.value = value;
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    String k;
                    while (this.count >= this.max) {
                        k = this.header.link_prev.key;
                        long v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    String k;
                    while (this.count >= this.max) {
                        k = this.header.link_next.key;
                        long v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new StringLongLinkedEntry(key, value, tab[index]);
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    protected void overflowed(String key, long value) {
    }

    public synchronized long remove(String key) {
        if (key == null) {
            return this.NONE;
        }
        StringLongLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringLongLinkedEntry e = tab[index];
        StringLongLinkedEntry prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                long oldValue = e.value;
                e.value = this.NONE;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return this.NONE;
    }

    public synchronized long removeFirst() {
        if (this.isEmpty()) {
            return this.NONE;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized long removeLast() {
        if (this.isEmpty()) {
            return this.NONE;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        StringLongLinkedEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_next = this.header.link_prev = this.header;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<StringLongLinkedEntry> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            StringLongLinkedEntry e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<StringLongLinkedEntry> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            StringLongLinkedEntry e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(StringLongLinkedEntry link_prev, StringLongLinkedEntry link_next, StringLongLinkedEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(StringLongLinkedEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public static void main(String[] args) {
    }

    private class Enumer
    implements Enumeration,
    StringEnumer,
    LongEnumer {
        TYPE type;
        StringLongLinkedEntry entry;

        Enumer(TYPE type) {
            this.entry = ((StringLongLinkedMap)StringLongLinkedMap.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return StringLongLinkedMap.this.header != this.entry && this.entry != null;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                StringLongLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case KEYS: {
                        return e.key;
                    }
                    case VALUES: {
                        return e.value;
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public long nextLong() {
            if (this.hasMoreElements()) {
                StringLongLinkedEntry e = this.entry;
                this.entry = e.link_next;
                return e.value;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public String nextString() {
            if (this.hasMoreElements()) {
                StringLongLinkedEntry e = this.entry;
                this.entry = e.link_next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    private static enum TYPE {
        KEYS,
        VALUES,
        ENTRIES;

    }

    public static class StringLongLinkedEntry {
        String key;
        long value;
        StringLongLinkedEntry next;
        StringLongLinkedEntry link_next;
        StringLongLinkedEntry link_prev;

        protected StringLongLinkedEntry(String key, long value, StringLongLinkedEntry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new StringLongLinkedEntry(this.key, this.value, this.next == null ? null : (StringLongLinkedEntry)this.next.clone());
        }

        public String getKey() {
            return this.key;
        }

        public long getValue() {
            return this.value;
        }

        public long setValue(long value) {
            long oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StringLongLinkedEntry)) {
                return false;
            }
            StringLongLinkedEntry e = (StringLongLinkedEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(e.value, this.value);
        }

        public int hashCode() {
            return this.key.hashCode() ^ (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private static enum MODE {
        FORCE_FIRST,
        FORCE_LAST,
        FIRST,
        LAST;

    }
}

