/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import scouter.agent.asm.util.AsmUtil;
import scouter.agent.trace.TraceMain;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.Type;
import scouter.org.objectweb.asm.commons.LocalVariablesSorter;

class CapReturnMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String CLASS = TraceMain.class.getName().replace('.', '/');
    private static final String METHOD = "capReturn";
    private static final String SIGNATURE = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V";
    private Type returnType;
    private String className;
    private String methodName;
    private String methodDesc;
    private boolean isStatic;

    public CapReturnMV(int access, String desc, MethodVisitor mv, String classname, String methodname, String methoddesc, boolean isStatic) {
        super(327680, access, desc, mv);
        this.returnType = Type.getReturnType(desc);
        this.className = classname;
        this.methodName = methodname;
        this.methodDesc = methoddesc;
        this.isStatic = isStatic;
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177) {
            this.capReturn();
        }
        this.mv.visitInsn(opcode);
    }

    private void capReturn() {
        Type tp = this.returnType;
        if (tp == null || tp.equals(Type.VOID_TYPE)) {
            this.pushCommon();
            this.mv.visitInsn(1);
            this.mv.visitMethodInsn(184, CLASS, METHOD, SIGNATURE, false);
            return;
        }
        int i = this.newLocal(tp);
        switch (tp.getSort()) {
            case 1: {
                this.mv.visitVarInsn(54, i);
                this.mv.visitVarInsn(21, i);
                this.pushCommon();
                this.mv.visitVarInsn(21, i);
                this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                break;
            }
            case 3: {
                this.mv.visitVarInsn(54, i);
                this.mv.visitVarInsn(21, i);
                this.pushCommon();
                this.mv.visitVarInsn(21, i);
                this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                break;
            }
            case 2: {
                this.mv.visitVarInsn(54, i);
                this.mv.visitVarInsn(21, i);
                this.pushCommon();
                this.mv.visitVarInsn(21, i);
                this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                break;
            }
            case 4: {
                this.mv.visitVarInsn(54, i);
                this.mv.visitVarInsn(21, i);
                this.pushCommon();
                this.mv.visitVarInsn(21, i);
                this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                break;
            }
            case 5: {
                this.mv.visitVarInsn(54, i);
                this.mv.visitVarInsn(21, i);
                this.pushCommon();
                this.mv.visitVarInsn(21, i);
                this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                break;
            }
            case 7: {
                this.mv.visitVarInsn(55, i);
                this.mv.visitVarInsn(22, i);
                this.pushCommon();
                this.mv.visitVarInsn(22, i);
                this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                break;
            }
            case 6: {
                this.mv.visitVarInsn(56, i);
                this.mv.visitVarInsn(23, i);
                this.pushCommon();
                this.mv.visitVarInsn(23, i);
                this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                break;
            }
            case 8: {
                this.mv.visitVarInsn(57, i);
                this.mv.visitVarInsn(24, i);
                this.pushCommon();
                this.mv.visitVarInsn(24, i);
                this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                break;
            }
            default: {
                this.mv.visitVarInsn(58, i);
                this.mv.visitVarInsn(25, i);
                this.pushCommon();
                this.mv.visitVarInsn(25, i);
            }
        }
        this.mv.visitMethodInsn(184, CLASS, METHOD, SIGNATURE, false);
    }

    private void pushCommon() {
        AsmUtil.PUSH(this.mv, this.className);
        AsmUtil.PUSH(this.mv, this.methodName);
        AsmUtil.PUSH(this.mv, this.methodDesc);
        if (this.isStatic) {
            AsmUtil.PUSHNULL(this.mv);
        } else {
            this.mv.visitVarInsn(25, 0);
        }
    }
}

