/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import scouter.agent.asm.util.AsmUtil;
import scouter.agent.trace.TraceSQL;
import scouter.org.objectweb.asm.Label;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.Type;
import scouter.org.objectweb.asm.commons.LocalVariablesSorter;

class JDBCDriverMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String TRACE_SQL = TraceSQL.class.getName().replace('.', '/');
    private static final String CONNECT_METHOD = "driverConnect";
    private static final String CONNECT_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;";
    private static final String ERR_SIGNATURE = "(Ljava/lang/String;Ljava/lang/Throwable;)V";
    private Label startFinally = new Label();
    private int strArgIdx;

    public JDBCDriverMV(int access, String desc, MethodVisitor mv, String fullname) {
        super(327680, access, desc, mv);
        this.strArgIdx = AsmUtil.getStringIdx(access, desc);
    }

    @Override
    public void visitCode() {
        this.mv.visitLabel(this.startFinally);
        this.mv.visitCode();
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177) {
            this.mv.visitVarInsn(25, this.strArgIdx);
            this.mv.visitMethodInsn(184, TRACE_SQL, CONNECT_METHOD, CONNECT_SIGNATURE, false);
        }
        this.mv.visitInsn(opcode);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        this.mv.visitLabel(endFinally);
        this.mv.visitInsn(89);
        int errIdx = this.newLocal(Type.getType(Throwable.class));
        this.mv.visitVarInsn(58, errIdx);
        this.mv.visitVarInsn(25, this.strArgIdx);
        this.mv.visitVarInsn(25, errIdx);
        this.mv.visitMethodInsn(184, TRACE_SQL, CONNECT_METHOD, ERR_SIGNATURE, false);
        this.mv.visitInsn(191);
        this.mv.visitMaxs(maxStack + 8, maxLocals + 2);
    }
}

