/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.asm;

import java.util.HashSet;
import scouter.agent.ClassDesc;
import scouter.agent.asm.IASM;
import scouter.agent.asm.util.HookingSet;
import scouter.agent.batch.Configure;
import scouter.agent.batch.Logger;
import scouter.agent.batch.asm.ResultSetCV;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class JDBCResultSetASM
implements IASM,
Opcodes {
    public final HashSet<String> target;

    public JDBCResultSetASM() {
        this.target = HookingSet.getHookingClassSet(Configure.getInstance().hook_jdbc_rs_classes);
        this.target.add("org/mariadb/jdbc/MySQLResultSet");
        this.target.add("oracle/jdbc/driver/OracleResultSetImpl");
        this.target.add("com/mysql/jdbc/ResultSetImpl");
        this.target.add("org/postgresql/jdbc2/AbstractJdbc2ResultSet");
        this.target.add("org/apache/derby/client/am/ResultSet");
        this.target.add("jdbc/FakeResultSet");
        this.target.add("net/sourceforge/jtds/jdbc/JtdsResultSet");
        this.target.add("com/microsoft/sqlserver/jdbc/SQLServerResultSet");
        this.target.add("oracle/jdbc/driver/InsensitiveScrollableResultSet");
        this.target.add("oracle/jdbc/driver/SensitiveScrollableResultSet");
        this.target.add("org/hsqldb/jdbc/JDBCResultSet");
        this.target.add("cubrid/jdbc/driver/CUBRIDResultSet");
        this.target.add("org/mariadb/jdbc/MariaDbResultSet");
        this.target.add("com/tmax/tibero/jdbc/TbResultSetBase");
        this.target.add("com/tmax/tibero/jdbc/driver/TbResultSetBase");
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!Configure.getInstance().sql_enabled) {
            return cv;
        }
        if (!this.target.contains(className)) {
            return cv;
        }
        Logger.println("A107", "jdbc rs found: " + className);
        return new ResultSetCV(cv);
    }
}

