/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.netio.data.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.zip.ZipOutputStream;
import scouter.agent.batch.Configure;
import scouter.agent.batch.netio.data.net.TcpAgentReqMgr;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.util.FileUtil;
import scouter.util.IntKeyLinkedMap;
import scouter.util.ZipFileUtil;

public class TCPStackZipWorker
implements Runnable {
    private Socket socket;
    private DataInputX in;
    private DataOutputX out;
    private int objHash;
    private TcpAgentReqMgr tcpAgentReqMgr;
    public static IntKeyLinkedMap<TCPStackZipWorker> LIVE = new IntKeyLinkedMap();

    public TCPStackZipWorker(TcpAgentReqMgr tcpAgentReqMgr) {
        this.tcpAgentReqMgr = tcpAgentReqMgr;
        this.objHash = Configure.getInstance().getObjHash();
    }

    public boolean prepare(boolean reConnect) {
        if (reConnect) {
            this.close(false);
        }
        Configure conf = Configure.getInstance();
        String host = conf.net_collector_ip;
        int port = conf.net_collector_tcp_port;
        int so_timeout = conf.net_collector_tcp_so_timeout_ms;
        int connection_timeout = conf.net_collector_tcp_connection_timeout_ms;
        this.socket = new Socket();
        try {
            this.socket.connect(new InetSocketAddress(host, port), connection_timeout);
            this.socket.setSoTimeout(so_timeout);
            if (!reConnect) {
                LIVE.put(this.hashCode(), this);
            }
            this.in = new DataInputX(new BufferedInputStream(this.socket.getInputStream()));
            this.out = new DataOutputX(new BufferedOutputStream(this.socket.getOutputStream()));
            this.out.writeInt(-889319407);
            this.out.writeInt(this.objHash);
            this.out.flush();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void run() {
        if (this.socket == null) {
            return;
        }
        byte[] job = null;
        try {
            while ((job = this.tcpAgentReqMgr.getJob()) != null) {
                this.process(job);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.prepare(true);
        }
        LIVE.remove(this.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(byte[] job) throws Exception {
        long startTime = 0L;
        String objName = null;
        String filename = null;
        DataInputX reader = new DataInputX(job);
        startTime = reader.readLong();
        objName = reader.readText();
        filename = reader.readText();
        if (startTime == 0L || filename == null) {
            return;
        }
        File[] files = null;
        boolean isSuccess = false;
        BufferedInputStream bin = null;
        try {
            files = this.makeZipFile(filename);
            long fileSize = files[0].length();
            this.out.writeInt(-303235071);
            this.out.writeLong(startTime);
            this.out.writeText(objName);
            int index = filename.lastIndexOf(File.separator);
            String pureName = index >= 0 ? filename.substring(index + 1) : filename;
            this.out.writeText(pureName);
            this.out.writeLong(fileSize);
            this.out.flush();
            bin = new BufferedInputStream(new FileInputStream(files[0]));
            byte[] buffer = new byte[4096];
            OutputStream os = this.socket.getOutputStream();
            while ((index = bin.read(buffer)) != -1) {
                os.write(buffer, 0, index);
            }
            os.flush();
            bin.close();
            bin = null;
            if (this.in.readByte() == 1) {
                isSuccess = true;
            }
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (Exception fileSize) {}
            }
        }
        if (!isSuccess) {
            return;
        }
        try {
            for (File file : files) {
                if (file.delete()) continue;
                TcpAgentReqMgr.getInstance().addFile(file);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void close(boolean remove) {
        FileUtil.close(this.in);
        FileUtil.close(this.out);
        FileUtil.close(this.socket);
        this.socket = null;
        if (remove) {
            LIVE.remove(this.hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File[] makeZipFile(String filename) {
        File indexFile = null;
        File stackFile = null;
        ZipOutputStream zos = null;
        File zipFile = new File(filename + ".zip");
        try {
            zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            zos.setLevel(9);
            indexFile = new File(filename + ".inx");
            if (!indexFile.exists()) {
                File[] fileArray = null;
                return fileArray;
            }
            ZipFileUtil.sendZipFile(zos, indexFile);
            stackFile = new File(filename + ".log");
            if (!stackFile.exists()) {
                File[] fileArray = null;
                return fileArray;
            }
            ZipFileUtil.sendZipFile(zos, stackFile);
            zos.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            File[] fileArray = null;
            return fileArray;
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Exception exception) {}
            }
        }
        File[] files = new File[]{zipFile, indexFile, stackFile};
        return files;
    }
}

