/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.netio.data.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import scouter.agent.Logger;
import scouter.agent.batch.Configure;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.net.NetCafe;
import scouter.util.KeyGen;

public class UdpAgent {
    public static boolean sendUdp(String IPAddress, int port, byte[] byteArray) {
        InetAddress server = null;
        try {
            server = InetAddress.getByName(IPAddress);
            return UdpAgent.sendUdp(server, port, byteArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sendUdp(InetAddress IPAddress, int port, byte[] byteArray) {
        block16: {
            boolean bl;
            DatagramSocket datagram = null;
            try {
                Configure conf = Configure.getInstance();
                if (byteArray.length > conf.net_udp_packet_max_bytes) {
                    boolean bl2 = UdpAgent.sendMTU(IPAddress, port, byteArray, conf.net_udp_packet_max_bytes);
                    return bl2;
                }
                datagram = new DatagramSocket();
                DatagramPacket packet = new DatagramPacket(byteArray, byteArray.length);
                packet.setAddress(IPAddress);
                packet.setPort(port);
                datagram.send(packet);
                bl = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                break block16;
            }
            finally {
                if (datagram != null) {
                    try {
                        datagram.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return bl;
        }
        return false;
    }

    public static boolean sendMTU(InetAddress IPAddress, int port, byte[] data, int packetSize) {
        try {
            if (IPAddress == null) {
                return false;
            }
            long pkid = KeyGen.next();
            int availPacketSize = packetSize - 23;
            int total = data.length / availPacketSize;
            int remainder = data.length % availPacketSize;
            int num = 0;
            boolean isSuccess = true;
            int totalPacketCnt = total;
            if (remainder > 0) {
                ++totalPacketCnt;
            }
            for (num = 0; isSuccess && num < total; ++num) {
                isSuccess = UdpAgent.SendMTU(IPAddress, port, pkid, totalPacketCnt, num, availPacketSize, DataInputX.get(data, num * availPacketSize, availPacketSize));
            }
            if (isSuccess && remainder > 0) {
                isSuccess = UdpAgent.SendMTU(IPAddress, port, pkid, totalPacketCnt, num, remainder, DataInputX.get(data, data.length - remainder, remainder));
            }
            return isSuccess;
        }
        catch (IOException e) {
            Logger.println("A121", "UDP", e);
            return false;
        }
    }

    private static boolean SendMTU(InetAddress IPAddress, int port, long pkid, int total, int num, int packetSize, byte[] data) throws IOException {
        Configure conf = Configure.getInstance();
        DataOutputX out = new DataOutputX();
        out.write(NetCafe.CAFE_MTU);
        out.writeInt(conf.getObjHash());
        out.writeLong(pkid);
        out.writeShort(total);
        out.writeShort(num);
        out.writeBlob(data);
        return UdpAgent.sendUdp(IPAddress, port, out.toByteArray());
    }
}

