/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import scouter.agent.asm.util.AsmUtil;
import scouter.agent.trace.TraceApiCall;
import scouter.org.objectweb.asm.Label;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.Type;
import scouter.org.objectweb.asm.commons.LocalVariablesSorter;

class ApicallExtMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String TRACESUBCALL = TraceApiCall.class.getName().replace('.', '/');
    private static final String START_METHOD = "startApicall";
    private static final String START_SIGNATURE = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String END_METHOD = "endApicall";
    private static final String END_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Throwable;)V";
    private Label startFinally = new Label();
    private Type[] paramTypes;
    private Type returnType;
    private boolean isStatic;
    private String className;
    private String methodName;
    private String methodDesc;
    private int statIdx;

    public ApicallExtMV(int access, String desc, MethodVisitor mv, Type[] paramTypes, boolean isStatic, String classname, String methodname, String methoddesc) {
        super(327680, access, desc, mv);
        this.paramTypes = paramTypes;
        this.returnType = Type.getReturnType(desc);
        this.isStatic = isStatic;
        this.className = classname;
        this.methodName = methodname;
        this.methodDesc = methoddesc;
    }

    @Override
    public void visitCode() {
        int sidx = this.isStatic ? 0 : 1;
        int arrVarIdx = this.newLocal(Type.getType("[Ljava/lang/Object;"));
        AsmUtil.PUSH(this.mv, this.paramTypes.length);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        this.mv.visitVarInsn(58, arrVarIdx);
        for (int i = 0; i < this.paramTypes.length; ++i) {
            Type tp = this.paramTypes[i];
            this.mv.visitVarInsn(25, arrVarIdx);
            AsmUtil.PUSH(this.mv, i);
            switch (tp.getSort()) {
                case 1: {
                    this.mv.visitVarInsn(21, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                    break;
                }
                case 3: {
                    this.mv.visitVarInsn(21, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                    break;
                }
                case 2: {
                    this.mv.visitVarInsn(21, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                    break;
                }
                case 4: {
                    this.mv.visitVarInsn(21, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                    break;
                }
                case 5: {
                    this.mv.visitVarInsn(21, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                    break;
                }
                case 7: {
                    this.mv.visitVarInsn(22, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                    break;
                }
                case 6: {
                    this.mv.visitVarInsn(23, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                    break;
                }
                case 8: {
                    this.mv.visitVarInsn(24, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                    break;
                }
                default: {
                    this.mv.visitVarInsn(25, sidx);
                }
            }
            this.mv.visitInsn(83);
            sidx += tp.getSize();
        }
        AsmUtil.PUSH(this.mv, this.className);
        AsmUtil.PUSH(this.mv, this.methodName);
        AsmUtil.PUSH(this.mv, this.methodDesc);
        if (this.isStatic) {
            AsmUtil.PUSHNULL(this.mv);
        } else {
            this.mv.visitVarInsn(25, 0);
        }
        this.mv.visitVarInsn(25, arrVarIdx);
        this.mv.visitMethodInsn(184, TRACESUBCALL, START_METHOD, START_SIGNATURE, false);
        this.statIdx = this.newLocal(Type.getType(Object.class));
        this.mv.visitVarInsn(58, this.statIdx);
        this.mv.visitLabel(this.startFinally);
        this.mv.visitCode();
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177) {
            this.capReturn();
        }
        this.mv.visitInsn(opcode);
    }

    private void capReturn() {
        Type tp = this.returnType;
        if (tp == null || tp.equals(Type.VOID_TYPE)) {
            this.mv.visitVarInsn(25, this.statIdx);
            this.mv.visitInsn(1);
            this.mv.visitInsn(1);
            this.mv.visitMethodInsn(184, TRACESUBCALL, END_METHOD, END_SIGNATURE, false);
            return;
        }
        int i = this.newLocal(tp);
        switch (tp.getSort()) {
            case 1: {
                this.mv.visitVarInsn(54, i);
                this.mv.visitVarInsn(21, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(21, i);
                this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                this.mv.visitInsn(1);
                break;
            }
            case 3: {
                this.mv.visitVarInsn(54, i);
                this.mv.visitVarInsn(21, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(21, i);
                this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                this.mv.visitInsn(1);
                break;
            }
            case 2: {
                this.mv.visitVarInsn(54, i);
                this.mv.visitVarInsn(21, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(21, i);
                this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                this.mv.visitInsn(1);
                break;
            }
            case 4: {
                this.mv.visitVarInsn(54, i);
                this.mv.visitVarInsn(21, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(21, i);
                this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                this.mv.visitInsn(1);
                break;
            }
            case 5: {
                this.mv.visitVarInsn(54, i);
                this.mv.visitVarInsn(21, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(21, i);
                this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                this.mv.visitInsn(1);
                break;
            }
            case 7: {
                this.mv.visitVarInsn(55, i);
                this.mv.visitVarInsn(22, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(22, i);
                this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                this.mv.visitInsn(1);
                break;
            }
            case 6: {
                this.mv.visitVarInsn(56, i);
                this.mv.visitVarInsn(23, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(23, i);
                this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                this.mv.visitInsn(1);
                break;
            }
            case 8: {
                this.mv.visitVarInsn(57, i);
                this.mv.visitVarInsn(24, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(24, i);
                this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                this.mv.visitInsn(1);
                break;
            }
            default: {
                this.mv.visitVarInsn(58, i);
                this.mv.visitVarInsn(25, i);
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitVarInsn(25, i);
                this.mv.visitInsn(1);
            }
        }
        this.mv.visitMethodInsn(184, TRACESUBCALL, END_METHOD, END_SIGNATURE, false);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        this.mv.visitLabel(endFinally);
        this.mv.visitInsn(89);
        int errIdx = this.newLocal(Type.getType(Throwable.class));
        this.mv.visitVarInsn(58, errIdx);
        this.mv.visitVarInsn(25, this.statIdx);
        this.mv.visitInsn(1);
        this.mv.visitVarInsn(25, errIdx);
        this.mv.visitMethodInsn(184, TRACESUBCALL, END_METHOD, END_SIGNATURE, false);
        this.mv.visitInsn(191);
        this.mv.visitMaxs(maxStack + 8, maxLocals + 2);
    }
}

