/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import java.util.HashSet;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.asm.IASM;
import scouter.agent.asm.StatementCV;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class JDBCStatementASM
implements IASM,
Opcodes {
    public final HashSet<String> target;

    public JDBCStatementASM() {
        this.target = HookingSet.getHookingClassSet(Configure.getInstance().hook_jdbc_stmt_classes);
        this.target.add("org/mariadb/jdbc/MariaDbStatement");
        this.target.add("org/mariadb/jdbc/MySQLStatement");
        this.target.add("oracle/jdbc/driver/OracleStatement");
        this.target.add("org/postgresql/jdbc/PgStatement");
        this.target.add("com/mysql/jdbc/StatementImpl");
        this.target.add("org/apache/derby/client/am/Statement");
        this.target.add("jdbc/FakeStatement");
        this.target.add("net/sourceforge/jtds/jdbc/JtdsStatement");
        this.target.add("com/microsoft/sqlserver/jdbc/SQLServerStatement");
        this.target.add("com/tmax/tibero/jdbc/TbStatement");
        this.target.add("com/tmax/tibero/jdbc/driver/TbStatement");
        this.target.add("org/hsqldb/jdbc/JDBCStatement");
        this.target.add("cubrid/jdbc/driver/CUBRIDStatement");
        this.target.add("Altibase/jdbc/driver/AltibaseStatement");
        this.target.add("Altibase/jdbc/driver/ABStatement");
        this.target.add("org/h2/jdbc/JdbcStatement");
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!Configure.getInstance()._hook_dbsql_enabled) {
            return cv;
        }
        if (!this.target.contains(className)) {
            return cv;
        }
        Logger.println("A108", "jdbc stmt found: " + className);
        return new StatementCV(cv);
    }
}

