/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.IASM;
import scouter.agent.asm.JspServletCV;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.util.Pair;

public class JspServletASM
implements IASM,
Opcodes {
    private Map<String, HookingSet> target;

    public JspServletASM() {
        this.target = HookingSet.getHookingSet(Configure.getInstance().hook_jsp_patterns);
        AsmUtil.add(this.target, "org/apache/jasper/servlet/JspServlet", "serviceJspFile");
        for (int i = JspTargetRegister.klassMethod.size() - 1; i >= 0; --i) {
            AsmUtil.add(this.target, JspTargetRegister.klassMethod.get(i).getLeft(), JspTargetRegister.klassMethod.get(i).getRight());
        }
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!Configure.getInstance()._hook_jsp_enabled) {
            return cv;
        }
        HookingSet mset = this.target.get(className);
        if (mset == null) {
            return cv;
        }
        return new JspServletCV(cv, mset, className);
    }

    public static class JspTargetRegister {
        public static final List<Pair<String, String>> klassMethod = new ArrayList<Pair<String, String>>();

        public static void regist(String klass, String method) {
            klassMethod.add(new Pair<String, String>(klass, method));
        }
    }
}

