/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm.asyncsupport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.IASM;
import scouter.agent.asm.asyncsupport.HystrixCommandPrepareCV;
import scouter.agent.asm.asyncsupport.HystrixCommandReceiveCV;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class HystrixCommandASM
implements IASM,
Opcodes {
    private Configure conf = Configure.getInstance();
    private List<HookingSet> prepareTarget = HookingSet.getHookingMethodSet("");
    private List<HookingSet> receiveTarget = HookingSet.getHookingMethodSet("");
    private Map<String, HookingSet> prepareReserved = new HashMap<String, HookingSet>();
    private Map<String, HookingSet> receiveReserved = new HashMap<String, HookingSet>();

    public HystrixCommandASM() {
        AsmUtil.add(this.prepareReserved, "com/netflix/hystrix/HystrixCommand", "execute()Ljava/lang/Object;");
        AsmUtil.add(this.receiveReserved, "com/netflix/hystrix/contrib/javanica/command/GenericCommand", "run()Ljava/lang/Object;");
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        HookingSet mset = this.prepareReserved.get(className);
        if (mset != null) {
            return new HystrixCommandPrepareCV(cv, mset, className);
        }
        mset = this.receiveReserved.get(className);
        if (mset != null) {
            return new HystrixCommandReceiveCV(cv, mset, className);
        }
        return cv;
    }
}

