/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.asm.jdbc;

import scouter.agent.Logger;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.batch.trace.TraceContextManager;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.Type;
import scouter.org.objectweb.asm.commons.LocalVariablesSorter;

public class PsInitMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String TRACE = TraceContextManager.class.getName().replace('.', '/');
    private static final String METHOD = "getTraceSQL";
    private static final String SIGNATURE = "(Ljava/lang/String;)Lscouter/agent/batch/trace/TraceSQL;";
    private String owner;
    private int sqlIdx = -1;
    private boolean isUstatement = false;

    public PsInitMV(int access, String desc, MethodVisitor mv, String owner) {
        super(327680, access, desc, mv);
        this.owner = owner;
        this.sqlIdx = AsmUtil.getStringIdx(access, desc);
        if (this.sqlIdx < 0) {
            this.sqlIdx = AsmUtil.getIdxByType(access, desc, Type.getType("Lcubrid/jdbc/jci/UStatement;"));
            Logger.trace("CUBRID PSTMT LOAD - " + this.sqlIdx);
            this.isUstatement = true;
        }
    }

    @Override
    public void visitInsn(int opcode) {
        if (this.sqlIdx >= 0 && opcode >= 172 && opcode <= 177) {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, this.sqlIdx);
            if (this.isUstatement) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(182, "cubrid/jdbc/jci/UStatement", "getQuery", "()Ljava/lang/String;", false);
            }
            this.mv.visitMethodInsn(184, TRACE, METHOD, SIGNATURE, false);
            this.mv.visitFieldInsn(181, this.owner, "_current_trace_sql_", "Lscouter/agent/batch/trace/TraceSQL;");
        }
        this.mv.visitInsn(opcode);
    }
}

