/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang;

import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;

public class AlertRuleData {
    public String objType;
    public long checkInterval = 60000L;
    public String title;
    public byte level;
    public String condition;
    public String message;
    public long lastCheckTime;
    public boolean enabled = true;

    public AlertRuleData() {
    }

    public AlertRuleData(String objType, String title, byte level, String condition, String message) {
        this.objType = objType;
        this.title = title;
        this.level = level;
        this.condition = condition;
        this.message = message;
    }

    public void write(DataOutputX out) throws IOException {
        out.writeText(this.objType);
        out.writeLong(this.checkInterval);
        out.writeText(this.title);
        out.writeByte(this.level);
        out.writeText(this.condition);
        out.writeText(this.message);
        out.writeLong(this.lastCheckTime);
        out.writeBoolean(this.enabled);
    }

    public void read(DataInputX input) throws IOException {
        this.objType = input.readText();
        this.checkInterval = input.readLong();
        this.title = input.readText();
        this.level = input.readByte();
        this.condition = input.readText();
        this.message = input.readText();
        this.lastCheckTime = input.readLong();
        this.enabled = input.readBoolean();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlertRuleData other = (AlertRuleData)obj;
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    public String toString() {
        return "AlertData [objType=" + this.objType + ", checkInterval=" + this.checkInterval + ", title=" + this.title + ", level=" + this.level + ", condition=" + this.condition + ", message=" + this.message + "]";
    }
}

