/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.pack;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.Pack;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.MapValue;
import scouter.util.DateUtil;
import scouter.util.Hexa32;

public class BatchPack
implements Pack {
    public int objHash;
    public String objName;
    public String objType;
    public String batchJobId;
    public String args;
    public Integer pID;
    public long startTime;
    public long elapsedTime = 0L;
    public int threadCnt = 0;
    public long cpuTime = 0L;
    public long gcTime = 0L;
    public long gcCount = 0L;
    public int sqlTotalCnt = 0;
    public long sqlTotalTime = 0L;
    public long sqlTotalRows = 0L;
    public long sqlTotalRuns = 0L;
    public boolean isStack = false;
    public long position = 0L;
    public List<MapValue> sqlStats = null;
    public Map<Integer, String> uniqueSqls = null;
    public int index = 0;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Batch ");
        sb.append(DateUtil.timestamp(this.startTime));
        sb.append(" objHash=").append(Hexa32.toString32(this.objHash));
        sb.append(" JobId=").append(this.batchJobId);
        sb.append(" PID=").append(this.pID);
        sb.append(" elapsed=").append(this.elapsedTime);
        return sb.toString();
    }

    @Override
    public byte getPackType() {
        return 64;
    }

    public void writeSimple(DataOutputX out) throws IOException {
        DataOutputX o = new DataOutputX();
        this.writeInternal(o);
        out.writeBlob(o.toByteArray());
    }

    private void writeInternal(DataOutputX o) throws IOException {
        o.writeLong(this.startTime);
        o.writeInt(this.objHash);
        o.writeText(this.batchJobId);
        o.writeText(this.args);
        o.writeInt(this.pID);
        o.writeLong(this.elapsedTime);
        o.writeInt(this.threadCnt);
        o.writeLong(this.cpuTime);
        o.writeLong(this.gcTime);
        o.writeLong(this.gcCount);
        o.writeInt(this.sqlTotalCnt);
        o.writeLong(this.sqlTotalTime);
        o.writeLong(this.sqlTotalRows);
        o.writeLong(this.sqlTotalRuns);
        o.writeBoolean(this.isStack);
        o.writeText(this.objName);
        o.writeText(this.objType);
        o.writeLong(this.position);
    }

    @Override
    public void write(DataOutputX out) throws IOException {
        DataOutputX o = new DataOutputX();
        this.writeInternal(o);
        if (this.sqlTotalCnt > 0) {
            for (MapValue value : this.sqlStats) {
                o.writeInt((int)value.getLong("hashValue"));
                o.writeInt((int)value.getLong("runs"));
                o.writeLong(value.getLong("startTime"));
                o.writeLong(value.getLong("endTime"));
                o.writeLong(value.getLong("totalTime"));
                o.writeLong(value.getLong("minTime"));
                o.writeLong(value.getLong("maxTime"));
                o.writeLong(value.getLong("processedRows"));
                o.writeBoolean(value.getBoolean("rowed"));
            }
            for (Integer key : this.uniqueSqls.keySet()) {
                o.writeInt(key);
                o.writeText(this.uniqueSqls.get(key));
            }
        }
        out.writeBlob(o.toByteArray());
    }

    public Pack readSimplePack(byte[] data) throws IOException {
        DataInputX d = new DataInputX(data);
        d.readByte();
        byte[] internalData = d.readBlob();
        d = new DataInputX(internalData);
        this.readInternal(d);
        return this;
    }

    public Pack readSimple(DataInputX din) throws IOException {
        DataInputX d = new DataInputX(din.readBlob());
        this.readInternal(d);
        return this;
    }

    private void readInternal(DataInputX d) throws IOException {
        this.startTime = d.readLong();
        this.objHash = d.readInt();
        this.batchJobId = d.readText();
        this.args = d.readText();
        this.pID = d.readInt();
        this.elapsedTime = d.readLong();
        this.threadCnt = d.readInt();
        this.cpuTime = d.readLong();
        this.gcTime = d.readLong();
        this.gcCount = d.readLong();
        this.sqlTotalCnt = d.readInt();
        this.sqlTotalTime = d.readLong();
        this.sqlTotalRows = d.readLong();
        this.sqlTotalRuns = d.readLong();
        this.isStack = d.readBoolean();
        this.objName = d.readText();
        this.objType = d.readText();
        this.position = d.readLong();
    }

    @Override
    public Pack read(DataInputX din) throws IOException {
        DataInputX d = new DataInputX(din.readBlob());
        this.readInternal(d);
        if (this.sqlTotalCnt > 0) {
            int i;
            this.sqlStats = new ArrayList<MapValue>(this.sqlTotalCnt);
            for (i = 0; i < this.sqlTotalCnt; ++i) {
                MapValue value = new MapValue();
                this.sqlStats.add(value);
                value.put("hashValue", d.readInt());
                value.put("runs", d.readInt());
                value.put("startTime", d.readLong());
                value.put("endTime", d.readLong());
                value.put("totalTime", d.readLong());
                value.put("minTime", d.readLong());
                value.put("maxTime", d.readLong());
                value.put("processedRows", d.readLong());
                value.put("rowed", new BooleanValue(d.readBoolean()));
            }
            this.uniqueSqls = new HashMap<Integer, String>(this.sqlTotalCnt);
            for (i = 0; i < this.sqlTotalCnt; ++i) {
                this.uniqueSqls.put(d.readInt(), d.readText());
            }
        }
        return this;
    }
}

